/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.transfers;

import com.adyen.model.transfers.Amount;
import com.adyen.model.transfers.BalanceMutation;
import com.adyen.model.transfers.DirectDebitInformation;
import com.adyen.model.transfers.ExecutionDate;
import com.adyen.model.transfers.ExternalReason;
import com.adyen.model.transfers.JSON;
import com.adyen.model.transfers.PaymentInstrument;
import com.adyen.model.transfers.ResourceReference;
import com.adyen.model.transfers.TransactionRulesResult;
import com.adyen.model.transfers.TransferCategoryData;
import com.adyen.model.transfers.TransferDataTracking;
import com.adyen.model.transfers.TransferEvent;
import com.adyen.model.transfers.TransferNotificationCounterParty;
import com.adyen.model.transfers.TransferReview;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"accountHolder", "amount", "balanceAccount", "balancePlatform", "balances", "category", "categoryData", "counterparty", "createdAt", "creationDate", "description", "directDebitInformation", "direction", "eventId", "events", "executionDate", "externalReason", "id", "paymentInstrument", "reason", "reference", "referenceForBeneficiary", "review", "sequenceNumber", "status", "tracking", "transactionRulesResult", "type", "updatedAt"})
public class TransferData {
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER = "accountHolder";
    private ResourceReference accountHolder;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private Amount amount;
    public static final String JSON_PROPERTY_BALANCE_ACCOUNT = "balanceAccount";
    private ResourceReference balanceAccount;
    public static final String JSON_PROPERTY_BALANCE_PLATFORM = "balancePlatform";
    private String balancePlatform;
    public static final String JSON_PROPERTY_BALANCES = "balances";
    private List<BalanceMutation> balances;
    public static final String JSON_PROPERTY_CATEGORY = "category";
    private CategoryEnum category;
    public static final String JSON_PROPERTY_CATEGORY_DATA = "categoryData";
    private TransferCategoryData categoryData;
    public static final String JSON_PROPERTY_COUNTERPARTY = "counterparty";
    private TransferNotificationCounterParty counterparty;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
    @Deprecated
    private OffsetDateTime creationDate;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DIRECT_DEBIT_INFORMATION = "directDebitInformation";
    private DirectDebitInformation directDebitInformation;
    public static final String JSON_PROPERTY_DIRECTION = "direction";
    private DirectionEnum direction;
    public static final String JSON_PROPERTY_EVENT_ID = "eventId";
    private String eventId;
    public static final String JSON_PROPERTY_EVENTS = "events";
    private List<TransferEvent> events;
    public static final String JSON_PROPERTY_EXECUTION_DATE = "executionDate";
    private ExecutionDate executionDate;
    public static final String JSON_PROPERTY_EXTERNAL_REASON = "externalReason";
    private ExternalReason externalReason;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_PAYMENT_INSTRUMENT = "paymentInstrument";
    private PaymentInstrument paymentInstrument;
    public static final String JSON_PROPERTY_REASON = "reason";
    private ReasonEnum reason;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_REFERENCE_FOR_BENEFICIARY = "referenceForBeneficiary";
    private String referenceForBeneficiary;
    public static final String JSON_PROPERTY_REVIEW = "review";
    private TransferReview review;
    public static final String JSON_PROPERTY_SEQUENCE_NUMBER = "sequenceNumber";
    private Integer sequenceNumber;
    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;
    public static final String JSON_PROPERTY_TRACKING = "tracking";
    private TransferDataTracking tracking;
    public static final String JSON_PROPERTY_TRANSACTION_RULES_RESULT = "transactionRulesResult";
    private TransactionRulesResult transactionRulesResult;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_UPDATED_AT = "updatedAt";
    private OffsetDateTime updatedAt;

    public TransferData accountHolder(ResourceReference accountHolder) {
        this.accountHolder = accountHolder;
        return this;
    }

    @JsonProperty(value="accountHolder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResourceReference getAccountHolder() {
        return this.accountHolder;
    }

    @JsonProperty(value="accountHolder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolder(ResourceReference accountHolder) {
        this.accountHolder = accountHolder;
    }

    public TransferData amount(Amount amount) {
        this.amount = amount;
        return this;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(Amount amount) {
        this.amount = amount;
    }

    public TransferData balanceAccount(ResourceReference balanceAccount) {
        this.balanceAccount = balanceAccount;
        return this;
    }

    @JsonProperty(value="balanceAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ResourceReference getBalanceAccount() {
        return this.balanceAccount;
    }

    @JsonProperty(value="balanceAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalanceAccount(ResourceReference balanceAccount) {
        this.balanceAccount = balanceAccount;
    }

    public TransferData balancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
        return this;
    }

    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBalancePlatform() {
        return this.balancePlatform;
    }

    @JsonProperty(value="balancePlatform")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalancePlatform(String balancePlatform) {
        this.balancePlatform = balancePlatform;
    }

    public TransferData balances(List<BalanceMutation> balances) {
        this.balances = balances;
        return this;
    }

    public TransferData addBalancesItem(BalanceMutation balancesItem) {
        if (this.balances == null) {
            this.balances = new ArrayList<BalanceMutation>();
        }
        this.balances.add(balancesItem);
        return this;
    }

    @JsonProperty(value="balances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<BalanceMutation> getBalances() {
        return this.balances;
    }

    @JsonProperty(value="balances")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBalances(List<BalanceMutation> balances) {
        this.balances = balances;
    }

    public TransferData category(CategoryEnum category) {
        this.category = category;
        return this;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CategoryEnum getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public TransferData categoryData(TransferCategoryData categoryData) {
        this.categoryData = categoryData;
        return this;
    }

    @JsonProperty(value="categoryData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransferCategoryData getCategoryData() {
        return this.categoryData;
    }

    @JsonProperty(value="categoryData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCategoryData(TransferCategoryData categoryData) {
        this.categoryData = categoryData;
    }

    public TransferData counterparty(TransferNotificationCounterParty counterparty) {
        this.counterparty = counterparty;
        return this;
    }

    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransferNotificationCounterParty getCounterparty() {
        return this.counterparty;
    }

    @JsonProperty(value="counterparty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCounterparty(TransferNotificationCounterParty counterparty) {
        this.counterparty = counterparty;
    }

    public TransferData createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    @Deprecated
    public TransferData creationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Deprecated
    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    @Deprecated
    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public TransferData description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public TransferData directDebitInformation(DirectDebitInformation directDebitInformation) {
        this.directDebitInformation = directDebitInformation;
        return this;
    }

    @JsonProperty(value="directDebitInformation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DirectDebitInformation getDirectDebitInformation() {
        return this.directDebitInformation;
    }

    @JsonProperty(value="directDebitInformation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDirectDebitInformation(DirectDebitInformation directDebitInformation) {
        this.directDebitInformation = directDebitInformation;
    }

    public TransferData direction(DirectionEnum direction) {
        this.direction = direction;
        return this;
    }

    @JsonProperty(value="direction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DirectionEnum getDirection() {
        return this.direction;
    }

    @JsonProperty(value="direction")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDirection(DirectionEnum direction) {
        this.direction = direction;
    }

    public TransferData eventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @JsonProperty(value="eventId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEventId() {
        return this.eventId;
    }

    @JsonProperty(value="eventId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public TransferData events(List<TransferEvent> events) {
        this.events = events;
        return this;
    }

    public TransferData addEventsItem(TransferEvent eventsItem) {
        if (this.events == null) {
            this.events = new ArrayList<TransferEvent>();
        }
        this.events.add(eventsItem);
        return this;
    }

    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TransferEvent> getEvents() {
        return this.events;
    }

    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEvents(List<TransferEvent> events) {
        this.events = events;
    }

    public TransferData executionDate(ExecutionDate executionDate) {
        this.executionDate = executionDate;
        return this;
    }

    @JsonProperty(value="executionDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ExecutionDate getExecutionDate() {
        return this.executionDate;
    }

    @JsonProperty(value="executionDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExecutionDate(ExecutionDate executionDate) {
        this.executionDate = executionDate;
    }

    public TransferData externalReason(ExternalReason externalReason) {
        this.externalReason = externalReason;
        return this;
    }

    @JsonProperty(value="externalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ExternalReason getExternalReason() {
        return this.externalReason;
    }

    @JsonProperty(value="externalReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalReason(ExternalReason externalReason) {
        this.externalReason = externalReason;
    }

    public TransferData id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public TransferData paymentInstrument(PaymentInstrument paymentInstrument) {
        this.paymentInstrument = paymentInstrument;
        return this;
    }

    @JsonProperty(value="paymentInstrument")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PaymentInstrument getPaymentInstrument() {
        return this.paymentInstrument;
    }

    @JsonProperty(value="paymentInstrument")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentInstrument(PaymentInstrument paymentInstrument) {
        this.paymentInstrument = paymentInstrument;
    }

    public TransferData reason(ReasonEnum reason) {
        this.reason = reason;
        return this;
    }

    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ReasonEnum getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReason(ReasonEnum reason) {
        this.reason = reason;
    }

    public TransferData reference(String reference) {
        this.reference = reference;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public TransferData referenceForBeneficiary(String referenceForBeneficiary) {
        this.referenceForBeneficiary = referenceForBeneficiary;
        return this;
    }

    @JsonProperty(value="referenceForBeneficiary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReferenceForBeneficiary() {
        return this.referenceForBeneficiary;
    }

    @JsonProperty(value="referenceForBeneficiary")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferenceForBeneficiary(String referenceForBeneficiary) {
        this.referenceForBeneficiary = referenceForBeneficiary;
    }

    public TransferData review(TransferReview review) {
        this.review = review;
        return this;
    }

    @JsonProperty(value="review")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransferReview getReview() {
        return this.review;
    }

    @JsonProperty(value="review")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReview(TransferReview review) {
        this.review = review;
    }

    public TransferData sequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
        return this;
    }

    @JsonProperty(value="sequenceNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    @JsonProperty(value="sequenceNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public TransferData status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StatusEnum getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public TransferData tracking(TransferDataTracking tracking) {
        this.tracking = tracking;
        return this;
    }

    @JsonProperty(value="tracking")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransferDataTracking getTracking() {
        return this.tracking;
    }

    @JsonProperty(value="tracking")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTracking(TransferDataTracking tracking) {
        this.tracking = tracking;
    }

    public TransferData transactionRulesResult(TransactionRulesResult transactionRulesResult) {
        this.transactionRulesResult = transactionRulesResult;
        return this;
    }

    @JsonProperty(value="transactionRulesResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransactionRulesResult getTransactionRulesResult() {
        return this.transactionRulesResult;
    }

    @JsonProperty(value="transactionRulesResult")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransactionRulesResult(TransactionRulesResult transactionRulesResult) {
        this.transactionRulesResult = transactionRulesResult;
    }

    public TransferData type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public TransferData updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updatedAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferData transferData = (TransferData)o;
        return Objects.equals(this.accountHolder, transferData.accountHolder) && Objects.equals(this.amount, transferData.amount) && Objects.equals(this.balanceAccount, transferData.balanceAccount) && Objects.equals(this.balancePlatform, transferData.balancePlatform) && Objects.equals(this.balances, transferData.balances) && Objects.equals((Object)this.category, (Object)transferData.category) && Objects.equals(this.categoryData, transferData.categoryData) && Objects.equals(this.counterparty, transferData.counterparty) && Objects.equals(this.createdAt, transferData.createdAt) && Objects.equals(this.creationDate, transferData.creationDate) && Objects.equals(this.description, transferData.description) && Objects.equals(this.directDebitInformation, transferData.directDebitInformation) && Objects.equals((Object)this.direction, (Object)transferData.direction) && Objects.equals(this.eventId, transferData.eventId) && Objects.equals(this.events, transferData.events) && Objects.equals(this.executionDate, transferData.executionDate) && Objects.equals(this.externalReason, transferData.externalReason) && Objects.equals(this.id, transferData.id) && Objects.equals(this.paymentInstrument, transferData.paymentInstrument) && Objects.equals((Object)this.reason, (Object)transferData.reason) && Objects.equals(this.reference, transferData.reference) && Objects.equals(this.referenceForBeneficiary, transferData.referenceForBeneficiary) && Objects.equals(this.review, transferData.review) && Objects.equals(this.sequenceNumber, transferData.sequenceNumber) && Objects.equals((Object)this.status, (Object)transferData.status) && Objects.equals(this.tracking, transferData.tracking) && Objects.equals(this.transactionRulesResult, transferData.transactionRulesResult) && Objects.equals((Object)this.type, (Object)transferData.type) && Objects.equals(this.updatedAt, transferData.updatedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountHolder, this.amount, this.balanceAccount, this.balancePlatform, this.balances, this.category, this.categoryData, this.counterparty, this.createdAt, this.creationDate, this.description, this.directDebitInformation, this.direction, this.eventId, this.events, this.executionDate, this.externalReason, this.id, this.paymentInstrument, this.reason, this.reference, this.referenceForBeneficiary, this.review, this.sequenceNumber, this.status, this.tracking, this.transactionRulesResult, this.type, this.updatedAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferData {\n");
        sb.append("    accountHolder: ").append(this.toIndentedString(this.accountHolder)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    balanceAccount: ").append(this.toIndentedString(this.balanceAccount)).append("\n");
        sb.append("    balancePlatform: ").append(this.toIndentedString(this.balancePlatform)).append("\n");
        sb.append("    balances: ").append(this.toIndentedString(this.balances)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    categoryData: ").append(this.toIndentedString(this.categoryData)).append("\n");
        sb.append("    counterparty: ").append(this.toIndentedString(this.counterparty)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    directDebitInformation: ").append(this.toIndentedString(this.directDebitInformation)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    executionDate: ").append(this.toIndentedString(this.executionDate)).append("\n");
        sb.append("    externalReason: ").append(this.toIndentedString(this.externalReason)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    paymentInstrument: ").append(this.toIndentedString(this.paymentInstrument)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString((Object)this.reason)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    referenceForBeneficiary: ").append(this.toIndentedString(this.referenceForBeneficiary)).append("\n");
        sb.append("    review: ").append(this.toIndentedString(this.review)).append("\n");
        sb.append("    sequenceNumber: ").append(this.toIndentedString(this.sequenceNumber)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    tracking: ").append(this.toIndentedString(this.tracking)).append("\n");
        sb.append("    transactionRulesResult: ").append(this.toIndentedString(this.transactionRulesResult)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TransferData fromJson(String jsonString) throws JsonProcessingException {
        return (TransferData)JSON.getMapper().readValue(jsonString, TransferData.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        PAYMENT(String.valueOf("payment")),
        CAPTURE(String.valueOf("capture")),
        CAPTUREREVERSAL(String.valueOf("captureReversal")),
        REFUND(String.valueOf("refund")),
        REFUNDREVERSAL(String.valueOf("refundReversal")),
        CHARGEBACK(String.valueOf("chargeback")),
        CHARGEBACKCORRECTION(String.valueOf("chargebackCorrection")),
        CHARGEBACKREVERSAL(String.valueOf("chargebackReversal")),
        CHARGEBACKREVERSALCORRECTION(String.valueOf("chargebackReversalCorrection")),
        SECONDCHARGEBACK(String.valueOf("secondChargeback")),
        SECONDCHARGEBACKCORRECTION(String.valueOf("secondChargebackCorrection")),
        ATMWITHDRAWAL(String.valueOf("atmWithdrawal")),
        ATMWITHDRAWALREVERSAL(String.valueOf("atmWithdrawalReversal")),
        INTERNALTRANSFER(String.valueOf("internalTransfer")),
        INTERNALDIRECTDEBIT(String.valueOf("internalDirectDebit")),
        MANUALCORRECTION(String.valueOf("manualCorrection")),
        INVOICEDEDUCTION(String.valueOf("invoiceDeduction")),
        DEPOSITCORRECTION(String.valueOf("depositCorrection")),
        RESERVEADJUSTMENT(String.valueOf("reserveAdjustment")),
        BANKTRANSFER(String.valueOf("bankTransfer")),
        BANKDIRECTDEBIT(String.valueOf("bankDirectDebit")),
        CARDTRANSFER(String.valueOf("cardTransfer")),
        MISCCOST(String.valueOf("miscCost")),
        PAYMENTCOST(String.valueOf("paymentCost")),
        FEE(String.valueOf("fee")),
        LEFTOVER(String.valueOf("leftover")),
        GRANT(String.valueOf("grant")),
        CAPITALFUNDSCOLLECTION(String.valueOf("capitalFundsCollection")),
        CASHOUTINSTRUCTION(String.valueOf("cashOutInstruction")),
        CASHOUTFEE(String.valueOf("cashoutFee")),
        CASHOUTREPAYMENT(String.valueOf("cashoutRepayment")),
        CASHOUTFUNDING(String.valueOf("cashoutFunding")),
        REPAYMENT(String.valueOf("repayment")),
        INSTALLMENT(String.valueOf("installment")),
        INSTALLMENTREVERSAL(String.valueOf("installmentReversal")),
        BALANCEADJUSTMENT(String.valueOf("balanceAdjustment")),
        BALANCEROLLOVER(String.valueOf("balanceRollover")),
        BALANCEMIGRATION(String.valueOf("balanceMigration"));

        private static final Logger LOG;
        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("TypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])TypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(TypeEnum.class.getName());
        }
    }

    public static enum StatusEnum {
        APPROVALPENDING(String.valueOf("approvalPending")),
        ATMWITHDRAWAL(String.valueOf("atmWithdrawal")),
        ATMWITHDRAWALREVERSALPENDING(String.valueOf("atmWithdrawalReversalPending")),
        ATMWITHDRAWALREVERSED(String.valueOf("atmWithdrawalReversed")),
        AUTHADJUSTMENTAUTHORISED(String.valueOf("authAdjustmentAuthorised")),
        AUTHADJUSTMENTERROR(String.valueOf("authAdjustmentError")),
        AUTHADJUSTMENTREFUSED(String.valueOf("authAdjustmentRefused")),
        AUTHORISED(String.valueOf("authorised")),
        BANKTRANSFER(String.valueOf("bankTransfer")),
        BANKTRANSFERPENDING(String.valueOf("bankTransferPending")),
        BOOKED(String.valueOf("booked")),
        BOOKINGPENDING(String.valueOf("bookingPending")),
        CANCELLED(String.valueOf("cancelled")),
        CAPTUREPENDING(String.valueOf("capturePending")),
        CAPTUREREVERSALPENDING(String.valueOf("captureReversalPending")),
        CAPTUREREVERSED(String.valueOf("captureReversed")),
        CAPTURED(String.valueOf("captured")),
        CAPTUREDEXTERNALLY(String.valueOf("capturedExternally")),
        CHARGEBACK(String.valueOf("chargeback")),
        CHARGEBACKEXTERNALLY(String.valueOf("chargebackExternally")),
        CHARGEBACKPENDING(String.valueOf("chargebackPending")),
        CHARGEBACKREVERSALPENDING(String.valueOf("chargebackReversalPending")),
        CHARGEBACKREVERSED(String.valueOf("chargebackReversed")),
        CREDITED(String.valueOf("credited")),
        DEPOSITCORRECTION(String.valueOf("depositCorrection")),
        DEPOSITCORRECTIONPENDING(String.valueOf("depositCorrectionPending")),
        DISPUTE(String.valueOf("dispute")),
        DISPUTECLOSED(String.valueOf("disputeClosed")),
        DISPUTEEXPIRED(String.valueOf("disputeExpired")),
        DISPUTENEEDSREVIEW(String.valueOf("disputeNeedsReview")),
        ERROR(String.valueOf("error")),
        EXPIRED(String.valueOf("expired")),
        FAILED(String.valueOf("failed")),
        FEE(String.valueOf("fee")),
        FEEPENDING(String.valueOf("feePending")),
        INTERNALTRANSFER(String.valueOf("internalTransfer")),
        INTERNALTRANSFERPENDING(String.valueOf("internalTransferPending")),
        INVOICEDEDUCTION(String.valueOf("invoiceDeduction")),
        INVOICEDEDUCTIONPENDING(String.valueOf("invoiceDeductionPending")),
        MANUALCORRECTIONPENDING(String.valueOf("manualCorrectionPending")),
        MANUALLYCORRECTED(String.valueOf("manuallyCorrected")),
        MATCHEDSTATEMENT(String.valueOf("matchedStatement")),
        MATCHEDSTATEMENTPENDING(String.valueOf("matchedStatementPending")),
        MERCHANTPAYIN(String.valueOf("merchantPayin")),
        MERCHANTPAYINPENDING(String.valueOf("merchantPayinPending")),
        MERCHANTPAYINREVERSED(String.valueOf("merchantPayinReversed")),
        MERCHANTPAYINREVERSEDPENDING(String.valueOf("merchantPayinReversedPending")),
        MISCCOST(String.valueOf("miscCost")),
        MISCCOSTPENDING(String.valueOf("miscCostPending")),
        PAYMENTCOST(String.valueOf("paymentCost")),
        PAYMENTCOSTPENDING(String.valueOf("paymentCostPending")),
        PENDINGAPPROVAL(String.valueOf("pendingApproval")),
        PENDINGEXECUTION(String.valueOf("pendingExecution")),
        RECEIVED(String.valueOf("received")),
        REFUNDPENDING(String.valueOf("refundPending")),
        REFUNDREVERSALPENDING(String.valueOf("refundReversalPending")),
        REFUNDREVERSED(String.valueOf("refundReversed")),
        REFUNDED(String.valueOf("refunded")),
        REFUNDEDEXTERNALLY(String.valueOf("refundedExternally")),
        REFUSED(String.valueOf("refused")),
        REJECTED(String.valueOf("rejected")),
        RESERVEADJUSTMENT(String.valueOf("reserveAdjustment")),
        RESERVEADJUSTMENTPENDING(String.valueOf("reserveAdjustmentPending")),
        RETURNED(String.valueOf("returned")),
        SECONDCHARGEBACK(String.valueOf("secondChargeback")),
        SECONDCHARGEBACKPENDING(String.valueOf("secondChargebackPending")),
        UNDEFINED(String.valueOf("undefined"));

        private static final Logger LOG;
        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("StatusEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])StatusEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(StatusEnum.class.getName());
        }
    }

    public static enum ReasonEnum {
        ACCOUNTHIERARCHYNOTACTIVE(String.valueOf("accountHierarchyNotActive")),
        AMOUNTLIMITEXCEEDED(String.valueOf("amountLimitExceeded")),
        APPROVALEXPIRED(String.valueOf("approvalExpired")),
        APPROVED(String.valueOf("approved")),
        BALANCEACCOUNTTEMPORARILYBLOCKEDBYTRANSACTIONRULE(String.valueOf("balanceAccountTemporarilyBlockedByTransactionRule")),
        COUNTERPARTYACCOUNTBLOCKED(String.valueOf("counterpartyAccountBlocked")),
        COUNTERPARTYACCOUNTCLOSED(String.valueOf("counterpartyAccountClosed")),
        COUNTERPARTYACCOUNTNOTFOUND(String.valueOf("counterpartyAccountNotFound")),
        COUNTERPARTYADDRESSREQUIRED(String.valueOf("counterpartyAddressRequired")),
        COUNTERPARTYBANKTIMEDOUT(String.valueOf("counterpartyBankTimedOut")),
        COUNTERPARTYBANKUNAVAILABLE(String.valueOf("counterpartyBankUnavailable")),
        DECLINED(String.valueOf("declined")),
        DECLINEDBYTRANSACTIONRULE(String.valueOf("declinedByTransactionRule")),
        DIRECTDEBITNOTSUPPORTED(String.valueOf("directDebitNotSupported")),
        ERROR(String.valueOf("error")),
        NOTENOUGHBALANCE(String.valueOf("notEnoughBalance")),
        PENDING(String.valueOf("pending")),
        PENDINGAPPROVAL(String.valueOf("pendingApproval")),
        PENDINGEXECUTION(String.valueOf("pendingExecution")),
        REFUSEDBYCOUNTERPARTYBANK(String.valueOf("refusedByCounterpartyBank")),
        REFUSEDBYCUSTOMER(String.valueOf("refusedByCustomer")),
        ROUTENOTFOUND(String.valueOf("routeNotFound")),
        SCAFAILED(String.valueOf("scaFailed")),
        TRANSFERINSTRUMENTDOESNOTEXIST(String.valueOf("transferInstrumentDoesNotExist")),
        UNKNOWN(String.valueOf("unknown"));

        private static final Logger LOG;
        private String value;

        private ReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ReasonEnum fromValue(String value) {
            for (ReasonEnum b : ReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("ReasonEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])ReasonEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(ReasonEnum.class.getName());
        }
    }

    public static enum DirectionEnum {
        INCOMING(String.valueOf("incoming")),
        OUTGOING(String.valueOf("outgoing"));

        private static final Logger LOG;
        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DirectionEnum fromValue(String value) {
            for (DirectionEnum b : DirectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("DirectionEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])DirectionEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(DirectionEnum.class.getName());
        }
    }

    public static enum CategoryEnum {
        BANK(String.valueOf("bank")),
        CARD(String.valueOf("card")),
        INTERNAL(String.valueOf("internal")),
        ISSUEDCARD(String.valueOf("issuedCard")),
        PLATFORMPAYMENT(String.valueOf("platformPayment")),
        TOPUP(String.valueOf("topUp"));

        private static final Logger LOG;
        private String value;

        private CategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CategoryEnum fromValue(String value) {
            for (CategoryEnum b : CategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("CategoryEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])CategoryEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(CategoryEnum.class.getName());
        }
    }
}

