/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.payment;

import com.adyen.model.payment.Amount;
import com.adyen.model.payment.JSON;
import com.adyen.model.payment.PlatformChargebackLogic;
import com.adyen.model.payment.Split;
import com.adyen.model.payment.ThreeDSecureData;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonPropertyOrder(value={"additionalData", "merchantAccount", "modificationAmount", "mpiData", "originalMerchantReference", "originalReference", "platformChargebackLogic", "reference", "splits", "tenderReference", "uniqueTerminalId"})
public class CaptureRequest {
    public static final String JSON_PROPERTY_ADDITIONAL_DATA = "additionalData";
    private Map<String, String> additionalData;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT = "merchantAccount";
    private String merchantAccount;
    public static final String JSON_PROPERTY_MODIFICATION_AMOUNT = "modificationAmount";
    private Amount modificationAmount;
    public static final String JSON_PROPERTY_MPI_DATA = "mpiData";
    private ThreeDSecureData mpiData;
    public static final String JSON_PROPERTY_ORIGINAL_MERCHANT_REFERENCE = "originalMerchantReference";
    private String originalMerchantReference;
    public static final String JSON_PROPERTY_ORIGINAL_REFERENCE = "originalReference";
    private String originalReference;
    public static final String JSON_PROPERTY_PLATFORM_CHARGEBACK_LOGIC = "platformChargebackLogic";
    private PlatformChargebackLogic platformChargebackLogic;
    public static final String JSON_PROPERTY_REFERENCE = "reference";
    private String reference;
    public static final String JSON_PROPERTY_SPLITS = "splits";
    private List<Split> splits;
    public static final String JSON_PROPERTY_TENDER_REFERENCE = "tenderReference";
    private String tenderReference;
    public static final String JSON_PROPERTY_UNIQUE_TERMINAL_ID = "uniqueTerminalId";
    private String uniqueTerminalId;

    public CaptureRequest additionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
        return this;
    }

    public CaptureRequest putAdditionalDataItem(String key, String additionalDataItem) {
        if (this.additionalData == null) {
            this.additionalData = new HashMap<String, String>();
        }
        this.additionalData.put(key, additionalDataItem);
        return this;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getAdditionalData() {
        return this.additionalData;
    }

    @JsonProperty(value="additionalData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalData(Map<String, String> additionalData) {
        this.additionalData = additionalData;
    }

    public CaptureRequest merchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
        return this;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccount() {
        return this.merchantAccount;
    }

    @JsonProperty(value="merchantAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccount(String merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    public CaptureRequest modificationAmount(Amount modificationAmount) {
        this.modificationAmount = modificationAmount;
        return this;
    }

    @JsonProperty(value="modificationAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Amount getModificationAmount() {
        return this.modificationAmount;
    }

    @JsonProperty(value="modificationAmount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModificationAmount(Amount modificationAmount) {
        this.modificationAmount = modificationAmount;
    }

    public CaptureRequest mpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
        return this;
    }

    @JsonProperty(value="mpiData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ThreeDSecureData getMpiData() {
        return this.mpiData;
    }

    @JsonProperty(value="mpiData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMpiData(ThreeDSecureData mpiData) {
        this.mpiData = mpiData;
    }

    public CaptureRequest originalMerchantReference(String originalMerchantReference) {
        this.originalMerchantReference = originalMerchantReference;
        return this;
    }

    @JsonProperty(value="originalMerchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOriginalMerchantReference() {
        return this.originalMerchantReference;
    }

    @JsonProperty(value="originalMerchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOriginalMerchantReference(String originalMerchantReference) {
        this.originalMerchantReference = originalMerchantReference;
    }

    public CaptureRequest originalReference(String originalReference) {
        this.originalReference = originalReference;
        return this;
    }

    @JsonProperty(value="originalReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOriginalReference() {
        return this.originalReference;
    }

    @JsonProperty(value="originalReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOriginalReference(String originalReference) {
        this.originalReference = originalReference;
    }

    public CaptureRequest platformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
        this.platformChargebackLogic = platformChargebackLogic;
        return this;
    }

    @JsonProperty(value="platformChargebackLogic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PlatformChargebackLogic getPlatformChargebackLogic() {
        return this.platformChargebackLogic;
    }

    @JsonProperty(value="platformChargebackLogic")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPlatformChargebackLogic(PlatformChargebackLogic platformChargebackLogic) {
        this.platformChargebackLogic = platformChargebackLogic;
    }

    public CaptureRequest reference(String reference) {
        this.reference = reference;
        return this;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReference() {
        return this.reference;
    }

    @JsonProperty(value="reference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReference(String reference) {
        this.reference = reference;
    }

    public CaptureRequest splits(List<Split> splits) {
        this.splits = splits;
        return this;
    }

    public CaptureRequest addSplitsItem(Split splitsItem) {
        if (this.splits == null) {
            this.splits = new ArrayList<Split>();
        }
        this.splits.add(splitsItem);
        return this;
    }

    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Split> getSplits() {
        return this.splits;
    }

    @JsonProperty(value="splits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public CaptureRequest tenderReference(String tenderReference) {
        this.tenderReference = tenderReference;
        return this;
    }

    @JsonProperty(value="tenderReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTenderReference() {
        return this.tenderReference;
    }

    @JsonProperty(value="tenderReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTenderReference(String tenderReference) {
        this.tenderReference = tenderReference;
    }

    public CaptureRequest uniqueTerminalId(String uniqueTerminalId) {
        this.uniqueTerminalId = uniqueTerminalId;
        return this;
    }

    @JsonProperty(value="uniqueTerminalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUniqueTerminalId() {
        return this.uniqueTerminalId;
    }

    @JsonProperty(value="uniqueTerminalId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUniqueTerminalId(String uniqueTerminalId) {
        this.uniqueTerminalId = uniqueTerminalId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaptureRequest captureRequest = (CaptureRequest)o;
        return Objects.equals(this.additionalData, captureRequest.additionalData) && Objects.equals(this.merchantAccount, captureRequest.merchantAccount) && Objects.equals(this.modificationAmount, captureRequest.modificationAmount) && Objects.equals(this.mpiData, captureRequest.mpiData) && Objects.equals(this.originalMerchantReference, captureRequest.originalMerchantReference) && Objects.equals(this.originalReference, captureRequest.originalReference) && Objects.equals(this.platformChargebackLogic, captureRequest.platformChargebackLogic) && Objects.equals(this.reference, captureRequest.reference) && Objects.equals(this.splits, captureRequest.splits) && Objects.equals(this.tenderReference, captureRequest.tenderReference) && Objects.equals(this.uniqueTerminalId, captureRequest.uniqueTerminalId);
    }

    public int hashCode() {
        return Objects.hash(this.additionalData, this.merchantAccount, this.modificationAmount, this.mpiData, this.originalMerchantReference, this.originalReference, this.platformChargebackLogic, this.reference, this.splits, this.tenderReference, this.uniqueTerminalId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CaptureRequest {\n");
        sb.append("    additionalData: ").append(this.toIndentedString(this.additionalData)).append("\n");
        sb.append("    merchantAccount: ").append(this.toIndentedString(this.merchantAccount)).append("\n");
        sb.append("    modificationAmount: ").append(this.toIndentedString(this.modificationAmount)).append("\n");
        sb.append("    mpiData: ").append(this.toIndentedString(this.mpiData)).append("\n");
        sb.append("    originalMerchantReference: ").append(this.toIndentedString(this.originalMerchantReference)).append("\n");
        sb.append("    originalReference: ").append(this.toIndentedString(this.originalReference)).append("\n");
        sb.append("    platformChargebackLogic: ").append(this.toIndentedString(this.platformChargebackLogic)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("    splits: ").append(this.toIndentedString(this.splits)).append("\n");
        sb.append("    tenderReference: ").append(this.toIndentedString(this.tenderReference)).append("\n");
        sb.append("    uniqueTerminalId: ").append(this.toIndentedString(this.uniqueTerminalId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static CaptureRequest fromJson(String jsonString) throws JsonProcessingException {
        return (CaptureRequest)JSON.getMapper().readValue(jsonString, CaptureRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

