/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.Address;
import com.adyen.model.legalentitymanagement.JSON;
import com.adyen.model.legalentitymanagement.TaxInformation;
import com.adyen.model.legalentitymanagement.UndefinedBeneficiary;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

@JsonPropertyOrder(value={"countryOfGoverningLaw", "dateOfIncorporation", "description", "doingBusinessAs", "name", "principalPlaceOfBusiness", "registeredAddress", "registrationNumber", "taxInformation", "type", "undefinedBeneficiaryInfo", "vatAbsenceReason", "vatNumber"})
public class Trust {
    public static final String JSON_PROPERTY_COUNTRY_OF_GOVERNING_LAW = "countryOfGoverningLaw";
    private String countryOfGoverningLaw;
    public static final String JSON_PROPERTY_DATE_OF_INCORPORATION = "dateOfIncorporation";
    private String dateOfIncorporation;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_DOING_BUSINESS_AS = "doingBusinessAs";
    private String doingBusinessAs;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_PRINCIPAL_PLACE_OF_BUSINESS = "principalPlaceOfBusiness";
    private Address principalPlaceOfBusiness;
    public static final String JSON_PROPERTY_REGISTERED_ADDRESS = "registeredAddress";
    private Address registeredAddress;
    public static final String JSON_PROPERTY_REGISTRATION_NUMBER = "registrationNumber";
    private String registrationNumber;
    public static final String JSON_PROPERTY_TAX_INFORMATION = "taxInformation";
    private List<TaxInformation> taxInformation;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_UNDEFINED_BENEFICIARY_INFO = "undefinedBeneficiaryInfo";
    private List<UndefinedBeneficiary> undefinedBeneficiaryInfo;
    public static final String JSON_PROPERTY_VAT_ABSENCE_REASON = "vatAbsenceReason";
    private VatAbsenceReasonEnum vatAbsenceReason;
    public static final String JSON_PROPERTY_VAT_NUMBER = "vatNumber";
    private String vatNumber;

    public Trust countryOfGoverningLaw(String countryOfGoverningLaw) {
        this.countryOfGoverningLaw = countryOfGoverningLaw;
        return this;
    }

    @JsonProperty(value="countryOfGoverningLaw")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryOfGoverningLaw() {
        return this.countryOfGoverningLaw;
    }

    @JsonProperty(value="countryOfGoverningLaw")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountryOfGoverningLaw(String countryOfGoverningLaw) {
        this.countryOfGoverningLaw = countryOfGoverningLaw;
    }

    public Trust dateOfIncorporation(String dateOfIncorporation) {
        this.dateOfIncorporation = dateOfIncorporation;
        return this;
    }

    @JsonProperty(value="dateOfIncorporation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDateOfIncorporation() {
        return this.dateOfIncorporation;
    }

    @JsonProperty(value="dateOfIncorporation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDateOfIncorporation(String dateOfIncorporation) {
        this.dateOfIncorporation = dateOfIncorporation;
    }

    public Trust description(String description) {
        this.description = description;
        return this;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public Trust doingBusinessAs(String doingBusinessAs) {
        this.doingBusinessAs = doingBusinessAs;
        return this;
    }

    @JsonProperty(value="doingBusinessAs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDoingBusinessAs() {
        return this.doingBusinessAs;
    }

    @JsonProperty(value="doingBusinessAs")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDoingBusinessAs(String doingBusinessAs) {
        this.doingBusinessAs = doingBusinessAs;
    }

    public Trust name(String name) {
        this.name = name;
        return this;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public Trust principalPlaceOfBusiness(Address principalPlaceOfBusiness) {
        this.principalPlaceOfBusiness = principalPlaceOfBusiness;
        return this;
    }

    @JsonProperty(value="principalPlaceOfBusiness")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getPrincipalPlaceOfBusiness() {
        return this.principalPlaceOfBusiness;
    }

    @JsonProperty(value="principalPlaceOfBusiness")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrincipalPlaceOfBusiness(Address principalPlaceOfBusiness) {
        this.principalPlaceOfBusiness = principalPlaceOfBusiness;
    }

    public Trust registeredAddress(Address registeredAddress) {
        this.registeredAddress = registeredAddress;
        return this;
    }

    @JsonProperty(value="registeredAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Address getRegisteredAddress() {
        return this.registeredAddress;
    }

    @JsonProperty(value="registeredAddress")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRegisteredAddress(Address registeredAddress) {
        this.registeredAddress = registeredAddress;
    }

    public Trust registrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
        return this;
    }

    @JsonProperty(value="registrationNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegistrationNumber() {
        return this.registrationNumber;
    }

    @JsonProperty(value="registrationNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRegistrationNumber(String registrationNumber) {
        this.registrationNumber = registrationNumber;
    }

    public Trust taxInformation(List<TaxInformation> taxInformation) {
        this.taxInformation = taxInformation;
        return this;
    }

    public Trust addTaxInformationItem(TaxInformation taxInformationItem) {
        if (this.taxInformation == null) {
            this.taxInformation = new ArrayList<TaxInformation>();
        }
        this.taxInformation.add(taxInformationItem);
        return this;
    }

    @JsonProperty(value="taxInformation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TaxInformation> getTaxInformation() {
        return this.taxInformation;
    }

    @JsonProperty(value="taxInformation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTaxInformation(List<TaxInformation> taxInformation) {
        this.taxInformation = taxInformation;
    }

    public Trust type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public Trust undefinedBeneficiaryInfo(List<UndefinedBeneficiary> undefinedBeneficiaryInfo) {
        this.undefinedBeneficiaryInfo = undefinedBeneficiaryInfo;
        return this;
    }

    public Trust addUndefinedBeneficiaryInfoItem(UndefinedBeneficiary undefinedBeneficiaryInfoItem) {
        if (this.undefinedBeneficiaryInfo == null) {
            this.undefinedBeneficiaryInfo = new ArrayList<UndefinedBeneficiary>();
        }
        this.undefinedBeneficiaryInfo.add(undefinedBeneficiaryInfoItem);
        return this;
    }

    @JsonProperty(value="undefinedBeneficiaryInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UndefinedBeneficiary> getUndefinedBeneficiaryInfo() {
        return this.undefinedBeneficiaryInfo;
    }

    @JsonProperty(value="undefinedBeneficiaryInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUndefinedBeneficiaryInfo(List<UndefinedBeneficiary> undefinedBeneficiaryInfo) {
        this.undefinedBeneficiaryInfo = undefinedBeneficiaryInfo;
    }

    public Trust vatAbsenceReason(VatAbsenceReasonEnum vatAbsenceReason) {
        this.vatAbsenceReason = vatAbsenceReason;
        return this;
    }

    @JsonProperty(value="vatAbsenceReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public VatAbsenceReasonEnum getVatAbsenceReason() {
        return this.vatAbsenceReason;
    }

    @JsonProperty(value="vatAbsenceReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVatAbsenceReason(VatAbsenceReasonEnum vatAbsenceReason) {
        this.vatAbsenceReason = vatAbsenceReason;
    }

    public Trust vatNumber(String vatNumber) {
        this.vatNumber = vatNumber;
        return this;
    }

    @JsonProperty(value="vatNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVatNumber() {
        return this.vatNumber;
    }

    @JsonProperty(value="vatNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVatNumber(String vatNumber) {
        this.vatNumber = vatNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Trust trust = (Trust)o;
        return Objects.equals(this.countryOfGoverningLaw, trust.countryOfGoverningLaw) && Objects.equals(this.dateOfIncorporation, trust.dateOfIncorporation) && Objects.equals(this.description, trust.description) && Objects.equals(this.doingBusinessAs, trust.doingBusinessAs) && Objects.equals(this.name, trust.name) && Objects.equals(this.principalPlaceOfBusiness, trust.principalPlaceOfBusiness) && Objects.equals(this.registeredAddress, trust.registeredAddress) && Objects.equals(this.registrationNumber, trust.registrationNumber) && Objects.equals(this.taxInformation, trust.taxInformation) && Objects.equals((Object)this.type, (Object)trust.type) && Objects.equals(this.undefinedBeneficiaryInfo, trust.undefinedBeneficiaryInfo) && Objects.equals((Object)this.vatAbsenceReason, (Object)trust.vatAbsenceReason) && Objects.equals(this.vatNumber, trust.vatNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.countryOfGoverningLaw, this.dateOfIncorporation, this.description, this.doingBusinessAs, this.name, this.principalPlaceOfBusiness, this.registeredAddress, this.registrationNumber, this.taxInformation, this.type, this.undefinedBeneficiaryInfo, this.vatAbsenceReason, this.vatNumber});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Trust {\n");
        sb.append("    countryOfGoverningLaw: ").append(this.toIndentedString(this.countryOfGoverningLaw)).append("\n");
        sb.append("    dateOfIncorporation: ").append(this.toIndentedString(this.dateOfIncorporation)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    doingBusinessAs: ").append(this.toIndentedString(this.doingBusinessAs)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    principalPlaceOfBusiness: ").append(this.toIndentedString(this.principalPlaceOfBusiness)).append("\n");
        sb.append("    registeredAddress: ").append(this.toIndentedString(this.registeredAddress)).append("\n");
        sb.append("    registrationNumber: ").append(this.toIndentedString(this.registrationNumber)).append("\n");
        sb.append("    taxInformation: ").append(this.toIndentedString(this.taxInformation)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    undefinedBeneficiaryInfo: ").append(this.toIndentedString(this.undefinedBeneficiaryInfo)).append("\n");
        sb.append("    vatAbsenceReason: ").append(this.toIndentedString((Object)this.vatAbsenceReason)).append("\n");
        sb.append("    vatNumber: ").append(this.toIndentedString(this.vatNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Trust fromJson(String jsonString) throws JsonProcessingException {
        return (Trust)JSON.getMapper().readValue(jsonString, Trust.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum VatAbsenceReasonEnum {
        INDUSTRYEXEMPTION(String.valueOf("industryExemption")),
        BELOWTAXTHRESHOLD(String.valueOf("belowTaxThreshold"));

        private static final Logger LOG;
        private String value;

        private VatAbsenceReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static VatAbsenceReasonEnum fromValue(String value) {
            for (VatAbsenceReasonEnum b : VatAbsenceReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("VatAbsenceReasonEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])VatAbsenceReasonEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(VatAbsenceReasonEnum.class.getName());
        }
    }

    public static enum TypeEnum {
        BUSINESSTRUST(String.valueOf("businessTrust")),
        CASHMANAGEMENTTRUST(String.valueOf("cashManagementTrust")),
        CHARITABLETRUST(String.valueOf("charitableTrust")),
        CORPORATEUNITTRUST(String.valueOf("corporateUnitTrust")),
        DECEASEDESTATE(String.valueOf("deceasedEstate")),
        DISCRETIONARYTRUST(String.valueOf("discretionaryTrust")),
        DISCRETIONARYINVESTMENTTRUST(String.valueOf("discretionaryInvestmentTrust")),
        DISCRETIONARYSERVICESMANAGEMENTTRUST(String.valueOf("discretionaryServicesManagementTrust")),
        DISCRETIONARYTRADINGTRUST(String.valueOf("discretionaryTradingTrust")),
        FAMILYTRUST(String.valueOf("familyTrust")),
        FIRSTHOMESAVERACCOUNTSTRUST(String.valueOf("firstHomeSaverAccountsTrust")),
        FIXEDTRUST(String.valueOf("fixedTrust")),
        FIXEDUNITTRUST(String.valueOf("fixedUnitTrust")),
        HYBRIDTRUST(String.valueOf("hybridTrust")),
        LISTEDPUBLICUNITTRUST(String.valueOf("listedPublicUnitTrust")),
        OTHERTRUST(String.valueOf("otherTrust")),
        POOLEDSUPERANNUATIONTRUST(String.valueOf("pooledSuperannuationTrust")),
        PUBLICTRADINGTRUST(String.valueOf("publicTradingTrust")),
        UNLISTEDPUBLICUNITTRUST(String.valueOf("unlistedPublicUnitTrust"));

        private static final Logger LOG;
        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            LOG.warning("TypeEnum: unexpected enum value '" + value + "' - Supported values are " + Arrays.toString((Object[])TypeEnum.values()));
            return null;
        }

        static {
            LOG = Logger.getLogger(TypeEnum.class.getName());
        }
    }
}

