/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpaywebhooks;

import com.adyen.model.marketpaywebhooks.Amount;
import com.adyen.model.marketpaywebhooks.BankAccountDetail;
import com.adyen.model.marketpaywebhooks.ErrorFieldType;
import com.adyen.model.marketpaywebhooks.JSON;
import com.adyen.model.marketpaywebhooks.OperationStatus;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"accountCode", "accountHolderCode", "amounts", "bankAccountDetail", "description", "estimatedArrivalDate", "invalidFields", "merchantReference", "originalPspReference", "payoutAccountCountry", "payoutAccountNumber", "payoutBalanceAccountId", "payoutBankName", "payoutBranchCode", "payoutReference", "payoutSpeed", "status"})
public class AccountHolderPayoutNotificationContent {
    public static final String JSON_PROPERTY_ACCOUNT_CODE = "accountCode";
    private String accountCode;
    public static final String JSON_PROPERTY_ACCOUNT_HOLDER_CODE = "accountHolderCode";
    private String accountHolderCode;
    public static final String JSON_PROPERTY_AMOUNTS = "amounts";
    private List<Amount> amounts = null;
    public static final String JSON_PROPERTY_BANK_ACCOUNT_DETAIL = "bankAccountDetail";
    private BankAccountDetail bankAccountDetail;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ESTIMATED_ARRIVAL_DATE = "estimatedArrivalDate";
    private LocalDate estimatedArrivalDate;
    public static final String JSON_PROPERTY_INVALID_FIELDS = "invalidFields";
    private List<ErrorFieldType> invalidFields = null;
    public static final String JSON_PROPERTY_MERCHANT_REFERENCE = "merchantReference";
    private String merchantReference;
    public static final String JSON_PROPERTY_ORIGINAL_PSP_REFERENCE = "originalPspReference";
    private String originalPspReference;
    public static final String JSON_PROPERTY_PAYOUT_ACCOUNT_COUNTRY = "payoutAccountCountry";
    private String payoutAccountCountry;
    public static final String JSON_PROPERTY_PAYOUT_ACCOUNT_NUMBER = "payoutAccountNumber";
    private String payoutAccountNumber;
    public static final String JSON_PROPERTY_PAYOUT_BALANCE_ACCOUNT_ID = "payoutBalanceAccountId";
    private String payoutBalanceAccountId;
    public static final String JSON_PROPERTY_PAYOUT_BANK_NAME = "payoutBankName";
    private String payoutBankName;
    public static final String JSON_PROPERTY_PAYOUT_BRANCH_CODE = "payoutBranchCode";
    private String payoutBranchCode;
    public static final String JSON_PROPERTY_PAYOUT_REFERENCE = "payoutReference";
    private Long payoutReference;
    public static final String JSON_PROPERTY_PAYOUT_SPEED = "payoutSpeed";
    private PayoutSpeedEnum payoutSpeed;
    public static final String JSON_PROPERTY_STATUS = "status";
    private OperationStatus status;

    public AccountHolderPayoutNotificationContent accountCode(String accountCode) {
        this.accountCode = accountCode;
        return this;
    }

    @ApiModelProperty(value="The code of the account from which the payout was made.")
    @JsonProperty(value="accountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountCode() {
        return this.accountCode;
    }

    @JsonProperty(value="accountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public AccountHolderPayoutNotificationContent accountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
        return this;
    }

    @ApiModelProperty(value="The code of the Account Holder to which the payout was made.")
    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountHolderCode() {
        return this.accountHolderCode;
    }

    @JsonProperty(value="accountHolderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountHolderCode(String accountHolderCode) {
        this.accountHolderCode = accountHolderCode;
    }

    public AccountHolderPayoutNotificationContent amounts(List<Amount> amounts) {
        this.amounts = amounts;
        return this;
    }

    public AccountHolderPayoutNotificationContent addAmountsItem(Amount amountsItem) {
        if (this.amounts == null) {
            this.amounts = new ArrayList<Amount>();
        }
        this.amounts.add(amountsItem);
        return this;
    }

    @ApiModelProperty(value="The payout amounts (per currency).")
    @JsonProperty(value="amounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Amount> getAmounts() {
        return this.amounts;
    }

    @JsonProperty(value="amounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmounts(List<Amount> amounts) {
        this.amounts = amounts;
    }

    public AccountHolderPayoutNotificationContent bankAccountDetail(BankAccountDetail bankAccountDetail) {
        this.bankAccountDetail = bankAccountDetail;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="bankAccountDetail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BankAccountDetail getBankAccountDetail() {
        return this.bankAccountDetail;
    }

    @JsonProperty(value="bankAccountDetail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankAccountDetail(BankAccountDetail bankAccountDetail) {
        this.bankAccountDetail = bankAccountDetail;
    }

    public AccountHolderPayoutNotificationContent description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="A description of the payout.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public AccountHolderPayoutNotificationContent estimatedArrivalDate(LocalDate estimatedArrivalDate) {
        this.estimatedArrivalDate = estimatedArrivalDate;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="estimatedArrivalDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LocalDate getEstimatedArrivalDate() {
        return this.estimatedArrivalDate;
    }

    @JsonProperty(value="estimatedArrivalDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEstimatedArrivalDate(LocalDate estimatedArrivalDate) {
        this.estimatedArrivalDate = estimatedArrivalDate;
    }

    public AccountHolderPayoutNotificationContent invalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
        return this;
    }

    public AccountHolderPayoutNotificationContent addInvalidFieldsItem(ErrorFieldType invalidFieldsItem) {
        if (this.invalidFields == null) {
            this.invalidFields = new ArrayList<ErrorFieldType>();
        }
        this.invalidFields.add(invalidFieldsItem);
        return this;
    }

    @ApiModelProperty(value="Invalid fields list.")
    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ErrorFieldType> getInvalidFields() {
        return this.invalidFields;
    }

    @JsonProperty(value="invalidFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInvalidFields(List<ErrorFieldType> invalidFields) {
        this.invalidFields = invalidFields;
    }

    public AccountHolderPayoutNotificationContent merchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
        return this;
    }

    @ApiModelProperty(value="The merchant reference.")
    @JsonProperty(value="merchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantReference() {
        return this.merchantReference;
    }

    @JsonProperty(value="merchantReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantReference(String merchantReference) {
        this.merchantReference = merchantReference;
    }

    public AccountHolderPayoutNotificationContent originalPspReference(String originalPspReference) {
        this.originalPspReference = originalPspReference;
        return this;
    }

    @ApiModelProperty(value="The PSP reference of the original payout.")
    @JsonProperty(value="originalPspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOriginalPspReference() {
        return this.originalPspReference;
    }

    @JsonProperty(value="originalPspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOriginalPspReference(String originalPspReference) {
        this.originalPspReference = originalPspReference;
    }

    public AccountHolderPayoutNotificationContent payoutAccountCountry(String payoutAccountCountry) {
        this.payoutAccountCountry = payoutAccountCountry;
        return this;
    }

    @ApiModelProperty(value="The country code of the bank from which the payout was initiated.")
    @JsonProperty(value="payoutAccountCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayoutAccountCountry() {
        return this.payoutAccountCountry;
    }

    @JsonProperty(value="payoutAccountCountry")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutAccountCountry(String payoutAccountCountry) {
        this.payoutAccountCountry = payoutAccountCountry;
    }

    public AccountHolderPayoutNotificationContent payoutAccountNumber(String payoutAccountNumber) {
        this.payoutAccountNumber = payoutAccountNumber;
        return this;
    }

    @ApiModelProperty(value="The account number of the bank from which the payout was initiated.")
    @JsonProperty(value="payoutAccountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayoutAccountNumber() {
        return this.payoutAccountNumber;
    }

    @JsonProperty(value="payoutAccountNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutAccountNumber(String payoutAccountNumber) {
        this.payoutAccountNumber = payoutAccountNumber;
    }

    public AccountHolderPayoutNotificationContent payoutBalanceAccountId(String payoutBalanceAccountId) {
        this.payoutBalanceAccountId = payoutBalanceAccountId;
        return this;
    }

    @ApiModelProperty(value="The balance account id to which payment was made")
    @JsonProperty(value="payoutBalanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayoutBalanceAccountId() {
        return this.payoutBalanceAccountId;
    }

    @JsonProperty(value="payoutBalanceAccountId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutBalanceAccountId(String payoutBalanceAccountId) {
        this.payoutBalanceAccountId = payoutBalanceAccountId;
    }

    public AccountHolderPayoutNotificationContent payoutBankName(String payoutBankName) {
        this.payoutBankName = payoutBankName;
        return this;
    }

    @ApiModelProperty(value="The name of the bank the payout from which the payout was initiated.")
    @JsonProperty(value="payoutBankName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayoutBankName() {
        return this.payoutBankName;
    }

    @JsonProperty(value="payoutBankName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutBankName(String payoutBankName) {
        this.payoutBankName = payoutBankName;
    }

    public AccountHolderPayoutNotificationContent payoutBranchCode(String payoutBranchCode) {
        this.payoutBranchCode = payoutBranchCode;
        return this;
    }

    @ApiModelProperty(value="The branch code of the bank from which the payout was initiated.")
    @JsonProperty(value="payoutBranchCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPayoutBranchCode() {
        return this.payoutBranchCode;
    }

    @JsonProperty(value="payoutBranchCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutBranchCode(String payoutBranchCode) {
        this.payoutBranchCode = payoutBranchCode;
    }

    public AccountHolderPayoutNotificationContent payoutReference(Long payoutReference) {
        this.payoutReference = payoutReference;
        return this;
    }

    @ApiModelProperty(value="The unique payout identifier.")
    @JsonProperty(value="payoutReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getPayoutReference() {
        return this.payoutReference;
    }

    @JsonProperty(value="payoutReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutReference(Long payoutReference) {
        this.payoutReference = payoutReference;
    }

    public AccountHolderPayoutNotificationContent payoutSpeed(PayoutSpeedEnum payoutSpeed) {
        this.payoutSpeed = payoutSpeed;
        return this;
    }

    @ApiModelProperty(value="Speed with which payouts for this account are processed. Permitted values: `STANDARD`, `SAME_DAY`.")
    @JsonProperty(value="payoutSpeed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PayoutSpeedEnum getPayoutSpeed() {
        return this.payoutSpeed;
    }

    @JsonProperty(value="payoutSpeed")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPayoutSpeed(PayoutSpeedEnum payoutSpeed) {
        this.payoutSpeed = payoutSpeed;
    }

    public AccountHolderPayoutNotificationContent status(OperationStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OperationStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(OperationStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountHolderPayoutNotificationContent accountHolderPayoutNotificationContent = (AccountHolderPayoutNotificationContent)o;
        return Objects.equals(this.accountCode, accountHolderPayoutNotificationContent.accountCode) && Objects.equals(this.accountHolderCode, accountHolderPayoutNotificationContent.accountHolderCode) && Objects.equals(this.amounts, accountHolderPayoutNotificationContent.amounts) && Objects.equals(this.bankAccountDetail, accountHolderPayoutNotificationContent.bankAccountDetail) && Objects.equals(this.description, accountHolderPayoutNotificationContent.description) && Objects.equals(this.estimatedArrivalDate, accountHolderPayoutNotificationContent.estimatedArrivalDate) && Objects.equals(this.invalidFields, accountHolderPayoutNotificationContent.invalidFields) && Objects.equals(this.merchantReference, accountHolderPayoutNotificationContent.merchantReference) && Objects.equals(this.originalPspReference, accountHolderPayoutNotificationContent.originalPspReference) && Objects.equals(this.payoutAccountCountry, accountHolderPayoutNotificationContent.payoutAccountCountry) && Objects.equals(this.payoutAccountNumber, accountHolderPayoutNotificationContent.payoutAccountNumber) && Objects.equals(this.payoutBalanceAccountId, accountHolderPayoutNotificationContent.payoutBalanceAccountId) && Objects.equals(this.payoutBankName, accountHolderPayoutNotificationContent.payoutBankName) && Objects.equals(this.payoutBranchCode, accountHolderPayoutNotificationContent.payoutBranchCode) && Objects.equals(this.payoutReference, accountHolderPayoutNotificationContent.payoutReference) && Objects.equals((Object)this.payoutSpeed, (Object)accountHolderPayoutNotificationContent.payoutSpeed) && Objects.equals(this.status, accountHolderPayoutNotificationContent.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountCode, this.accountHolderCode, this.amounts, this.bankAccountDetail, this.description, this.estimatedArrivalDate, this.invalidFields, this.merchantReference, this.originalPspReference, this.payoutAccountCountry, this.payoutAccountNumber, this.payoutBalanceAccountId, this.payoutBankName, this.payoutBranchCode, this.payoutReference, this.payoutSpeed, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountHolderPayoutNotificationContent {\n");
        sb.append("    accountCode: ").append(this.toIndentedString(this.accountCode)).append("\n");
        sb.append("    accountHolderCode: ").append(this.toIndentedString(this.accountHolderCode)).append("\n");
        sb.append("    amounts: ").append(this.toIndentedString(this.amounts)).append("\n");
        sb.append("    bankAccountDetail: ").append(this.toIndentedString(this.bankAccountDetail)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    estimatedArrivalDate: ").append(this.toIndentedString(this.estimatedArrivalDate)).append("\n");
        sb.append("    invalidFields: ").append(this.toIndentedString(this.invalidFields)).append("\n");
        sb.append("    merchantReference: ").append(this.toIndentedString(this.merchantReference)).append("\n");
        sb.append("    originalPspReference: ").append(this.toIndentedString(this.originalPspReference)).append("\n");
        sb.append("    payoutAccountCountry: ").append(this.toIndentedString(this.payoutAccountCountry)).append("\n");
        sb.append("    payoutAccountNumber: ").append(this.toIndentedString(this.payoutAccountNumber)).append("\n");
        sb.append("    payoutBalanceAccountId: ").append(this.toIndentedString(this.payoutBalanceAccountId)).append("\n");
        sb.append("    payoutBankName: ").append(this.toIndentedString(this.payoutBankName)).append("\n");
        sb.append("    payoutBranchCode: ").append(this.toIndentedString(this.payoutBranchCode)).append("\n");
        sb.append("    payoutReference: ").append(this.toIndentedString(this.payoutReference)).append("\n");
        sb.append("    payoutSpeed: ").append(this.toIndentedString((Object)this.payoutSpeed)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AccountHolderPayoutNotificationContent fromJson(String jsonString) throws JsonProcessingException {
        return (AccountHolderPayoutNotificationContent)JSON.getMapper().readValue(jsonString, AccountHolderPayoutNotificationContent.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum PayoutSpeedEnum {
        INSTANT("INSTANT"),
        SAME_DAY("SAME_DAY"),
        STANDARD("STANDARD");

        private String value;

        private PayoutSpeedEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PayoutSpeedEnum fromValue(String value) {
            for (PayoutSpeedEnum b : PayoutSpeedEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

