/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.marketpayaccount;

import com.adyen.model.marketpayaccount.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"field", "fieldName", "shareholderCode"})
public class FieldType {
    public static final String JSON_PROPERTY_FIELD = "field";
    private String field;
    public static final String JSON_PROPERTY_FIELD_NAME = "fieldName";
    private FieldNameEnum fieldName;
    public static final String JSON_PROPERTY_SHAREHOLDER_CODE = "shareholderCode";
    private String shareholderCode;

    public FieldType field(String field) {
        this.field = field;
        return this;
    }

    @ApiModelProperty(value="The full name of the property.")
    @JsonProperty(value="field")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getField() {
        return this.field;
    }

    @JsonProperty(value="field")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setField(String field) {
        this.field = field;
    }

    public FieldType fieldName(FieldNameEnum fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    @ApiModelProperty(value="The type of the field.")
    @JsonProperty(value="fieldName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FieldNameEnum getFieldName() {
        return this.fieldName;
    }

    @JsonProperty(value="fieldName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFieldName(FieldNameEnum fieldName) {
        this.fieldName = fieldName;
    }

    public FieldType shareholderCode(String shareholderCode) {
        this.shareholderCode = shareholderCode;
        return this;
    }

    @ApiModelProperty(value="The code of the shareholder that the field belongs to. If empty, the field belongs to an account holder.")
    @JsonProperty(value="shareholderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getShareholderCode() {
        return this.shareholderCode;
    }

    @JsonProperty(value="shareholderCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShareholderCode(String shareholderCode) {
        this.shareholderCode = shareholderCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldType fieldType = (FieldType)o;
        return Objects.equals(this.field, fieldType.field) && Objects.equals((Object)this.fieldName, (Object)fieldType.fieldName) && Objects.equals(this.shareholderCode, fieldType.shareholderCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.fieldName, this.shareholderCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FieldType {\n");
        sb.append("    field: ").append(this.toIndentedString(this.field)).append("\n");
        sb.append("    fieldName: ").append(this.toIndentedString((Object)this.fieldName)).append("\n");
        sb.append("    shareholderCode: ").append(this.toIndentedString(this.shareholderCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static FieldType fromJson(String jsonString) throws JsonProcessingException {
        return (FieldType)JSON.getMapper().readValue(jsonString, FieldType.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum FieldNameEnum {
        ACCOUNTCODE("accountCode"),
        ACCOUNTHOLDERCODE("accountHolderCode"),
        ACCOUNTHOLDERDETAILS("accountHolderDetails"),
        ACCOUNTNUMBER("accountNumber"),
        ACCOUNTSTATETYPE("accountStateType"),
        ACCOUNTSTATUS("accountStatus"),
        ACCOUNTTYPE("accountType"),
        ADDRESS("address"),
        BALANCEACCOUNT("balanceAccount"),
        BALANCEACCOUNTACTIVE("balanceAccountActive"),
        BALANCEACCOUNTCODE("balanceAccountCode"),
        BALANCEACCOUNTID("balanceAccountId"),
        BANKACCOUNT("bankAccount"),
        BANKACCOUNTCODE("bankAccountCode"),
        BANKACCOUNTNAME("bankAccountName"),
        BANKACCOUNTUUID("bankAccountUUID"),
        BANKBICSWIFT("bankBicSwift"),
        BANKCITY("bankCity"),
        BANKCODE("bankCode"),
        BANKNAME("bankName"),
        BANKSTATEMENT("bankStatement"),
        BRANCHCODE("branchCode"),
        BUSINESSCONTACT("businessContact"),
        CARDTOKEN("cardToken"),
        CHECKCODE("checkCode"),
        CITY("city"),
        COMPANYREGISTRATION("companyRegistration"),
        CONSTITUTIONALDOCUMENT("constitutionalDocument"),
        CONTROLLER("controller"),
        COUNTRY("country"),
        COUNTRYCODE("countryCode"),
        CURRENCY("currency"),
        CURRENCYCODE("currencyCode"),
        DATEOFBIRTH("dateOfBirth"),
        DESCRIPTION("description"),
        DESTINATIONACCOUNTCODE("destinationAccountCode"),
        DOCUMENT("document"),
        DOCUMENTCONTENT("documentContent"),
        DOCUMENTEXPIRATIONDATE("documentExpirationDate"),
        DOCUMENTISSUERCOUNTRY("documentIssuerCountry"),
        DOCUMENTISSUERSTATE("documentIssuerState"),
        DOCUMENTNAME("documentName"),
        DOCUMENTNUMBER("documentNumber"),
        DOCUMENTTYPE("documentType"),
        DOINGBUSINESSAS("doingBusinessAs"),
        DRIVINGLICENCE("drivingLicence"),
        DRIVINGLICENCEBACK("drivingLicenceBack"),
        DRIVINGLICENCEFRONT("drivingLicenceFront"),
        DRIVINGLICENSE("drivingLicense"),
        EMAIL("email"),
        FIRSTNAME("firstName"),
        FORMTYPE("formType"),
        FULLPHONENUMBER("fullPhoneNumber"),
        GENDER("gender"),
        HOPWEBSERVICEUSER("hopWebserviceUser"),
        HOUSENUMBERORNAME("houseNumberOrName"),
        IBAN("iban"),
        IDCARD("idCard"),
        IDCARDBACK("idCardBack"),
        IDCARDFRONT("idCardFront"),
        IDNUMBER("idNumber"),
        IDENTITYDOCUMENT("identityDocument"),
        INDIVIDUALDETAILS("individualDetails"),
        INFIX("infix"),
        JOBTITLE("jobTitle"),
        LASTNAME("lastName"),
        LASTREVIEWDATE("lastReviewDate"),
        LEGALARRANGEMENT("legalArrangement"),
        LEGALARRANGEMENTCODE("legalArrangementCode"),
        LEGALARRANGEMENTENTITY("legalArrangementEntity"),
        LEGALARRANGEMENTENTITYCODE("legalArrangementEntityCode"),
        LEGALARRANGEMENTLEGALFORM("legalArrangementLegalForm"),
        LEGALARRANGEMENTMEMBER("legalArrangementMember"),
        LEGALARRANGEMENTMEMBERS("legalArrangementMembers"),
        LEGALARRANGEMENTNAME("legalArrangementName"),
        LEGALARRANGEMENTREFERENCE("legalArrangementReference"),
        LEGALARRANGEMENTREGISTRATIONNUMBER("legalArrangementRegistrationNumber"),
        LEGALARRANGEMENTTAXNUMBER("legalArrangementTaxNumber"),
        LEGALARRANGEMENTTYPE("legalArrangementType"),
        LEGALBUSINESSNAME("legalBusinessName"),
        LEGALENTITY("legalEntity"),
        LEGALENTITYTYPE("legalEntityType"),
        LOGO("logo"),
        MERCHANTACCOUNT("merchantAccount"),
        MERCHANTCATEGORYCODE("merchantCategoryCode"),
        MERCHANTHOUSENUMBER("merchantHouseNumber"),
        MERCHANTREFERENCE("merchantReference"),
        MICRODEPOSIT("microDeposit"),
        NAME("name"),
        NATIONALITY("nationality"),
        ORIGINALREFERENCE("originalReference"),
        OWNERCITY("ownerCity"),
        OWNERCOUNTRYCODE("ownerCountryCode"),
        OWNERDATEOFBIRTH("ownerDateOfBirth"),
        OWNERHOUSENUMBERORNAME("ownerHouseNumberOrName"),
        OWNERNAME("ownerName"),
        OWNERPOSTALCODE("ownerPostalCode"),
        OWNERSTATE("ownerState"),
        OWNERSTREET("ownerStreet"),
        PASSPORT("passport"),
        PASSPORTNUMBER("passportNumber"),
        PAYOUTMETHOD("payoutMethod"),
        PAYOUTMETHODCODE("payoutMethodCode"),
        PAYOUTSCHEDULE("payoutSchedule"),
        PCISELFASSESSMENT("pciSelfAssessment"),
        PERSONALDATA("personalData"),
        PHONECOUNTRYCODE("phoneCountryCode"),
        PHONENUMBER("phoneNumber"),
        POSTALCODE("postalCode"),
        PRIMARYCURRENCY("primaryCurrency"),
        REASON("reason"),
        REGISTRATIONNUMBER("registrationNumber"),
        RETURNURL("returnUrl"),
        SCHEDULE("schedule"),
        SHAREHOLDER("shareholder"),
        SHAREHOLDERCODE("shareholderCode"),
        SHAREHOLDERCODEANDSIGNATORYCODE("shareholderCodeAndSignatoryCode"),
        SHAREHOLDERCODEORSIGNATORYCODE("shareholderCodeOrSignatoryCode"),
        SHAREHOLDERTYPE("shareholderType"),
        SHAREHOLDERTYPES("shareholderTypes"),
        SHOPPERINTERACTION("shopperInteraction"),
        SIGNATORY("signatory"),
        SIGNATORYCODE("signatoryCode"),
        SOCIALSECURITYNUMBER("socialSecurityNumber"),
        SOURCEACCOUNTCODE("sourceAccountCode"),
        SPLITACCOUNT("splitAccount"),
        SPLITCONFIGURATIONUUID("splitConfigurationUUID"),
        SPLITCURRENCY("splitCurrency"),
        SPLITVALUE("splitValue"),
        SPLITS("splits"),
        STATEORPROVINCE("stateOrProvince"),
        STATUS("status"),
        STOCKEXCHANGE("stockExchange"),
        STOCKNUMBER("stockNumber"),
        STOCKTICKER("stockTicker"),
        STORE("store"),
        STOREDETAIL("storeDetail"),
        STORENAME("storeName"),
        STOREREFERENCE("storeReference"),
        STREET("street"),
        TAXID("taxId"),
        TIER("tier"),
        TIERNUMBER("tierNumber"),
        TRANSFERCODE("transferCode"),
        ULTIMATEPARENTCOMPANY("ultimateParentCompany"),
        ULTIMATEPARENTCOMPANYADDRESSDETAILS("ultimateParentCompanyAddressDetails"),
        ULTIMATEPARENTCOMPANYADDRESSDETAILSCOUNTRY("ultimateParentCompanyAddressDetailsCountry"),
        ULTIMATEPARENTCOMPANYBUSINESSDETAILS("ultimateParentCompanyBusinessDetails"),
        ULTIMATEPARENTCOMPANYBUSINESSDETAILSLEGALBUSINESSNAME("ultimateParentCompanyBusinessDetailsLegalBusinessName"),
        ULTIMATEPARENTCOMPANYBUSINESSDETAILSREGISTRATIONNUMBER("ultimateParentCompanyBusinessDetailsRegistrationNumber"),
        ULTIMATEPARENTCOMPANYCODE("ultimateParentCompanyCode"),
        ULTIMATEPARENTCOMPANYSTOCKEXCHANGE("ultimateParentCompanyStockExchange"),
        ULTIMATEPARENTCOMPANYSTOCKNUMBER("ultimateParentCompanyStockNumber"),
        ULTIMATEPARENTCOMPANYSTOCKNUMBERORSTOCKTICKER("ultimateParentCompanyStockNumberOrStockTicker"),
        ULTIMATEPARENTCOMPANYSTOCKTICKER("ultimateParentCompanyStockTicker"),
        UNKNOWN("unknown"),
        VALUE("value"),
        VERIFICATIONTYPE("verificationType"),
        VIRTUALACCOUNT("virtualAccount"),
        VISANUMBER("visaNumber"),
        WEBADDRESS("webAddress"),
        YEAR("year");

        private String value;

        private FieldNameEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FieldNameEnum fromValue(String value) {
            for (FieldNameEnum b : FieldNameEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

