/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.adyen.model.management.AdditionalSettings;
import com.adyen.model.management.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"acceptsExpiredCertificate", "acceptsSelfSignedCertificate", "acceptsUntrustedRootCertificate", "active", "additionalSettings", "communicationFormat", "description", "encryptionProtocol", "filterMerchantAccountType", "filterMerchantAccounts", "networkType", "password", "populateSoapActionHeader", "url", "username"})
public class UpdateCompanyWebhookRequest {
    public static final String JSON_PROPERTY_ACCEPTS_EXPIRED_CERTIFICATE = "acceptsExpiredCertificate";
    private Boolean acceptsExpiredCertificate;
    public static final String JSON_PROPERTY_ACCEPTS_SELF_SIGNED_CERTIFICATE = "acceptsSelfSignedCertificate";
    private Boolean acceptsSelfSignedCertificate;
    public static final String JSON_PROPERTY_ACCEPTS_UNTRUSTED_ROOT_CERTIFICATE = "acceptsUntrustedRootCertificate";
    private Boolean acceptsUntrustedRootCertificate;
    public static final String JSON_PROPERTY_ACTIVE = "active";
    private Boolean active;
    public static final String JSON_PROPERTY_ADDITIONAL_SETTINGS = "additionalSettings";
    private AdditionalSettings additionalSettings;
    public static final String JSON_PROPERTY_COMMUNICATION_FORMAT = "communicationFormat";
    private CommunicationFormatEnum communicationFormat;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_ENCRYPTION_PROTOCOL = "encryptionProtocol";
    private EncryptionProtocolEnum encryptionProtocol;
    public static final String JSON_PROPERTY_FILTER_MERCHANT_ACCOUNT_TYPE = "filterMerchantAccountType";
    private FilterMerchantAccountTypeEnum filterMerchantAccountType;
    public static final String JSON_PROPERTY_FILTER_MERCHANT_ACCOUNTS = "filterMerchantAccounts";
    private List<String> filterMerchantAccounts = null;
    public static final String JSON_PROPERTY_NETWORK_TYPE = "networkType";
    private NetworkTypeEnum networkType;
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password;
    public static final String JSON_PROPERTY_POPULATE_SOAP_ACTION_HEADER = "populateSoapActionHeader";
    private Boolean populateSoapActionHeader;
    public static final String JSON_PROPERTY_URL = "url";
    private String url;
    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;

    public UpdateCompanyWebhookRequest acceptsExpiredCertificate(Boolean acceptsExpiredCertificate) {
        this.acceptsExpiredCertificate = acceptsExpiredCertificate;
        return this;
    }

    @ApiModelProperty(value="Indicates if expired SSL certificates are accepted. Default value: **false**.")
    @JsonProperty(value="acceptsExpiredCertificate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAcceptsExpiredCertificate() {
        return this.acceptsExpiredCertificate;
    }

    @JsonProperty(value="acceptsExpiredCertificate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcceptsExpiredCertificate(Boolean acceptsExpiredCertificate) {
        this.acceptsExpiredCertificate = acceptsExpiredCertificate;
    }

    public UpdateCompanyWebhookRequest acceptsSelfSignedCertificate(Boolean acceptsSelfSignedCertificate) {
        this.acceptsSelfSignedCertificate = acceptsSelfSignedCertificate;
        return this;
    }

    @ApiModelProperty(value="Indicates if self-signed SSL certificates are accepted. Default value: **false**.")
    @JsonProperty(value="acceptsSelfSignedCertificate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAcceptsSelfSignedCertificate() {
        return this.acceptsSelfSignedCertificate;
    }

    @JsonProperty(value="acceptsSelfSignedCertificate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcceptsSelfSignedCertificate(Boolean acceptsSelfSignedCertificate) {
        this.acceptsSelfSignedCertificate = acceptsSelfSignedCertificate;
    }

    public UpdateCompanyWebhookRequest acceptsUntrustedRootCertificate(Boolean acceptsUntrustedRootCertificate) {
        this.acceptsUntrustedRootCertificate = acceptsUntrustedRootCertificate;
        return this;
    }

    @ApiModelProperty(value="Indicates if untrusted SSL certificates are accepted. Default value: **false**.")
    @JsonProperty(value="acceptsUntrustedRootCertificate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getAcceptsUntrustedRootCertificate() {
        return this.acceptsUntrustedRootCertificate;
    }

    @JsonProperty(value="acceptsUntrustedRootCertificate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcceptsUntrustedRootCertificate(Boolean acceptsUntrustedRootCertificate) {
        this.acceptsUntrustedRootCertificate = acceptsUntrustedRootCertificate;
    }

    public UpdateCompanyWebhookRequest active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(value="Indicates if the webhook configuration is active. The field must be **true** for us to send webhooks about events related an account.")
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActive(Boolean active) {
        this.active = active;
    }

    public UpdateCompanyWebhookRequest additionalSettings(AdditionalSettings additionalSettings) {
        this.additionalSettings = additionalSettings;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="additionalSettings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AdditionalSettings getAdditionalSettings() {
        return this.additionalSettings;
    }

    @JsonProperty(value="additionalSettings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdditionalSettings(AdditionalSettings additionalSettings) {
        this.additionalSettings = additionalSettings;
    }

    public UpdateCompanyWebhookRequest communicationFormat(CommunicationFormatEnum communicationFormat) {
        this.communicationFormat = communicationFormat;
        return this;
    }

    @ApiModelProperty(example="soap", value="Format or protocol for receiving webhooks. Possible values: * **soap** * **http** * **json** ")
    @JsonProperty(value="communicationFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public CommunicationFormatEnum getCommunicationFormat() {
        return this.communicationFormat;
    }

    @JsonProperty(value="communicationFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCommunicationFormat(CommunicationFormatEnum communicationFormat) {
        this.communicationFormat = communicationFormat;
    }

    public UpdateCompanyWebhookRequest description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Your description for this webhook configuration.")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public UpdateCompanyWebhookRequest encryptionProtocol(EncryptionProtocolEnum encryptionProtocol) {
        this.encryptionProtocol = encryptionProtocol;
        return this;
    }

    @ApiModelProperty(example="TLSv1.2", value="SSL version to access the public webhook URL specified in the `url` field. Possible values: * **TLSv1.3** * **TLSv1.2** * **HTTP** - Only allowed on Test environment.  If not specified, the webhook will use `sslVersion`: **TLSv1.2**.")
    @JsonProperty(value="encryptionProtocol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public EncryptionProtocolEnum getEncryptionProtocol() {
        return this.encryptionProtocol;
    }

    @JsonProperty(value="encryptionProtocol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEncryptionProtocol(EncryptionProtocolEnum encryptionProtocol) {
        this.encryptionProtocol = encryptionProtocol;
    }

    public UpdateCompanyWebhookRequest filterMerchantAccountType(FilterMerchantAccountTypeEnum filterMerchantAccountType) {
        this.filterMerchantAccountType = filterMerchantAccountType;
        return this;
    }

    @ApiModelProperty(value="Shows how merchant accounts are filtered when configuring the webhook. Possible values: * **includeAccounts**: The webhook is configured for the merchant accounts listed in `filterMerchantAccounts`. * **excludeAccounts**: The webhook is not configured for the merchant accounts listed in `filterMerchantAccounts`. * **allAccounts**: Includes all merchant accounts, and does not require specifying `filterMerchantAccounts`.")
    @JsonProperty(value="filterMerchantAccountType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FilterMerchantAccountTypeEnum getFilterMerchantAccountType() {
        return this.filterMerchantAccountType;
    }

    @JsonProperty(value="filterMerchantAccountType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilterMerchantAccountType(FilterMerchantAccountTypeEnum filterMerchantAccountType) {
        this.filterMerchantAccountType = filterMerchantAccountType;
    }

    public UpdateCompanyWebhookRequest filterMerchantAccounts(List<String> filterMerchantAccounts) {
        this.filterMerchantAccounts = filterMerchantAccounts;
        return this;
    }

    public UpdateCompanyWebhookRequest addFilterMerchantAccountsItem(String filterMerchantAccountsItem) {
        if (this.filterMerchantAccounts == null) {
            this.filterMerchantAccounts = new ArrayList<String>();
        }
        this.filterMerchantAccounts.add(filterMerchantAccountsItem);
        return this;
    }

    @ApiModelProperty(value="A list of merchant account names that are included or excluded from receiving the webhook. Inclusion or exclusion is based on the value defined for `filterMerchantAccountType`.  Required if `filterMerchantAccountType` is either: * **includeAccounts** * **excludeAccounts**  Not needed for `filterMerchantAccountType`: **allAccounts**.")
    @JsonProperty(value="filterMerchantAccounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getFilterMerchantAccounts() {
        return this.filterMerchantAccounts;
    }

    @JsonProperty(value="filterMerchantAccounts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilterMerchantAccounts(List<String> filterMerchantAccounts) {
        this.filterMerchantAccounts = filterMerchantAccounts;
    }

    public UpdateCompanyWebhookRequest networkType(NetworkTypeEnum networkType) {
        this.networkType = networkType;
        return this;
    }

    @ApiModelProperty(value="Network type for Terminal API notification webhooks. Possible values: * **public** * **local**  Default Value: **public**.")
    @JsonProperty(value="networkType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public NetworkTypeEnum getNetworkType() {
        return this.networkType;
    }

    @JsonProperty(value="networkType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetworkType(NetworkTypeEnum networkType) {
        this.networkType = networkType;
    }

    public UpdateCompanyWebhookRequest password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(value="Password to access the webhook URL.")
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(String password) {
        this.password = password;
    }

    public UpdateCompanyWebhookRequest populateSoapActionHeader(Boolean populateSoapActionHeader) {
        this.populateSoapActionHeader = populateSoapActionHeader;
        return this;
    }

    @ApiModelProperty(value="Indicates if the SOAP action header needs to be populated. Default value: **false**.  Only applies if `communicationFormat`: **soap**.")
    @JsonProperty(value="populateSoapActionHeader")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPopulateSoapActionHeader() {
        return this.populateSoapActionHeader;
    }

    @JsonProperty(value="populateSoapActionHeader")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPopulateSoapActionHeader(Boolean populateSoapActionHeader) {
        this.populateSoapActionHeader = populateSoapActionHeader;
    }

    public UpdateCompanyWebhookRequest url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="http://www.adyen.com", value="Public URL where webhooks will be sent, for example **https://www.domain.com/webhook-endpoint**.")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUrl(String url) {
        this.url = url;
    }

    public UpdateCompanyWebhookRequest username(String username) {
        this.username = username;
        return this;
    }

    @ApiModelProperty(value="Username to access the webhook URL.")
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateCompanyWebhookRequest updateCompanyWebhookRequest = (UpdateCompanyWebhookRequest)o;
        return Objects.equals(this.acceptsExpiredCertificate, updateCompanyWebhookRequest.acceptsExpiredCertificate) && Objects.equals(this.acceptsSelfSignedCertificate, updateCompanyWebhookRequest.acceptsSelfSignedCertificate) && Objects.equals(this.acceptsUntrustedRootCertificate, updateCompanyWebhookRequest.acceptsUntrustedRootCertificate) && Objects.equals(this.active, updateCompanyWebhookRequest.active) && Objects.equals(this.additionalSettings, updateCompanyWebhookRequest.additionalSettings) && Objects.equals((Object)this.communicationFormat, (Object)updateCompanyWebhookRequest.communicationFormat) && Objects.equals(this.description, updateCompanyWebhookRequest.description) && Objects.equals((Object)this.encryptionProtocol, (Object)updateCompanyWebhookRequest.encryptionProtocol) && Objects.equals((Object)this.filterMerchantAccountType, (Object)updateCompanyWebhookRequest.filterMerchantAccountType) && Objects.equals(this.filterMerchantAccounts, updateCompanyWebhookRequest.filterMerchantAccounts) && Objects.equals((Object)this.networkType, (Object)updateCompanyWebhookRequest.networkType) && Objects.equals(this.password, updateCompanyWebhookRequest.password) && Objects.equals(this.populateSoapActionHeader, updateCompanyWebhookRequest.populateSoapActionHeader) && Objects.equals(this.url, updateCompanyWebhookRequest.url) && Objects.equals(this.username, updateCompanyWebhookRequest.username);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acceptsExpiredCertificate, this.acceptsSelfSignedCertificate, this.acceptsUntrustedRootCertificate, this.active, this.additionalSettings, this.communicationFormat, this.description, this.encryptionProtocol, this.filterMerchantAccountType, this.filterMerchantAccounts, this.networkType, this.password, this.populateSoapActionHeader, this.url, this.username});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateCompanyWebhookRequest {\n");
        sb.append("    acceptsExpiredCertificate: ").append(this.toIndentedString(this.acceptsExpiredCertificate)).append("\n");
        sb.append("    acceptsSelfSignedCertificate: ").append(this.toIndentedString(this.acceptsSelfSignedCertificate)).append("\n");
        sb.append("    acceptsUntrustedRootCertificate: ").append(this.toIndentedString(this.acceptsUntrustedRootCertificate)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    additionalSettings: ").append(this.toIndentedString(this.additionalSettings)).append("\n");
        sb.append("    communicationFormat: ").append(this.toIndentedString((Object)this.communicationFormat)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    encryptionProtocol: ").append(this.toIndentedString((Object)this.encryptionProtocol)).append("\n");
        sb.append("    filterMerchantAccountType: ").append(this.toIndentedString((Object)this.filterMerchantAccountType)).append("\n");
        sb.append("    filterMerchantAccounts: ").append(this.toIndentedString(this.filterMerchantAccounts)).append("\n");
        sb.append("    networkType: ").append(this.toIndentedString((Object)this.networkType)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    populateSoapActionHeader: ").append(this.toIndentedString(this.populateSoapActionHeader)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static UpdateCompanyWebhookRequest fromJson(String jsonString) throws JsonProcessingException {
        return (UpdateCompanyWebhookRequest)JSON.getMapper().readValue(jsonString, UpdateCompanyWebhookRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum NetworkTypeEnum {
        LOCAL("local"),
        PUBLIC("public");

        private String value;

        private NetworkTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NetworkTypeEnum fromValue(String value) {
            for (NetworkTypeEnum b : NetworkTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum FilterMerchantAccountTypeEnum {
        ALLACCOUNTS("allAccounts"),
        EXCLUDEACCOUNTS("excludeAccounts"),
        INCLUDEACCOUNTS("includeAccounts");

        private String value;

        private FilterMerchantAccountTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FilterMerchantAccountTypeEnum fromValue(String value) {
            for (FilterMerchantAccountTypeEnum b : FilterMerchantAccountTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum EncryptionProtocolEnum {
        HTTP("HTTP"),
        TLSV1_2("TLSv1.2"),
        TLSV1_3("TLSv1.3");

        private String value;

        private EncryptionProtocolEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EncryptionProtocolEnum fromValue(String value) {
            for (EncryptionProtocolEnum b : EncryptionProtocolEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CommunicationFormatEnum {
        HTTP("http"),
        JSON("json"),
        SOAP("soap");

        private String value;

        private CommunicationFormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CommunicationFormatEnum fromValue(String value) {
            for (CommunicationFormatEnum b : CommunicationFormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

