/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.management;

import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.ws.rs.core.GenericType;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractOpenApiSchema {
    private Object instance;
    private Boolean isNullable;
    private final String schemaType;

    public AbstractOpenApiSchema(String schemaType, Boolean isNullable) {
        this.schemaType = schemaType;
        this.isNullable = isNullable;
    }

    public abstract Map<String, GenericType> getSchemas();

    @JsonValue
    public Object getActualInstance() {
        return this.instance;
    }

    public void setActualInstance(Object instance) {
        this.instance = instance;
    }

    public Object getActualInstanceRecursively() {
        return this.getActualInstanceRecursively(this);
    }

    private Object getActualInstanceRecursively(AbstractOpenApiSchema object) {
        if (object.getActualInstance() == null) {
            return null;
        }
        if (object.getActualInstance() instanceof AbstractOpenApiSchema) {
            return this.getActualInstanceRecursively((AbstractOpenApiSchema)object.getActualInstance());
        }
        return object.getActualInstance();
    }

    public String getSchemaType() {
        return this.schemaType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ").append(this.getClass()).append(" {\n");
        sb.append("    instance: ").append(this.toIndentedString(this.instance)).append("\n");
        sb.append("    isNullable: ").append(this.toIndentedString(this.isNullable)).append("\n");
        sb.append("    schemaType: ").append(this.toIndentedString(this.schemaType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractOpenApiSchema a = (AbstractOpenApiSchema)o;
        return Objects.equals(this.instance, a.instance) && Objects.equals(this.isNullable, a.isNullable) && Objects.equals(this.schemaType, a.schemaType);
    }

    public int hashCode() {
        return Objects.hash(this.instance, this.isNullable, this.schemaType);
    }

    public Boolean isNullable() {
        if (Boolean.TRUE.equals(this.isNullable)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

