/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.legalentitymanagement;

import com.adyen.model.legalentitymanagement.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"content", "language", "pciTemplateReferences"})
public class GeneratePciDescriptionResponse {
    public static final String JSON_PROPERTY_CONTENT = "content";
    private byte[] content;
    public static final String JSON_PROPERTY_LANGUAGE = "language";
    private String language;
    public static final String JSON_PROPERTY_PCI_TEMPLATE_REFERENCES = "pciTemplateReferences";
    private List<String> pciTemplateReferences = null;

    public GeneratePciDescriptionResponse content(byte[] content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(value="The generated questionnaires in a base64 encoded format.")
    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public byte[] getContent() {
        return this.content;
    }

    @JsonProperty(value="content")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContent(byte[] content) {
        this.content = content;
    }

    public GeneratePciDescriptionResponse language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(value="The two-letter [ISO-639-1](https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes) language code for the questionnaire. For example, **en**.")
    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLanguage() {
        return this.language;
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLanguage(String language) {
        this.language = language;
    }

    public GeneratePciDescriptionResponse pciTemplateReferences(List<String> pciTemplateReferences) {
        this.pciTemplateReferences = pciTemplateReferences;
        return this;
    }

    public GeneratePciDescriptionResponse addPciTemplateReferencesItem(String pciTemplateReferencesItem) {
        if (this.pciTemplateReferences == null) {
            this.pciTemplateReferences = new ArrayList<String>();
        }
        this.pciTemplateReferences.add(pciTemplateReferencesItem);
        return this;
    }

    @ApiModelProperty(value="The array of Adyen-generated unique identifiers for the questionnaires. If empty, the user is not required to sign questionnaires.")
    @JsonProperty(value="pciTemplateReferences")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getPciTemplateReferences() {
        return this.pciTemplateReferences;
    }

    @JsonProperty(value="pciTemplateReferences")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPciTemplateReferences(List<String> pciTemplateReferences) {
        this.pciTemplateReferences = pciTemplateReferences;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeneratePciDescriptionResponse generatePciDescriptionResponse = (GeneratePciDescriptionResponse)o;
        return Arrays.equals(this.content, generatePciDescriptionResponse.content) && Objects.equals(this.language, generatePciDescriptionResponse.language) && Objects.equals(this.pciTemplateReferences, generatePciDescriptionResponse.pciTemplateReferences);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.content), this.language, this.pciTemplateReferences);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeneratePciDescriptionResponse {\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("    pciTemplateReferences: ").append(this.toIndentedString(this.pciTemplateReferences)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static GeneratePciDescriptionResponse fromJson(String jsonString) throws JsonProcessingException {
        return (GeneratePciDescriptionResponse)JSON.getMapper().readValue(jsonString, GeneratePciDescriptionResponse.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

