/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.disputes;

import com.adyen.model.disputes.DefenseDocument;
import com.adyen.model.disputes.JSON;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"defenseDocuments", "disputePspReference", "merchantAccountCode"})
public class SupplyDefenseDocumentRequest {
    public static final String JSON_PROPERTY_DEFENSE_DOCUMENTS = "defenseDocuments";
    private List<DefenseDocument> defenseDocuments = new ArrayList<DefenseDocument>();
    public static final String JSON_PROPERTY_DISPUTE_PSP_REFERENCE = "disputePspReference";
    private String disputePspReference;
    public static final String JSON_PROPERTY_MERCHANT_ACCOUNT_CODE = "merchantAccountCode";
    private String merchantAccountCode;

    public SupplyDefenseDocumentRequest defenseDocuments(List<DefenseDocument> defenseDocuments) {
        this.defenseDocuments = defenseDocuments;
        return this;
    }

    public SupplyDefenseDocumentRequest addDefenseDocumentsItem(DefenseDocument defenseDocumentsItem) {
        this.defenseDocuments.add(defenseDocumentsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array containing a list of the defense documents.")
    @JsonProperty(value="defenseDocuments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DefenseDocument> getDefenseDocuments() {
        return this.defenseDocuments;
    }

    @JsonProperty(value="defenseDocuments")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefenseDocuments(List<DefenseDocument> defenseDocuments) {
        this.defenseDocuments = defenseDocuments;
    }

    public SupplyDefenseDocumentRequest disputePspReference(String disputePspReference) {
        this.disputePspReference = disputePspReference;
        return this;
    }

    @ApiModelProperty(required=true, value="The PSP reference assigned to the dispute.")
    @JsonProperty(value="disputePspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisputePspReference() {
        return this.disputePspReference;
    }

    @JsonProperty(value="disputePspReference")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDisputePspReference(String disputePspReference) {
        this.disputePspReference = disputePspReference;
    }

    public SupplyDefenseDocumentRequest merchantAccountCode(String merchantAccountCode) {
        this.merchantAccountCode = merchantAccountCode;
        return this;
    }

    @ApiModelProperty(required=true, value="The merchant account identifier, for which you want to process the dispute transaction.")
    @JsonProperty(value="merchantAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMerchantAccountCode() {
        return this.merchantAccountCode;
    }

    @JsonProperty(value="merchantAccountCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMerchantAccountCode(String merchantAccountCode) {
        this.merchantAccountCode = merchantAccountCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SupplyDefenseDocumentRequest supplyDefenseDocumentRequest = (SupplyDefenseDocumentRequest)o;
        return Objects.equals(this.defenseDocuments, supplyDefenseDocumentRequest.defenseDocuments) && Objects.equals(this.disputePspReference, supplyDefenseDocumentRequest.disputePspReference) && Objects.equals(this.merchantAccountCode, supplyDefenseDocumentRequest.merchantAccountCode);
    }

    public int hashCode() {
        return Objects.hash(this.defenseDocuments, this.disputePspReference, this.merchantAccountCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SupplyDefenseDocumentRequest {\n");
        sb.append("    defenseDocuments: ").append(this.toIndentedString(this.defenseDocuments)).append("\n");
        sb.append("    disputePspReference: ").append(this.toIndentedString(this.disputePspReference)).append("\n");
        sb.append("    merchantAccountCode: ").append(this.toIndentedString(this.merchantAccountCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static SupplyDefenseDocumentRequest fromJson(String jsonString) throws JsonProcessingException {
        return (SupplyDefenseDocumentRequest)JSON.getMapper().readValue(jsonString, SupplyDefenseDocumentRequest.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }
}

