/*
 * Decompiled with CFR 0.152.
 */
package com.adyen.model.acswebhooks;

import com.adyen.model.acswebhooks.ChallengeInfo;
import com.adyen.model.acswebhooks.JSON;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonPropertyOrder(value={"acsTransId", "challenge", "challengeIndicator", "createdAt", "deviceChannel", "dsTransID", "exemptionIndicator", "inPSD2Scope", "messageCategory", "messageVersion", "riskScore", "threeDSServerTransID", "transStatus", "transStatusReason", "type"})
public class AuthenticationInfo {
    public static final String JSON_PROPERTY_ACS_TRANS_ID = "acsTransId";
    private String acsTransId;
    public static final String JSON_PROPERTY_CHALLENGE = "challenge";
    private ChallengeInfo challenge;
    public static final String JSON_PROPERTY_CHALLENGE_INDICATOR = "challengeIndicator";
    private ChallengeIndicatorEnum challengeIndicator;
    public static final String JSON_PROPERTY_CREATED_AT = "createdAt";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_DEVICE_CHANNEL = "deviceChannel";
    private DeviceChannelEnum deviceChannel;
    public static final String JSON_PROPERTY_DS_TRANS_I_D = "dsTransID";
    private String dsTransID;
    public static final String JSON_PROPERTY_EXEMPTION_INDICATOR = "exemptionIndicator";
    private ExemptionIndicatorEnum exemptionIndicator;
    public static final String JSON_PROPERTY_IN_P_S_D2_SCOPE = "inPSD2Scope";
    private Boolean inPSD2Scope;
    public static final String JSON_PROPERTY_MESSAGE_CATEGORY = "messageCategory";
    private MessageCategoryEnum messageCategory;
    public static final String JSON_PROPERTY_MESSAGE_VERSION = "messageVersion";
    private String messageVersion;
    public static final String JSON_PROPERTY_RISK_SCORE = "riskScore";
    private Integer riskScore;
    public static final String JSON_PROPERTY_THREE_D_S_SERVER_TRANS_I_D = "threeDSServerTransID";
    private String threeDSServerTransID;
    public static final String JSON_PROPERTY_TRANS_STATUS = "transStatus";
    private TransStatusEnum transStatus;
    public static final String JSON_PROPERTY_TRANS_STATUS_REASON = "transStatusReason";
    private TransStatusReasonEnum transStatusReason;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public AuthenticationInfo acsTransId(String acsTransId) {
        this.acsTransId = acsTransId;
        return this;
    }

    @ApiModelProperty(required=true, value="Universally unique transaction identifier assigned by the Access Control Server (ACS) to identify a single transaction.")
    @JsonProperty(value="acsTransId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAcsTransId() {
        return this.acsTransId;
    }

    @JsonProperty(value="acsTransId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAcsTransId(String acsTransId) {
        this.acsTransId = acsTransId;
    }

    public AuthenticationInfo challenge(ChallengeInfo challenge) {
        this.challenge = challenge;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="challenge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChallengeInfo getChallenge() {
        return this.challenge;
    }

    @JsonProperty(value="challenge")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChallenge(ChallengeInfo challenge) {
        this.challenge = challenge;
    }

    public AuthenticationInfo challengeIndicator(ChallengeIndicatorEnum challengeIndicator) {
        this.challengeIndicator = challengeIndicator;
        return this;
    }

    @ApiModelProperty(required=true, value="Specifies a preference for receiving a challenge. Possible values:  * **01**: No preference * **02**: No challenge requested * **03**: Challenge requested (preference) * **04**: Challenge requested (mandate) * **05**: No challenge requested (transactional risk analysis is already performed) * **07**: No challenge requested (SCA is already performed) * **08**: No challenge requested (trusted beneficiaries exemption of no challenge required) * **09**: Challenge requested (trusted beneficiaries prompt requested if challenge required) * **80**: No challenge requested (secure corporate payment with Mastercard) * **82**: No challenge requested (secure corporate payment with Visa) ")
    @JsonProperty(value="challengeIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ChallengeIndicatorEnum getChallengeIndicator() {
        return this.challengeIndicator;
    }

    @JsonProperty(value="challengeIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setChallengeIndicator(ChallengeIndicatorEnum challengeIndicator) {
        this.challengeIndicator = challengeIndicator;
    }

    public AuthenticationInfo createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="Date and time in UTC of the cardholder authentication.   [ISO 8601](https://www.w3.org/TR/NOTE-datetime) format: YYYY-MM-DDThh:mm:ss+TZD, for example, **2020-12-18T10:15:30+01:00**.")
    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="createdAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public AuthenticationInfo deviceChannel(DeviceChannelEnum deviceChannel) {
        this.deviceChannel = deviceChannel;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates the type of channel interface being used to initiate the transaction. Possible values:  * **app** * **browser** * **3DSRequestorInitiated** (initiated by a merchant when the cardholder is not available)")
    @JsonProperty(value="deviceChannel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public DeviceChannelEnum getDeviceChannel() {
        return this.deviceChannel;
    }

    @JsonProperty(value="deviceChannel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeviceChannel(DeviceChannelEnum deviceChannel) {
        this.deviceChannel = deviceChannel;
    }

    public AuthenticationInfo dsTransID(String dsTransID) {
        this.dsTransID = dsTransID;
        return this;
    }

    @ApiModelProperty(required=true, value="Universally unique transaction identifier assigned by the DS (card scheme) to identify a single transaction.")
    @JsonProperty(value="dsTransID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDsTransID() {
        return this.dsTransID;
    }

    @JsonProperty(value="dsTransID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDsTransID(String dsTransID) {
        this.dsTransID = dsTransID;
    }

    public AuthenticationInfo exemptionIndicator(ExemptionIndicatorEnum exemptionIndicator) {
        this.exemptionIndicator = exemptionIndicator;
        return this;
    }

    @ApiModelProperty(value="Indicates the exemption type that was applied to the authentication by the issuer, if exemption applied. Possible values:  * **lowValue** * **secureCorporate** * **trustedBeneficiary** * **transactionRiskAnalysis** * **acquirerExemption** * **noExemptionApplied** * **visaDAFExemption** ")
    @JsonProperty(value="exemptionIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ExemptionIndicatorEnum getExemptionIndicator() {
        return this.exemptionIndicator;
    }

    @JsonProperty(value="exemptionIndicator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExemptionIndicator(ExemptionIndicatorEnum exemptionIndicator) {
        this.exemptionIndicator = exemptionIndicator;
    }

    public AuthenticationInfo inPSD2Scope(Boolean inPSD2Scope) {
        this.inPSD2Scope = inPSD2Scope;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates if the purchase was in the PSD2 scope.")
    @JsonProperty(value="inPSD2Scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getInPSD2Scope() {
        return this.inPSD2Scope;
    }

    @JsonProperty(value="inPSD2Scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInPSD2Scope(Boolean inPSD2Scope) {
        this.inPSD2Scope = inPSD2Scope;
    }

    public AuthenticationInfo messageCategory(MessageCategoryEnum messageCategory) {
        this.messageCategory = messageCategory;
        return this;
    }

    @ApiModelProperty(required=true, value="Identifies the category of the message for a specific use case. Possible values:  * **payment** * **nonPayment**")
    @JsonProperty(value="messageCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public MessageCategoryEnum getMessageCategory() {
        return this.messageCategory;
    }

    @JsonProperty(value="messageCategory")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMessageCategory(MessageCategoryEnum messageCategory) {
        this.messageCategory = messageCategory;
    }

    public AuthenticationInfo messageVersion(String messageVersion) {
        this.messageVersion = messageVersion;
        return this;
    }

    @ApiModelProperty(required=true, value="The `messageVersion` value as defined in the 3D Secure 2 specification.")
    @JsonProperty(value="messageVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMessageVersion() {
        return this.messageVersion;
    }

    @JsonProperty(value="messageVersion")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMessageVersion(String messageVersion) {
        this.messageVersion = messageVersion;
    }

    public AuthenticationInfo riskScore(Integer riskScore) {
        this.riskScore = riskScore;
        return this;
    }

    @ApiModelProperty(value="Risk score calculated from the transaction rules.")
    @JsonProperty(value="riskScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getRiskScore() {
        return this.riskScore;
    }

    @JsonProperty(value="riskScore")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRiskScore(Integer riskScore) {
        this.riskScore = riskScore;
    }

    public AuthenticationInfo threeDSServerTransID(String threeDSServerTransID) {
        this.threeDSServerTransID = threeDSServerTransID;
        return this;
    }

    @ApiModelProperty(required=true, value="The `threeDSServerTransID` value as defined in the 3D Secure 2 specification.")
    @JsonProperty(value="threeDSServerTransID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getThreeDSServerTransID() {
        return this.threeDSServerTransID;
    }

    @JsonProperty(value="threeDSServerTransID")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setThreeDSServerTransID(String threeDSServerTransID) {
        this.threeDSServerTransID = threeDSServerTransID;
    }

    public AuthenticationInfo transStatus(TransStatusEnum transStatus) {
        this.transStatus = transStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="The `transStatus` value as defined in the 3D Secure 2 specification. Possible values:  * **Y**: Authentication / Account verification successful. * **N**: Not Authenticated / Account not verified. Transaction denied. * **U**: Authentication / Account verification could not be performed. * **I**: Informational Only / 3D Secure Requestor challenge preference acknowledged. * **R**: Authentication / Account verification rejected by the Issuer. ")
    @JsonProperty(value="transStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransStatusEnum getTransStatus() {
        return this.transStatus;
    }

    @JsonProperty(value="transStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransStatus(TransStatusEnum transStatus) {
        this.transStatus = transStatus;
    }

    public AuthenticationInfo transStatusReason(TransStatusReasonEnum transStatusReason) {
        this.transStatusReason = transStatusReason;
        return this;
    }

    @ApiModelProperty(value="Provides information on why the `transStatus` field has the specified value. For possible values, refer to [our docs](https://docs.adyen.com/online-payments/3d-secure/api-reference#possible-transstatusreason-values).")
    @JsonProperty(value="transStatusReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransStatusReasonEnum getTransStatusReason() {
        return this.transStatusReason;
    }

    @JsonProperty(value="transStatusReason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransStatusReason(TransStatusReasonEnum transStatusReason) {
        this.transStatusReason = transStatusReason;
    }

    public AuthenticationInfo type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="The type of authentication performed. Possible values:  * **frictionless** * **challenge**")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationInfo authenticationInfo = (AuthenticationInfo)o;
        return Objects.equals(this.acsTransId, authenticationInfo.acsTransId) && Objects.equals(this.challenge, authenticationInfo.challenge) && Objects.equals((Object)this.challengeIndicator, (Object)authenticationInfo.challengeIndicator) && Objects.equals(this.createdAt, authenticationInfo.createdAt) && Objects.equals((Object)this.deviceChannel, (Object)authenticationInfo.deviceChannel) && Objects.equals(this.dsTransID, authenticationInfo.dsTransID) && Objects.equals((Object)this.exemptionIndicator, (Object)authenticationInfo.exemptionIndicator) && Objects.equals(this.inPSD2Scope, authenticationInfo.inPSD2Scope) && Objects.equals((Object)this.messageCategory, (Object)authenticationInfo.messageCategory) && Objects.equals(this.messageVersion, authenticationInfo.messageVersion) && Objects.equals(this.riskScore, authenticationInfo.riskScore) && Objects.equals(this.threeDSServerTransID, authenticationInfo.threeDSServerTransID) && Objects.equals((Object)this.transStatus, (Object)authenticationInfo.transStatus) && Objects.equals((Object)this.transStatusReason, (Object)authenticationInfo.transStatusReason) && Objects.equals((Object)this.type, (Object)authenticationInfo.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acsTransId, this.challenge, this.challengeIndicator, this.createdAt, this.deviceChannel, this.dsTransID, this.exemptionIndicator, this.inPSD2Scope, this.messageCategory, this.messageVersion, this.riskScore, this.threeDSServerTransID, this.transStatus, this.transStatusReason, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticationInfo {\n");
        sb.append("    acsTransId: ").append(this.toIndentedString(this.acsTransId)).append("\n");
        sb.append("    challenge: ").append(this.toIndentedString(this.challenge)).append("\n");
        sb.append("    challengeIndicator: ").append(this.toIndentedString((Object)this.challengeIndicator)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    deviceChannel: ").append(this.toIndentedString((Object)this.deviceChannel)).append("\n");
        sb.append("    dsTransID: ").append(this.toIndentedString(this.dsTransID)).append("\n");
        sb.append("    exemptionIndicator: ").append(this.toIndentedString((Object)this.exemptionIndicator)).append("\n");
        sb.append("    inPSD2Scope: ").append(this.toIndentedString(this.inPSD2Scope)).append("\n");
        sb.append("    messageCategory: ").append(this.toIndentedString((Object)this.messageCategory)).append("\n");
        sb.append("    messageVersion: ").append(this.toIndentedString(this.messageVersion)).append("\n");
        sb.append("    riskScore: ").append(this.toIndentedString(this.riskScore)).append("\n");
        sb.append("    threeDSServerTransID: ").append(this.toIndentedString(this.threeDSServerTransID)).append("\n");
        sb.append("    transStatus: ").append(this.toIndentedString((Object)this.transStatus)).append("\n");
        sb.append("    transStatusReason: ").append(this.toIndentedString((Object)this.transStatusReason)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static AuthenticationInfo fromJson(String jsonString) throws JsonProcessingException {
        return (AuthenticationInfo)JSON.getMapper().readValue(jsonString, AuthenticationInfo.class);
    }

    public String toJson() throws JsonProcessingException {
        return JSON.getMapper().writeValueAsString((Object)this);
    }

    public static enum TypeEnum {
        FRICTIONLESS("frictionless"),
        CHALLENGE("challenge");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TransStatusReasonEnum {
        _01("01"),
        _02("02"),
        _03("03"),
        _04("04"),
        _05("05"),
        _06("06"),
        _07("07"),
        _08("08"),
        _09("09"),
        _10("10"),
        _11("11"),
        _12("12"),
        _13("13"),
        _14("14"),
        _15("15"),
        _16("16"),
        _17("17"),
        _18("18"),
        _19("19"),
        _20("20"),
        _21("21"),
        _22("22"),
        _23("23"),
        _24("24"),
        _25("25"),
        _26("26"),
        _80("80"),
        _81("81"),
        _82("82"),
        _83("83"),
        _84("84"),
        _85("85"),
        _86("86"),
        _87("87"),
        _88("88");

        private String value;

        private TransStatusReasonEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TransStatusReasonEnum fromValue(String value) {
            for (TransStatusReasonEnum b : TransStatusReasonEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum TransStatusEnum {
        Y("Y"),
        N("N"),
        R("R"),
        I("I"),
        U("U");

        private String value;

        private TransStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TransStatusEnum fromValue(String value) {
            for (TransStatusEnum b : TransStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum MessageCategoryEnum {
        PAYMENT("payment"),
        NONPAYMENT("nonPayment");

        private String value;

        private MessageCategoryEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MessageCategoryEnum fromValue(String value) {
            for (MessageCategoryEnum b : MessageCategoryEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ExemptionIndicatorEnum {
        LOWVALUE("lowValue"),
        SECURECORPORATE("secureCorporate"),
        TRUSTEDBENEFICIARY("trustedBeneficiary"),
        TRANSACTIONRISKANALYSIS("transactionRiskAnalysis"),
        ACQUIREREXEMPTION("acquirerExemption"),
        NOEXEMPTIONAPPLIED("noExemptionApplied"),
        VISADAFEXEMPTION("visaDAFExemption");

        private String value;

        private ExemptionIndicatorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ExemptionIndicatorEnum fromValue(String value) {
            for (ExemptionIndicatorEnum b : ExemptionIndicatorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum DeviceChannelEnum {
        APP("app"),
        BROWSER("browser"),
        THREEDSREQUESTORINITIATED("ThreeDSRequestorInitiated");

        private String value;

        private DeviceChannelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DeviceChannelEnum fromValue(String value) {
            for (DeviceChannelEnum b : DeviceChannelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ChallengeIndicatorEnum {
        _01("01"),
        _02("02"),
        _03("03"),
        _04("04"),
        _05("05"),
        _07("07"),
        _08("08"),
        _09("09"),
        _80("80"),
        _82("82");

        private String value;

        private ChallengeIndicatorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ChallengeIndicatorEnum fromValue(String value) {
            for (ChallengeIndicatorEnum b : ChallengeIndicatorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

