/*
 * Decompiled with CFR 0.152.
 */
package flash.swf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RandomAccessBuffer
extends ByteArrayOutputStream {
    protected int pos = 0;

    public RandomAccessBuffer() {
        super(1024);
    }

    public RandomAccessBuffer(int bufferSize) {
        super(bufferSize);
    }

    public final int getPos() {
        return this.pos;
    }

    public final void setPos(int pos) {
        this.pos = pos;
    }

    public final synchronized void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public final synchronized void write(byte[] b, int off, int len) {
        if (this.pos > this.count) {
            byte[] zeros = new byte[this.pos - this.count];
            super.write(zeros, 0, zeros.length);
            this.pos = this.count;
        } else if (this.pos < this.count) {
            int overlap = Math.min(this.count - this.pos, len);
            System.arraycopy(b, off, this.buf, this.pos, overlap);
            this.pos += overlap;
            off += overlap;
            len -= overlap;
        }
        super.write(b, off, len);
        this.pos += len;
    }

    public final synchronized void readFully(byte[] bytes) {
        int len = bytes.length;
        if (this.pos + len > this.count) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.buf, this.pos, bytes, 0, len);
        this.pos += len;
    }

    public final synchronized void write(int b) {
        if (this.count > this.pos) {
            this.buf[this.pos++] = (byte)b;
        } else {
            super.write(b);
            ++this.pos;
        }
    }

    public synchronized void reset() {
        super.reset();
        this.pos = 0;
    }

    public synchronized byte[] toByteArray() {
        this.count = this.pos;
        return super.toByteArray();
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        this.count = this.pos;
        super.writeTo(out);
    }

    public byte[] getByteArray() {
        return this.buf;
    }
}

