/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.utils;

import com.adobe.cq.commerce.virtual.catalog.data.Constants;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConfigInheritance {
    public static JSONObject getInheritanceMap(Resource configContainerResource, String[] configKeys) throws JSONException {
        Resource parentConfigContainerResource;
        ResourceResolver resourceResolver = configContainerResource.getResourceResolver();
        JSONObject config = new JSONObject();
        config.put("inherited", false);
        if (configContainerResource.getPath().startsWith("/conf") && parentConfigContainerResource != null && !parentConfigContainerResource.getPath().equals("/conf")) {
            config.put("inherited", true);
            JSONObject inheritedProps = new JSONObject();
            for (parentConfigContainerResource = configContainerResource.getParent(); parentConfigContainerResource != null && !parentConfigContainerResource.getPath().equals("/conf"); parentConfigContainerResource = parentConfigContainerResource.getParent()) {
                Resource parentConfig = parentConfigContainerResource.getChild(Constants.COMMERCE_BUCKET_PATH + "/jcr:content");
                ConfigInheritance.extractInheritedProps(configKeys, parentConfigContainerResource, inheritedProps, parentConfig);
            }
            Resource appsDefaultConfig = resourceResolver.getResource("/apps/settings/cloudconfigs/commerce/jcr:content");
            ConfigInheritance.extractInheritedProps(configKeys, parentConfigContainerResource, inheritedProps, appsDefaultConfig);
            Resource libsDefaultConfig = resourceResolver.getResource("/libs/settings/cloudconfigs/commerce/jcr:content");
            ConfigInheritance.extractInheritedProps(configKeys, parentConfigContainerResource, inheritedProps, libsDefaultConfig);
            config.put("inheritedProperties", (Object)inheritedProps);
            JSONArray overriddenProps = new JSONArray();
            Resource configContent = configContainerResource.getChild(Constants.COMMERCE_BUCKET_PATH + "/jcr:content");
            if (configContent != null) {
                ValueMap vm = configContent.getValueMap();
                for (String key : configKeys) {
                    if (!vm.containsKey((Object)key)) continue;
                    overriddenProps.put((Object)key);
                }
            }
            config.put("overriddenProperties", (Object)overriddenProps);
        }
        return config;
    }

    private static void extractInheritedProps(String[] configKeys, Resource parentConfigContainerResource, JSONObject inheritedProps, Resource configNode) throws JSONException {
        if (configNode != null) {
            ValueMap vm = configNode.getValueMap();
            for (String key : configKeys) {
                if (inheritedProps.has(key) || !vm.containsKey((Object)key)) continue;
                JSONObject propMeta = new JSONObject();
                propMeta.put("value", vm.get((Object)key));
                propMeta.put("inheritedFrom", (Object)parentConfigContainerResource.getPath());
                inheritedProps.put(key, (Object)propMeta);
            }
        }
    }
}

