/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.renderconditions;

import com.adobe.cq.commerce.renderconditions.IsProductDetailPageServlet;
import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.rendercondition.RenderCondition;
import com.adobe.granite.ui.components.rendercondition.SimpleRenderCondition;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import javax.servlet.Servlet;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class}, name="IsProductListPageRenderConditionServlet", immediate=true, property={"sling.servlet.resourceTypes=commerce/gui/components/authoring/editor/pagepreview/renderconditions/isproductlistpage", "sling.servlet.methods=GET"})
public class IsProductListPageServlet
extends SlingSafeMethodsServlet {
    static final String PRODUCT_LIST_RT = "core/cif/components/commerce/productlist/v1/productlist";

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        Config cfg = new Config(request.getResource());
        SlingScriptHelper sling = ((SlingBindings)request.getAttribute(SlingBindings.class.getName())).getSling();
        ExpressionHelper ex = new ExpressionHelper((ExpressionResolver)sling.getService(ExpressionResolver.class), request);
        String path = ex.getString((String)cfg.get("path", String.class));
        boolean decision = this.isProductListPage(path, request.getResourceResolver());
        request.setAttribute(RenderCondition.class.getName(), (Object)new SimpleRenderCondition(decision));
        if (decision) {
            IsProductDetailPageServlet.prepareCatalogPathProperty(path, request);
        }
    }

    private boolean isProductListPage(String path, ResourceResolver resourceResolver) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return false;
        }
        Resource resource = resourceResolver.resolve(path);
        if (resource instanceof NonExistingResource) {
            return false;
        }
        Page page = ((PageManager)resourceResolver.adaptTo(PageManager.class)).getPage(resource.getPath());
        if (page == null) {
            return false;
        }
        Resource pageContent = page.getContentResource();
        if (pageContent == null) {
            return false;
        }
        boolean val = IsProductDetailPageServlet.containsComponent(PRODUCT_LIST_RT, pageContent);
        return val;
    }
}

