/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.renderconditions;

import com.adobe.cq.commerce.api.conf.CommerceBasePathsService;
import com.adobe.cq.commerce.graphql.search.CatalogSearchSupport;
import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionCustomizer;
import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.rendercondition.RenderCondition;
import com.adobe.granite.ui.components.rendercondition.SimpleRenderCondition;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.NonExistingResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, name="IsProductDetailPageRenderConditionServlet", immediate=true, property={"sling.servlet.resourceTypes=commerce/gui/components/authoring/editor/pagepreview/renderconditions/isproductdetailpage", "sling.servlet.methods=GET"})
public class IsProductDetailPageServlet
extends SlingSafeMethodsServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsProductDetailPageServlet.class);
    static final String PRODUCT_RT = "core/cif/components/commerce/product/v1/product";
    static final String CATALOG_PATH_PROPERTY = "catalogPath";

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        Config cfg = new Config(request.getResource());
        SlingScriptHelper sling = ((SlingBindings)request.getAttribute(SlingBindings.class.getName())).getSling();
        ExpressionHelper ex = new ExpressionHelper((ExpressionResolver)sling.getService(ExpressionResolver.class), request);
        String path = ex.getString((String)cfg.get("path", String.class));
        boolean decision = this.isProductDetailPage(path, request.getResourceResolver());
        request.setAttribute(RenderCondition.class.getName(), (Object)new SimpleRenderCondition(decision));
        if (decision) {
            IsProductDetailPageServlet.prepareCatalogPathProperty(path, request);
        }
    }

    private boolean isProductDetailPage(String path, ResourceResolver resourceResolver) {
        if (StringUtils.isBlank((CharSequence)path)) {
            return false;
        }
        Resource resource = resourceResolver.resolve(path);
        if (resource instanceof NonExistingResource) {
            return false;
        }
        Page page = ((PageManager)resourceResolver.adaptTo(PageManager.class)).getPage(resource.getPath());
        if (page == null) {
            return false;
        }
        Resource pageContent = page.getContentResource();
        if (pageContent == null) {
            return false;
        }
        boolean val = IsProductDetailPageServlet.containsComponent(PRODUCT_RT, pageContent);
        return val;
    }

    static boolean containsComponent(String resourceType, Resource resource) {
        if (resource == null) {
            return false;
        }
        if (resource.isResourceType(resourceType)) {
            return true;
        }
        for (Resource child : resource.getChildren()) {
            boolean val = IsProductDetailPageServlet.containsComponent(resourceType, child);
            if (!val) continue;
            return true;
        }
        return false;
    }

    static void prepareCatalogPathProperty(String path, SlingHttpServletRequest request) {
        String catalogPath;
        ResourceResolver resourceResolver = request.getResourceResolver();
        Resource resource = resourceResolver.resolve(path);
        if (resource instanceof NonExistingResource) {
            CommerceBasePathsService pathsService = (CommerceBasePathsService)resourceResolver.adaptTo(CommerceBasePathsService.class);
            catalogPath = pathsService.getProductsBasePath();
        } else {
            CatalogSearchSupport catalogSearchSupport = new CatalogSearchSupport(resourceResolver);
            catalogPath = catalogSearchSupport.findCatalogPath(resource.getPath());
            if (StringUtils.isBlank((CharSequence)catalogPath) || resourceResolver.getResource(catalogPath) == null) {
                LOGGER.warn("Invalid cq:catalogPath configured for path {}: {}", (Object)path, (Object)catalogPath);
                CommerceBasePathsService pathsService = (CommerceBasePathsService)resourceResolver.adaptTo(CommerceBasePathsService.class);
                catalogPath = pathsService.getProductsBasePath();
            }
        }
        ExpressionCustomizer customizer = ExpressionCustomizer.from((ServletRequest)request);
        customizer.setVariable(CATALOG_PATH_PROPERTY, (Object)catalogPath);
    }
}

