/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.postprocessor;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.ModificationType;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.osgi.service.component.annotations.Component;

@Component(service={SlingPostProcessor.class})
public class MultiFieldDropTargetPostProcessor
implements SlingPostProcessor {
    private static final String DROP_TARGET_PREFIX = "./multiDropTarget->";
    private static final String COMPOSITE_VARIABLE = "{{COMPOSITE}}";
    private static final String PROPERTY_PREFIX = "@";
    private static final String SLASH = "/";
    private static final String SLING_PROPERTY_PREFIX = "./";
    private static final String SELECTION_ID = "./selectionId";
    private static final String MULTIPLE = "./multiple";
    private static final String SLING_COPY_FROM = "./@CopyFrom";
    private static final String SKU = "sku";
    private static final String SLUG = "slug";

    public void process(SlingHttpServletRequest request, List<Modification> modifications) throws Exception {
        RequestParameterMap requestParameterMap = request.getRequestParameterMap();
        for (String key : requestParameterMap.keySet()) {
            RequestParameter selectionTypeParameter;
            Modification copyFrom;
            RequestParameter requestParameter;
            if (!key.startsWith(DROP_TARGET_PREFIX) || (requestParameter = requestParameterMap.getValue(key)) == null) continue;
            String target = key.replace(DROP_TARGET_PREFIX, "");
            String propertyValue = requestParameter.getString();
            Resource resource = request.getResource();
            if (requestParameterMap.containsKey((Object)SLING_COPY_FROM) && (copyFrom = modifications.stream().filter(m -> ModificationType.COPY.equals((Object)m.getType())).findFirst().orElseGet(null)) != null) {
                Resource dropComponent = resource.getResourceResolver().getResource(copyFrom.getDestination());
                ModifiableValueMap properties = (ModifiableValueMap)dropComponent.adaptTo(ModifiableValueMap.class);
                properties.remove((Object)target);
                resource = dropComponent;
            }
            String selectionType = (selectionTypeParameter = requestParameterMap.getValue(SELECTION_ID)) != null ? selectionTypeParameter.getString() : null;
            RequestParameter multipleParameter = requestParameterMap.getValue(MULTIPLE);
            boolean multiple = true;
            if (multipleParameter != null) {
                multiple = Boolean.valueOf(multipleParameter.getString());
            }
            this.processProperty(resource, target, propertyValue, key, selectionType, multiple);
            modifications.add(Modification.onModified((String)resource.getPath()));
        }
    }

    private void processProperty(Resource resource, String target, String propertyValue, String originalKey, String selectionType, boolean multiple) throws Exception {
        String[] paths = target.split(SLASH);
        ResourceResolver resourceResolver = resource.getResourceResolver();
        ModifiableValueMap originalProperties = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        originalProperties.remove((Object)originalKey);
        String dropTargetNodeName = DROP_TARGET_PREFIX.replace(SLING_PROPERTY_PREFIX, "");
        Resource dropTargetResource = resource.getChild(dropTargetNodeName);
        if (dropTargetResource != null) {
            resourceResolver.delete(dropTargetResource);
        }
        if (selectionType != null) {
            String slug;
            Resource product;
            if (SKU.equals(selectionType)) {
                propertyValue = StringUtils.substringAfterLast((String)propertyValue, (String)SLASH);
            } else if (SLUG.equals(selectionType) && (product = resourceResolver.getResource(propertyValue)) != null && (slug = (String)product.getValueMap().get(SLUG, String.class)) != null) {
                propertyValue = slug;
            }
        }
        boolean isArray = true;
        Resource currentResource = resource;
        for (String path : paths) {
            if (path.startsWith(PROPERTY_PREFIX)) {
                String propertyName = path.replace(PROPERTY_PREFIX, "");
                ModifiableValueMap properties = (ModifiableValueMap)currentResource.adaptTo(ModifiableValueMap.class);
                if (isArray && multiple) {
                    ArrayList<String> childPages = new ArrayList<String>(Arrays.asList((String[])properties.get(propertyName, (Object)new String[0])));
                    childPages.add(propertyValue);
                    properties.remove((Object)propertyName);
                    properties.put((Object)propertyName, (Object)childPages.toArray());
                } else {
                    properties.put((Object)propertyName, (Object)propertyValue);
                }
                properties.remove((Object)MULTIPLE.replace(PROPERTY_PREFIX, ""));
                properties.remove((Object)SELECTION_ID.replace(PROPERTY_PREFIX, ""));
                continue;
            }
            if (path.equals(COMPOSITE_VARIABLE)) {
                int count = Iterators.size(currentResource.getChildren().iterator());
                String nodeName = "item" + count;
                currentResource = resourceResolver.create(currentResource, nodeName, new HashMap());
                isArray = false;
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)path)) continue;
            Resource subResource = currentResource.getChild(path);
            currentResource = subResource == null ? resourceResolver.create(currentResource, path, new HashMap()) : subResource;
        }
    }
}

