/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.omnisearch;

import com.adobe.cq.commerce.api.conf.CommerceBasePathsService;
import com.adobe.granite.omnisearch.commons.AbstractOmniSearchHandler;
import com.adobe.granite.omnisearch.spi.core.OmniSearchHandler;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.SearchResult;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.observation.EventIterator;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.commons.iterator.RowIteratorAdapter;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={OmniSearchHandler.class})
public class ProductsSuggestionOmniSearchHandler
extends AbstractOmniSearchHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProductsSuggestionOmniSearchHandler.class);
    private static final String TYPE = "product";
    private static final String VIRTUAL_PRODUCT_QUERY_LANGUAGE = "virtualProductOmnisearchQuery";
    private static final String PARAMETER_OFFSET = "_commerce_offset";
    private static final String PARAMETER_LIMIT = "_commerce_limit";
    @Reference(target="(subServiceName=omnisearch-service)")
    private ServiceUserMapped serviceUserMapped;
    @Reference
    private ResourceResolverFactory resolverFactory = null;
    @Reference
    private QueryBuilder queryBuilder = null;
    @Reference(cardinality=ReferenceCardinality.MANDATORY, target="(component.name=com.adobe.cq.commerce.impl.omnisearch.ProductsOmniSearchHandler)")
    private OmniSearchHandler productsOmniSearchHandler;
    @Reference
    private CommerceBasePathsService cbps;
    private ResourceResolver resolver;
    private ObjectMapper jsonMapper;

    @Activate
    protected void activate(ComponentContext componentContext) throws LoginException, PathNotFoundException, RepositoryException {
        if (this.resolver == null) {
            this.resolver = this.getResourceResolver();
            this.init(this.resolver);
            this.jsonMapper = new ObjectMapper();
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) throws LoginException {
        try {
            this.destroy(this.resolver);
        }
        finally {
            this.resolver.close();
        }
    }

    public String getID() {
        return TYPE;
    }

    public void onEvent(EventIterator eventIterator) {
        if (this.resolver == null) {
            try {
                this.resolver = this.getResourceResolver();
                this.init(this.resolver);
                this.jsonMapper = new ObjectMapper();
            }
            catch (LoginException e) {
                LOGGER.error("Error initializing!", (Throwable)e);
            }
        }
    }

    public SearchResult getResults(ResourceResolver resolver, Map<String, Object> predicateParameters, long limit, long offset) {
        return this.productsOmniSearchHandler.getResults(resolver, predicateParameters, limit, offset);
    }

    protected Query getSuperSuggestionQuery(ResourceResolver resolver, String searchTerm) {
        return super.getSuggestionQuery(resolver, searchTerm);
    }

    public Query getSuggestionQuery(ResourceResolver resolver, String searchTerm) {
        LOGGER.debug("Calling suggestion query with '{}'", (Object)searchTerm);
        return new SuggestionQueryWrapper(this.getSuperSuggestionQuery(resolver, searchTerm), searchTerm);
    }

    Iterator<Resource> getVirtualResults(ResourceResolver resolver, Map<String, Object> predicateParameters, long limit, long offset) {
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        queryParameters.putAll(predicateParameters);
        queryParameters.put(PARAMETER_OFFSET, String.valueOf(offset));
        queryParameters.put(PARAMETER_LIMIT, String.valueOf(limit));
        String queryString = this.mapToString(queryParameters);
        Iterator virtualResults = null;
        try {
            virtualResults = resolver.findResources(queryString, VIRTUAL_PRODUCT_QUERY_LANGUAGE);
        }
        catch (Exception x) {
            LOGGER.error("Error searching virtual products", (Throwable)x);
        }
        return virtualResults;
    }

    String mapToString(Map<String, Object> map) {
        try {
            return this.jsonMapper.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to serialize map data", (Throwable)e);
            return null;
        }
    }

    ResourceResolver getResourceResolver() throws LoginException {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("sling.service.subservice", "omnisearch-service");
        return this.resolverFactory.getServiceResourceResolver(param);
    }

    private class SuggestionRow
    implements Row {
        private Value value;

        private SuggestionRow(Value value) {
            this.value = value;
        }

        public Value[] getValues() throws RepositoryException {
            return null;
        }

        public Value getValue(String columnName) throws ItemNotFoundException, RepositoryException {
            return this.value;
        }

        public Node getNode() throws RepositoryException {
            return null;
        }

        public Node getNode(String selectorName) throws RepositoryException {
            return null;
        }

        public String getPath() throws RepositoryException {
            return null;
        }

        public String getPath(String selectorName) throws RepositoryException {
            return null;
        }

        public double getScore() throws RepositoryException {
            return 0.0;
        }

        public double getScore(String selectorName) throws RepositoryException {
            return 0.0;
        }
    }

    private class SuggestionQueryResult
    implements QueryResult {
        private List<Row> rows;

        private SuggestionQueryResult(List<Row> rows) {
            this.rows = rows;
        }

        public String[] getColumnNames() throws RepositoryException {
            return null;
        }

        public RowIterator getRows() throws RepositoryException {
            return new RowIteratorAdapter(this.rows.iterator());
        }

        public NodeIterator getNodes() throws RepositoryException {
            return null;
        }

        public String[] getSelectorNames() throws RepositoryException {
            return null;
        }
    }

    private class SuggestionQueryWrapper
    implements Query {
        private Query query;
        private String searchTerm;

        private SuggestionQueryWrapper(Query query, String searchTerm) {
            this.query = query;
            this.searchTerm = searchTerm;
        }

        public QueryResult execute() throws InvalidQueryException, RepositoryException {
            QueryResult queryResult = this.query.execute();
            Iterator<Resource> it = ProductsSuggestionOmniSearchHandler.this.getVirtualResults(ProductsSuggestionOmniSearchHandler.this.resolver, Collections.singletonMap("fulltext", this.searchTerm), 10L, 0L);
            if (it == null || !it.hasNext()) {
                return queryResult;
            }
            ValueFactory valueFactory = ((Session)ProductsSuggestionOmniSearchHandler.this.resolver.adaptTo(Session.class)).getValueFactory();
            ArrayList<Row> rows = new ArrayList<Row>();
            while (it.hasNext()) {
                String title = (String)it.next().getValueMap().get("jcr:title", String.class);
                Value value = valueFactory.createValue(title);
                rows.add(new SuggestionRow(value));
            }
            RowIterator suggestionIterator = queryResult.getRows();
            while (suggestionIterator.hasNext()) {
                rows.add(suggestionIterator.nextRow());
            }
            SuggestionQueryResult result = new SuggestionQueryResult(rows);
            return result;
        }

        public void setLimit(long limit) {
        }

        public void setOffset(long offset) {
        }

        public String getStatement() {
            return null;
        }

        public String getLanguage() {
            return null;
        }

        public String getStoredQueryPath() throws ItemNotFoundException, RepositoryException {
            return null;
        }

        public Node storeAsNode(String absPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, UnsupportedRepositoryOperationException, RepositoryException {
            return null;
        }

        public void bindValue(String varName, Value value) throws IllegalArgumentException, RepositoryException {
        }

        public String[] getBindVariableNames() throws RepositoryException {
            return null;
        }
    }
}

