/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.gui.components.configuration.servlets;

import com.adobe.cq.commerce.utils.ConfigInheritance;
import com.adobe.cq.commerce.virtual.catalog.data.Constants;
import java.io.IOException;
import javax.servlet.Servlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, name="ConfigurationInheritanceServlet", immediate=true, property={"sling.servlet.methods=GET", "sling.servlet.selectors=cifconfig", "sling.servlet.extensions=json", "sling.servlet.resourceTypes=sling/servlet/default"})
public class ConfigurationInheritanceServlet
extends SlingSafeMethodsServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationInheritanceServlet.class);
    private static final String[] CONFIG_KEYS = new String[]{"cq:catalogDataResourceProviderFactory", "cq:catalogIdentifier", "cq:graphqlClient", "jcr:language", "magentoGraphqlEndpoint", "magentoRootCategoryId", "magentoStore"};

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        try {
            Resource resource = request.getResource();
            String resourcePath = resource.getPath();
            String configContainerPath = resourcePath.endsWith(Constants.COMMERCE_BUCKET_PATH) ? resourcePath.replace("/" + Constants.COMMERCE_BUCKET_PATH, "") : resourcePath;
            Resource configContainerResource = request.getResourceResolver().getResource(configContainerPath);
            if (configContainerResource == null) {
                response.sendError(500, "Unable to load configuration container resource");
                return;
            }
            JSONObject config = ConfigInheritance.getInheritanceMap(configContainerResource, CONFIG_KEYS);
            response.setContentType("application/json");
            response.getWriter().println(config.toString());
        }
        catch (JSONException e) {
            LOGGER.error("Unable to retrieve config: {}", (Object)e.getMessage());
            response.sendError(500, "Unable to create JSON response");
        }
    }
}

