/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.gui.components.configuration;

import com.adobe.cq.commerce.virtual.catalog.data.Constants;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.StreamSupport;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={ConfigurationColumnViewItem.class}, resourceType={"commerce/gui/components/configuration/columnviewitem"})
public class ConfigurationColumnViewItem {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationColumnViewItem.class);
    static final String CREATE_PULLDOWN_ACTIVATOR = "cq-confadmin-actions-create-pulldown-activator";
    static final String CREATE_CONFIG_ACTIVATOR = "cq-confadmin-actions-create-config-activator";
    static final String PROPERTIES_ACTIVATOR = "cq-confadmin-actions-properties-activator";
    static final String CREATE_FOLDER_ACTIVATOR = "cq-confadmin-actions-create-folder-activator";
    static final String DELETE_ACTIVATOR = "cq-confadmin-actions-delete-activator";
    static final String PUBLISH_ACTIVATOR = "cq-confadmin-actions-publish-activator";
    static final String UNPUBLISH_ACTIVATOR = "cq-confadmin-actions-unpublish-activator";
    @Inject
    private Resource resource;
    private boolean hasCommerceSetting;

    @PostConstruct
    public void initModel() {
        LOG.debug("Initializing column view item for resource {}", (Object)this.resource.getPath());
        this.hasCommerceSetting = this.resource.getChild(Constants.COMMERCE_BUCKET_PATH) != null;
    }

    public String getTitle() {
        Resource jcrContent = this.resource.getChild("jcr:content");
        ValueMap properties = jcrContent != null ? jcrContent.getValueMap() : this.resource.getValueMap();
        return (String)properties.get("jcr:title", (Object)this.resource.getName());
    }

    public boolean hasChildren() {
        if (this.isCommerceBucket()) {
            return false;
        }
        boolean isContainer = this.isConfigurationContainer();
        boolean hasChildren = this.resource.hasChildren();
        boolean hasMoreChildren = this.getChildCount(this.resource) > 1L;
        boolean hasSettings = this.resource.getChild("settings") != null;
        return isContainer && (this.hasCommerceSetting || hasMoreChildren) || !isContainer && !this.hasCommerceSetting && (hasChildren && !hasSettings || hasMoreChildren && hasSettings);
    }

    private boolean isCommerceBucket() {
        return this.resource.getPath().endsWith(Constants.COMMERCE_BUCKET_PATH);
    }

    public List<String> getQuickActionsRel() {
        ArrayList<String> actions = new ArrayList<String>();
        if (this.isConfigurationContainer() && !this.hasCommerceSetting && !this.resource.getPath().equals("/conf")) {
            actions.add(CREATE_PULLDOWN_ACTIVATOR);
            actions.add(CREATE_CONFIG_ACTIVATOR);
        }
        if (this.isCommerceBucket()) {
            actions.add(PROPERTIES_ACTIVATOR);
            actions.add(PUBLISH_ACTIVATOR);
            actions.add(UNPUBLISH_ACTIVATOR);
        } else {
            if (!actions.contains(CREATE_PULLDOWN_ACTIVATOR)) {
                actions.add(CREATE_PULLDOWN_ACTIVATOR);
            }
            actions.add(CREATE_FOLDER_ACTIVATOR);
        }
        if (this.isSafeToDelete()) {
            actions.add(DELETE_ACTIVATOR);
        }
        return actions;
    }

    private boolean isConfigurationContainer() {
        return this.resource.getPath().startsWith("/conf") && this.isFolder(this.resource) && this.resource.getChild("settings/cloudconfigs") != null;
    }

    private boolean isFolder(Resource resource) {
        return resource.isResourceType("nt:folder") || this.isSlingFolder(resource);
    }

    private boolean isSafeToDelete() {
        if (this.isCommerceBucket()) {
            return true;
        }
        if (this.resource.getPath().startsWith("/conf") && this.isSlingFolder(this.resource) && this.hasOnlyChild(this.resource, "settings")) {
            Resource container = this.resource.getChild("settings");
            return this.hasOnlyChild(container, "cloudconfigs") && !container.getChild("cloudconfigs").hasChildren();
        }
        return false;
    }

    private boolean isSlingFolder(Resource resource) {
        return resource.isResourceType("sling:Folder") || resource.isResourceType("sling:OrderedFolder");
    }

    private boolean hasOnlyChild(Resource resource, String child) {
        return this.getChildCount(resource) == 1L && resource.getChild(child) != null;
    }

    private long getChildCount(Resource resource) {
        return StreamSupport.stream(resource.getChildren().spliterator(), false).count();
    }
}

