/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.gui.components.configuration;

import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.day.cq.replication.ReplicationStatus;
import java.util.Calendar;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.Self;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={ConfigurationColumnPreview.class}, resourceType={"commerce/gui/components/configuration/columnpreview"})
public class ConfigurationColumnPreview {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationColumnPreview.class);
    @Self
    public SlingHttpServletRequest request;
    @Inject
    public Resource resource;
    boolean isFolder = false;
    private Resource itemResource;
    private ValueMap properties;
    private Calendar modifiedTime = null;
    private Calendar publishedTime = null;

    @PostConstruct
    protected void initModel() {
        Resource jcrContent;
        Config cfg = new Config(this.request.getResource());
        SlingScriptHelper sling = ((SlingBindings)this.request.getAttribute(SlingBindings.class.getName())).getSling();
        ExpressionResolver expressionResolver = (ExpressionResolver)sling.getService(ExpressionResolver.class);
        ExpressionHelper ex = new ExpressionHelper(expressionResolver, this.request);
        String itemResourcePath = ex.getString((String)cfg.get("path", String.class));
        LOG.debug("Item in preview is at path {}", (Object)itemResourcePath);
        this.itemResource = this.request.getResourceResolver().getResource(itemResourcePath);
        if (this.itemResource == null) {
            return;
        }
        boolean bl = this.isFolder = this.itemResource.isResourceType("nt:folder") || this.itemResource.isResourceType("sling:Folder") || this.itemResource.isResourceType("sling:OrderedFolder");
        this.properties = this.isFolder ? this.itemResource.getValueMap() : ((jcrContent = this.itemResource.getChild("jcr:content")) != null ? jcrContent.getValueMap() : this.itemResource.getValueMap());
        this.modifiedTime = (Calendar)this.properties.get("cq:lastModified", Calendar.class);
        ReplicationStatus replicationStatus = (ReplicationStatus)this.itemResource.adaptTo(ReplicationStatus.class);
        this.publishedTime = replicationStatus != null && !replicationStatus.isDeactivated() ? replicationStatus.getLastPublished() : null;
    }

    public String getTitle() {
        return this.properties != null ? (String)this.properties.get("jcr:title", (Object)this.itemResource.getName()) : "";
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public String getItemResourcePath() {
        return this.itemResource != null ? this.itemResource.getPath() : "";
    }

    public String getModifiedTime() {
        return this.modifiedTime == null ? null : this.modifiedTime.toInstant().toString();
    }

    public String getPublishedTime() {
        return this.publishedTime == null ? null : this.publishedTime.toInstant().toString();
    }
}

