/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.gui.components.common.cifproductfield.impl;

import com.adobe.cq.commerce.graphql.search.CatalogSearchSupport;
import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.Servlet;
import org.apache.commons.collections4.iterators.TransformIterator;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, name="CIFProductFieldSearchDataSourceServlet", immediate=true, property={"sling.servlet.resourceTypes=commerce/gui/components/common/cifproductfield/datasources/search", "sling.servlet.methods=GET"})
public class SearchDataSourceServlet
extends SlingSafeMethodsServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchDataSourceServlet.class);
    static final String VIRTUAL_PRODUCT_QUERY_LANGUAGE = "virtualProductOmnisearchQuery";

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String PARAMETER_OFFSET = "_commerce_offset";
        String PARAMETER_LIMIT = "_commerce_limit";
        String PARAMETER_COMMERCE_TYPE = "_commerce_commerce_type";
        Config cfg = new Config(request.getResource().getChild(Config.DATASOURCE));
        SlingScriptHelper sling = ((SlingBindings)request.getAttribute(SlingBindings.class.getName())).getSling();
        ExpressionHelper ex = new ExpressionHelper((ExpressionResolver)sling.getService(ExpressionResolver.class), request);
        final String itemRT = (String)cfg.get("itemResourceType", String.class);
        long offset = (Long)ex.get((String)cfg.get("offset", (Object)"0"), Long.TYPE);
        long limit = (Long)ex.get((String)cfg.get("limit", (Object)"20"), Long.TYPE);
        String commerceType = (String)ex.get((String)cfg.get("commerceType", (Object)"product"), String.class);
        HashMap<String, String> queryParameters = new HashMap<String, String>(request.getParameterMap());
        queryParameters.put("_commerce_offset", String.valueOf(offset));
        queryParameters.put("_commerce_limit", String.valueOf(limit));
        queryParameters.put("_commerce_commerce_type", commerceType);
        String rootPath = request.getParameter("root");
        String rootCategoryId = new CatalogSearchSupport(request.getResourceResolver()).findCategoryId(rootPath);
        if (rootCategoryId != null) {
            queryParameters.put("categoryId", rootCategoryId);
            queryParameters.put("categoryPath", rootPath);
        }
        String queryString = new ObjectMapper().writeValueAsString(queryParameters);
        try {
            Iterator virtualResults = request.getResourceResolver().findResources(queryString, VIRTUAL_PRODUCT_QUERY_LANGUAGE);
            SimpleDataSource ds = new SimpleDataSource((Iterator)new TransformIterator(virtualResults, r -> new ResourceWrapper((Resource)r){

                public String getResourceType() {
                    return itemRT;
                }
            }));
            request.setAttribute(DataSource.class.getName(), (Object)ds);
        }
        catch (Exception x) {
            response.sendError(500, x.getMessage());
            LOGGER.error("Error finding resources", (Throwable)x);
        }
    }
}

