/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.gui.components.common.cifproductfield.impl;

import com.adobe.cq.commerce.api.conf.CommerceBasePathsService;
import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.PagingIterator;
import com.adobe.granite.ui.components.ds.AbstractDataSource;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.EmptyDataSource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.PredicateUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.FalsePredicate;
import org.apache.commons.collections.functors.OrPredicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.collections.iterators.ObjectGraphIterator;
import org.apache.commons.collections.iterators.TransformIterator;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class}, name="CIFProductFieldChildrenDataSourceServlet", immediate=true, property={"sling.servlet.resourceTypes=commerce/gui/components/common/cifproductfield/datasources/children", "sling.servlet.methods=GET"})
public class ChildrenDataSourceServlet
extends SlingSafeMethodsServlet {
    private static Predicate FOLDER_PREDICATE = ChildrenDataSourceServlet.createFolderPredicate();
    private static Predicate PRODUCT_PREDICATE = ChildrenDataSourceServlet.createProductPredicate("product");
    private static Predicate VARIANT_PREDICATE = ChildrenDataSourceServlet.createProductPredicate("variant");

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        Object ds;
        String searchName;
        String parentPath;
        SlingScriptHelper sling = ChildrenDataSourceServlet.getScriptHelper((ServletRequest)request);
        ExpressionHelper ex = new ExpressionHelper((ExpressionResolver)sling.getService(ExpressionResolver.class), request);
        Config dsCfg = new Config(request.getResource().getChild(Config.DATASOURCE));
        CommerceBasePathsService cbps = (CommerceBasePathsService)sling.getService(CommerceBasePathsService.class);
        String query = ex.getString((String)dsCfg.get("query", String.class));
        if (query != null) {
            String rootPath = ex.getString((String)dsCfg.get("rootPath", (Object)cbps.getProductsBasePath()));
            int slashIndex = query.lastIndexOf(47);
            if (slashIndex < 0) {
                parentPath = rootPath;
                searchName = query.toLowerCase();
            } else if (!query.startsWith(rootPath)) {
                parentPath = rootPath;
                searchName = null;
            } else if (slashIndex == query.length() - 1) {
                parentPath = query;
                searchName = null;
            } else {
                parentPath = query.substring(0, slashIndex + 1);
                searchName = query.substring(slashIndex + 1).toLowerCase();
            }
        } else {
            parentPath = ex.getString((String)dsCfg.get("path", String.class));
            searchName = null;
        }
        final Resource parent = request.getResourceResolver().getResource(parentPath);
        if (parent == null) {
            ds = EmptyDataSource.instance();
        } else {
            final Integer offset = (Integer)ex.get((String)dsCfg.get("offset", String.class), Integer.class);
            final Integer limit = (Integer)ex.get((String)dsCfg.get("limit", String.class), Integer.class);
            String itemRT = (String)dsCfg.get("itemResourceType", String.class);
            final String filter = ex.getString((String)dsCfg.get("filter", String.class));
            ArrayList<Predicate> predicates = new ArrayList<Predicate>(2);
            predicates.add(Filter.getFilter(filter));
            if (searchName != null) {
                Pattern searchNamePattern = Pattern.compile(Pattern.quote(searchName), 2);
                predicates.add(o -> searchNamePattern.matcher(((Resource)o).getName()).lookingAt());
            }
            final Predicate predicate = PredicateUtils.allPredicate(predicates);
            final Transformer transformer = ChildrenDataSourceServlet.createTransformer(itemRT, predicate);
            AbstractDataSource datasource = new AbstractDataSource(){

                public Iterator<Resource> iterator() {
                    Iterator iterator;
                    if (Filter.product.name().equals(filter)) {
                        Transformer transformer2 = resource -> {
                            if (Filter.product.evaluate(resource)) {
                                return resource;
                            }
                            return ((Resource)resource).listChildren();
                        };
                        iterator = new ObjectGraphIterator((Object)parent, transformer2);
                    } else {
                        iterator = parent.listChildren();
                    }
                    FilterIterator filterIterator = new FilterIterator(iterator, predicate);
                    PagingIterator pagingIterator = new PagingIterator((Iterator)filterIterator, offset, limit);
                    return new TransformIterator((Iterator)pagingIterator, transformer);
                }
            };
            ds = datasource;
        }
        request.setAttribute(DataSource.class.getName(), ds);
    }

    private static Transformer createTransformer(final String itemRT, final Predicate predicate) {
        return new Transformer(){

            public Object transform(Object o) {
                Resource r = (Resource)o;
                return new PredicatedResourceWrapper(r, predicate){

                    public String getResourceType() {
                        if (itemRT == null) {
                            return super.getResourceType();
                        }
                        return itemRT;
                    }
                };
            }
        };
    }

    private static SlingScriptHelper getScriptHelper(ServletRequest request) {
        SlingBindings bindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
        return bindings.getSling();
    }

    private static Predicate createFolderPredicate() {
        return object -> {
            Resource resource = (Resource)object;
            return resource.isResourceType("sling:Folder") || resource.isResourceType("sling:OrderedFolder") || resource.isResourceType("nt:folder");
        };
    }

    private static Predicate createProductPredicate(String commerceType) {
        return object -> {
            Resource resource = (Resource)object;
            ValueMap valueMap = resource.getValueMap();
            return valueMap.containsKey((Object)"sling:resourceType") && resource.isResourceType("commerce/components/product") && valueMap.containsKey((Object)"cq:commerceType") && commerceType.equals(valueMap.get("cq:commerceType", String.class));
        };
    }

    static /* synthetic */ Predicate access$000() {
        return PRODUCT_PREDICATE;
    }

    static /* synthetic */ Predicate access$100() {
        return FOLDER_PREDICATE;
    }

    static /* synthetic */ Predicate access$200() {
        return VARIANT_PREDICATE;
    }

    private static class PredicatedResourceWrapper
    extends ResourceWrapper {
        private Predicate predicate;

        PredicatedResourceWrapper(Resource resource, Predicate predicate) {
            super(resource);
            this.predicate = predicate;
        }

        public Resource getChild(String relPath) {
            Resource child = super.getChild(relPath);
            if (child == null || !this.predicate.evaluate((Object)child)) {
                return null;
            }
            return new PredicatedResourceWrapper(child, this.predicate);
        }

        public Iterator<Resource> listChildren() {
            return new TransformIterator((Iterator)new FilterIterator(super.listChildren(), this.predicate), o -> new PredicatedResourceWrapper((Resource)o, this.predicate));
        }

        public boolean hasChildren() {
            return super.hasChildren() && this.listChildren().hasNext();
        }
    }

    static enum Filter implements Predicate
    {
        product(ChildrenDataSourceServlet.access$000()),
        folderOrProduct(ChildrenDataSourceServlet.access$100(), ChildrenDataSourceServlet.access$000()),
        folderOrProductOrVariant(ChildrenDataSourceServlet.access$100(), ChildrenDataSourceServlet.access$000(), ChildrenDataSourceServlet.access$200());

        private final Predicate predicate;

        private Filter(Predicate ... predicates) {
            Predicate acc = FalsePredicate.INSTANCE;
            for (Predicate p : predicates) {
                acc = new OrPredicate(acc, p);
            }
            this.predicate = acc;
        }

        public boolean evaluate(Object object) {
            return this.predicate.evaluate(object);
        }

        private static Predicate getFilter(String filter) {
            if (filter == null) {
                return folderOrProduct;
            }
            try {
                return Filter.valueOf(filter);
            }
            catch (IllegalArgumentException x) {
                return folderOrProduct;
            }
        }
    }
}

