/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.graphql.search;

import com.day.cq.commons.inherit.ComponentInheritanceValueMap;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.caconfig.ConfigurationBuilder;

public class CatalogSearchSupport {
    public static final String PN_CATALOG_PATH = "cq:catalogPath";
    public static final String COMPONENT_DIALOG_URI_MARKER = "/_cq_dialog.html/";
    public static final String PAGE_PROPERTIES_URI_MARKER = "/sites/properties.html";
    private ResourceResolver resolver;

    public CatalogSearchSupport(ResourceResolver resolver) {
        this.resolver = resolver;
    }

    public String findCategoryId(String path) {
        if (StringUtils.isBlank((String)path)) {
            return null;
        }
        Resource rootResource = this.resolver.getResource(path);
        if (rootResource == null) {
            return null;
        }
        String categoryId = null;
        if ("category".equals(rootResource.getValueMap().get("cq:commerceType", String.class))) {
            categoryId = (String)rootResource.getValueMap().get("cifId", String.class);
        }
        if (StringUtils.isBlank(categoryId)) {
            ComponentInheritanceValueMap inherited = new ComponentInheritanceValueMap(rootResource);
            categoryId = (String)inherited.getInherited("magentoRootCategoryId", String.class);
        }
        if (StringUtils.isBlank(categoryId)) {
            return null;
        }
        return categoryId;
    }

    public String findCatalogPath(String path) {
        ValueMap properties;
        if (StringUtils.isBlank((String)path)) {
            return null;
        }
        Page parentPage = ((PageManager)this.resolver.adaptTo(PageManager.class)).getContainingPage(path);
        if (parentPage == null) {
            return null;
        }
        ConfigurationBuilder configBuilder = (ConfigurationBuilder)parentPage.getContentResource().adaptTo(ConfigurationBuilder.class);
        if (configBuilder != null && (properties = configBuilder.name("cloudconfigs/commerce").asValueMap()).containsKey((Object)PN_CATALOG_PATH)) {
            return (String)properties.get(PN_CATALOG_PATH, String.class);
        }
        HierarchyNodeInheritanceValueMap inheritedProperties = new HierarchyNodeInheritanceValueMap(parentPage.getContentResource());
        return (String)inheritedProperties.getInherited(PN_CATALOG_PATH, String.class);
    }

    public String findCatalogPathForPicker(SlingHttpServletRequest request) {
        String requestURI = request.getRequestURI();
        if (requestURI.contains(COMPONENT_DIALOG_URI_MARKER)) {
            String suffix = request.getRequestPathInfo().getSuffix();
            return this.findCatalogPath(suffix);
        }
        if (requestURI.contains(PAGE_PROPERTIES_URI_MARKER)) {
            String item = request.getParameter("item");
            return this.findCatalogPath(item);
        }
        return null;
    }
}

