/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.graphql.resource;

import com.adobe.cq.commerce.graphql.magento.GraphqlDataService;
import com.adobe.cq.commerce.graphql.resource.CategoryProductsIterator;
import com.adobe.cq.commerce.graphql.resource.CategoryResource;
import com.adobe.cq.commerce.graphql.resource.ErrorResource;
import com.adobe.cq.commerce.graphql.resource.ProductResource;
import com.adobe.cq.commerce.graphql.resource.SyntheticImageResource;
import com.adobe.cq.commerce.magento.graphql.CategoryTree;
import com.adobe.cq.commerce.magento.graphql.ConfigurableProduct;
import com.adobe.cq.commerce.magento.graphql.ConfigurableVariant;
import com.adobe.cq.commerce.magento.graphql.ProductInterface;
import com.adobe.cq.commerce.magento.graphql.SimpleProduct;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResourceMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceMapper.class);
    private String root;
    private GraphqlDataService graphqlDataService;
    private Integer rootCategoryId;
    private String storeView;

    ResourceMapper(String root, GraphqlDataService graphqlDataService, Map<String, String> properties) {
        this.root = root;
        this.graphqlDataService = graphqlDataService;
        this.storeView = properties.get("magentoStore");
        this.rootCategoryId = Integer.valueOf(properties.get("magentoRootCategoryId"));
    }

    String getRoot() {
        return this.root;
    }

    CategoryResource resolveCategory(ResourceResolver resolver, String path) {
        CategoryTree category;
        String subPath = path.substring(this.root.length() + 1);
        if (StringUtils.isNotBlank((CharSequence)subPath) && (category = this.graphqlDataService.getCategoryByPath(subPath, this.storeView)) != null) {
            return new CategoryResource(resolver, path, category);
        }
        return null;
    }

    ProductResource resolveProduct(ResourceResolver resolver, String path) {
        List<String> productParts = this.resolveProductParts(path);
        try {
            String sku = productParts.get(0);
            ProductInterface product = this.graphqlDataService.getProductBySku(sku, this.storeView);
            if (product != null && product.getId() != null) {
                boolean isVariant = productParts.size() > 1;
                return new ProductResource(resolver, path, product, isVariant ? productParts.get(1) : null);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while fetching category products", (Throwable)e);
            return null;
        }
        return null;
    }

    SyntheticImageResource resolveProductImage(ResourceResolver resolver, String path) {
        String productPath = path.substring(0, path.length() - "/image".length());
        List<String> productParts = this.resolveProductParts(productPath);
        try {
            String sku = productParts.size() == 1 ? productParts.get(0) : productParts.get(1);
            ProductInterface product = this.graphqlDataService.getProductBySku(sku, this.storeView);
            if (product != null) {
                ConfigurableProduct cp;
                String imageUrl = product.getImage().getUrl();
                if (imageUrl == null && product instanceof ConfigurableProduct && (cp = (ConfigurableProduct)product).getVariants() != null && cp.getVariants().size() > 0) {
                    imageUrl = ((ConfigurableVariant)cp.getVariants().get(0)).getProduct().getImage().getUrl();
                }
                if (imageUrl != null) {
                    return new SyntheticImageResource(resolver, path, "commerce/components/product/image", imageUrl);
                }
                return null;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error while fetching category products", (Throwable)e);
            return null;
        }
        return null;
    }

    private List<String> resolveProductParts(String path) {
        String subPath = path.substring(this.root.length() + 1);
        int backtrackCounter = 0;
        ArrayList<String> productParts = new ArrayList();
        String[] parts = subPath.split("/");
        for (String part : Lists.reverse(Arrays.asList(parts))) {
            productParts.add(part);
            String categorySubPath = StringUtils.substring((String)subPath, (int)0, (int)(backtrackCounter -= part.length() + 1));
            if (this.graphqlDataService.getCategoryByPath(categorySubPath, this.storeView) == null) continue;
            break;
        }
        productParts = Lists.reverse(productParts);
        return productParts;
    }

    Iterator<Resource> listCategoryChildren(ResourceResolver resolver, Resource parent) {
        List subChildren;
        CategoryTree categoryTree;
        String parentPath = parent.getPath();
        String parentCifId = (String)parent.getValueMap().get("cifId", String.class);
        boolean isRoot = parentPath.equals(this.root);
        String subPath = isRoot ? "" : parentPath.substring(this.root.length() + 1);
        ArrayList<CategoryResource> children = new ArrayList<CategoryResource>();
        try {
            categoryTree = StringUtils.isNotBlank((CharSequence)subPath) ? this.graphqlDataService.getCategoryByPath(subPath, this.storeView) : this.graphqlDataService.getCategoryById(this.rootCategoryId, this.storeView);
        }
        catch (Exception x) {
            LOGGER.error("Error while fetching child categories", (Throwable)x);
            ArrayList<ErrorResource> list = new ArrayList<ErrorResource>();
            list.add(new ErrorResource(resolver, parent.getPath()));
            return list.iterator();
        }
        if (categoryTree != null && (subChildren = categoryTree.getChildren()) != null) {
            for (CategoryTree child : subChildren) {
                children.add(new CategoryResource(resolver, this.root + "/" + child.getUrlPath(), child));
            }
        }
        if (children.isEmpty() && StringUtils.isNotBlank((CharSequence)parentCifId)) {
            try {
                return new CategoryProductsIterator(parent, this.graphqlDataService, 20, this.storeView);
            }
            catch (Exception e) {
                LOGGER.error("Error while fetching category products for " + parentPath + " (" + parentCifId + ")", (Throwable)e);
            }
        }
        return children.isEmpty() ? null : children.iterator();
    }

    Iterator<Resource> listProductChildren(ResourceResolver resolver, Resource parent) {
        String sku = (String)parent.getValueMap().get("sku", String.class);
        String parentPath = parent.getPath();
        try {
            ConfigurableProduct product;
            List variants;
            ProductInterface productInterface = this.graphqlDataService.getProductBySku(sku, this.storeView);
            if (productInterface == null) {
                return null;
            }
            String imageUrl = null;
            if (productInterface.getImage() != null) {
                imageUrl = productInterface.getImage().getUrl();
            }
            ArrayList<Object> children = new ArrayList<Object>();
            if (productInterface instanceof ConfigurableProduct && (variants = (product = (ConfigurableProduct)productInterface).getVariants()) != null && !variants.isEmpty()) {
                for (ConfigurableVariant variant : variants) {
                    SimpleProduct simpleProduct = variant.getProduct();
                    String path = parentPath + "/" + simpleProduct.getSku();
                    children.add((Object)new ProductResource(resolver, path, (ProductInterface)simpleProduct, simpleProduct.getSku()));
                    if (imageUrl != null || simpleProduct.getImage() == null) continue;
                    imageUrl = simpleProduct.getImage().getUrl();
                }
            }
            if (imageUrl != null) {
                String imagePath = parentPath + "/image";
                SyntheticImageResource imageResource = new SyntheticImageResource(resolver, imagePath, "commerce/components/product/image", imageUrl);
                children.add(0, (Object)imageResource);
            }
            return children.iterator();
        }
        catch (Exception e) {
            LOGGER.error("Error while fetching variants for product " + sku, (Throwable)e);
            return null;
        }
    }
}

