/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.graphql.resource;

import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.common.ValueMapDecorator;
import com.adobe.cq.commerce.graphql.core.MagentoProduct;
import com.adobe.cq.commerce.magento.graphql.ConfigurableProduct;
import com.adobe.cq.commerce.magento.graphql.Money;
import com.adobe.cq.commerce.magento.graphql.ProductInterface;
import com.adobe.cq.commerce.magento.graphql.SimpleProduct;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.DeepReadValueMapDecorator;

class ProductResource
extends SyntheticResource {
    protected static final String PRODUCT_RESOURCE_TYPE = "commerce/components/product";
    protected static final String PRODUCT_IDENTIFIER = "identifier";
    protected static final String PRODUCT_SUMMARY = "summary";
    protected static final String PRODUCT_FEATURES = "features";
    private ProductInterface magentoProduct;
    private String activeVariantSku;
    private ValueMap values;

    ProductResource(ResourceResolver resourceResolver, String path, ProductInterface product) {
        this(resourceResolver, path, product, null);
    }

    ProductResource(ResourceResolver resourceResolver, String path, ProductInterface product, String activeVariantSku) {
        super(resourceResolver, path, PRODUCT_RESOURCE_TYPE);
        String formattedPrice;
        this.magentoProduct = product;
        this.activeVariantSku = activeVariantSku;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jcr:title", product.getName());
        map.put("jcr:primaryType", "nt:unstructured");
        map.put(PRODUCT_IDENTIFIER, product.getId());
        map.put("sku", activeVariantSku != null ? activeVariantSku : product.getSku());
        map.put("slug", product.getUrlKey());
        map.put("sling:resourceType", PRODUCT_RESOURCE_TYPE);
        map.put("cq:commerceProvider", "magento-graphql");
        if (product.getDescription() != null) {
            map.put("jcr:description", product.getDescription().getHtml());
        }
        if (product.getUpdatedAt() != null) {
            map.put("jcr:lastModified", this.convertToDate(product.getUpdatedAt()));
        }
        if (StringUtils.isNotBlank((CharSequence)(formattedPrice = this.toFormattedPrice(product)))) {
            map.put("formattedPrice", formattedPrice);
        }
        map.put("cq:commerceType", activeVariantSku != null ? "variant" : "product");
        if (activeVariantSku != null || product instanceof SimpleProduct) {
            map.put("hasChildren", false);
        } else if (product instanceof ConfigurableProduct) {
            map.put("hasChildren", true);
        }
        this.values = new DeepReadValueMapDecorator((Resource)this, (ValueMap)new ValueMapDecorator(map));
    }

    private Date convertToDate(String magentoDate) {
        SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return inputFormat.parse(magentoDate);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private String toFormattedPrice(ProductInterface product) {
        if (product.getPrice() == null || product.getPrice().getRegularPrice() == null) {
            return null;
        }
        Money money = product.getPrice().getRegularPrice().getAmount();
        return money != null ? money.getCurrency() + " " + money.getValue() : null;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ValueMap.class) {
            return (AdapterType)this.values;
        }
        if (type == Product.class) {
            return (AdapterType)new MagentoProduct(this.getResourceResolver(), this.getPath(), this.magentoProduct, this.activeVariantSku);
        }
        return (AdapterType)super.adaptTo(type);
    }
}

