/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.graphql.resource;

import com.adobe.cq.commerce.graphql.magento.GraphqlDataService;
import com.adobe.cq.commerce.graphql.resource.GraphqlResourceProvider;
import com.adobe.cq.commerce.virtual.catalog.data.CatalogDataResourceProviderFactory;
import com.adobe.cq.commerce.virtual.catalog.data.CatalogIdentifier;
import com.day.cq.commons.inherit.ComponentInheritanceValueMap;
import com.day.cq.commons.inherit.HierarchyNodeInheritanceValueMap;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.caconfig.ConfigurationBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={CatalogDataResourceProviderFactory.class, CatalogIdentifier.class}, immediate=true, property={"catalogDataResourceProviderFactory=magento-graphql"})
public class GraphqlResourceProviderFactory
implements CatalogDataResourceProviderFactory<Object>,
CatalogIdentifier {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphqlResourceProviderFactory.class);
    private static final String CONFIGURATION_NAME = "cloudconfigs/commerce";
    protected Map<String, GraphqlDataService> clients = new ConcurrentHashMap<String, GraphqlDataService>();

    @Reference(service=GraphqlDataService.class, bind="bindGraphqlDataService", unbind="unbindGraphqlDataService", cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC)
    protected void bindGraphqlDataService(GraphqlDataService client, Map<?, ?> properties) {
        String identifier = client.getIdentifier();
        LOGGER.info("Registering GraphqlDataService '{}'", (Object)identifier);
        this.clients.put(identifier, client);
    }

    protected void unbindGraphqlDataService(GraphqlDataService client, Map<?, ?> properties) {
        String identifier = client.getIdentifier();
        LOGGER.info("De-registering GraphqlDataService '{}'", (Object)identifier);
        this.clients.remove(identifier);
    }

    public GraphqlResourceProvider createResourceProvider(Resource root) {
        LOGGER.debug("Creating resource provider for resource at path {}", (Object)root.getPath());
        ConfigurationBuilder configurationBuilder = (ConfigurationBuilder)root.adaptTo(ConfigurationBuilder.class);
        ValueMap properties = configurationBuilder.name(CONFIGURATION_NAME).asValueMap();
        Map<Object, Object> collectedProperties = new HashMap();
        if (properties.size() == 0) {
            collectedProperties = this.readFallbackConfiguration(root);
        } else {
            for (String key : properties.keySet()) {
                collectedProperties.put(key, (String)properties.get(key, (Object)""));
            }
        }
        String catalogIdentifier = (String)collectedProperties.get("cq:catalogIdentifier");
        if (StringUtils.isEmpty((CharSequence)catalogIdentifier)) {
            LOGGER.warn("Could not find cq:catalogIdentifier property for given resource at " + root.getPath());
            return null;
        }
        String rootCategoryId = (String)collectedProperties.get("magentoRootCategoryId");
        try {
            Integer.valueOf(rootCategoryId);
        }
        catch (NumberFormatException x) {
            LOGGER.warn("Invalid {} {} at {}", new Object[]{"magentoRootCategoryId", rootCategoryId, root.getPath()});
            return null;
        }
        GraphqlDataService client = this.clients.get(catalogIdentifier);
        if (client == null) {
            LOGGER.warn("No MagentoGraphqlClient instance available for catalog identifier " + catalogIdentifier);
            return null;
        }
        GraphqlResourceProvider resourceProvider = new GraphqlResourceProvider(root.getPath(), client, collectedProperties);
        return resourceProvider;
    }

    public Collection<String> getAllCatalogIdentifiers() {
        return this.clients.keySet();
    }

    public String getCommerceProviderName() {
        return "magento-graphql";
    }

    private Map<String, String> readFallbackConfiguration(Resource res) {
        Page page = ((PageManager)res.getResourceResolver().adaptTo(PageManager.class)).getContainingPage(res);
        Object ivm = page != null ? new HierarchyNodeInheritanceValueMap(page.getContentResource()) : new ComponentInheritanceValueMap(res);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("cq:catalogIdentifier", (String)ivm.getInherited("cq:catalogIdentifier", String.class));
        properties.put("magentoRootCategoryId", (String)ivm.getInherited("magentoRootCategoryId", String.class));
        properties.put("magentoStore", (String)ivm.getInherited("cq:magentoStore", String.class));
        return properties;
    }
}

