/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.graphql.resource;

import com.adobe.cq.commerce.graphql.magento.GraphqlDataService;
import com.adobe.cq.commerce.graphql.resource.CategoryResource;
import com.adobe.cq.commerce.graphql.resource.GraphqlQueryLanguageProvider;
import com.adobe.cq.commerce.graphql.resource.ResourceMapper;
import com.adobe.cq.commerce.graphql.resource.RootCategoryResource;
import java.util.Iterator;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GraphqlResourceProvider
extends ResourceProvider<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphqlResourceProvider.class);
    private String root;
    private Integer rootCategoryId;
    private ResourceMapper resourceMapper;
    private GraphqlQueryLanguageProvider queryLanguageProvider;

    GraphqlResourceProvider(String root, GraphqlDataService graphqlDataService, Map<String, String> properties) {
        this.root = root;
        this.rootCategoryId = Integer.valueOf(properties.get("magentoRootCategoryId"));
        this.resourceMapper = new ResourceMapper(root, graphqlDataService, properties);
        this.queryLanguageProvider = new GraphqlQueryLanguageProvider(this.resourceMapper, graphqlDataService, properties);
    }

    public Resource getResource(ResolveContext<Object> ctx, String path, ResourceContext resourceContext, Resource parent) {
        LOGGER.debug("getResource called for " + path);
        if (path.equals(this.root)) {
            Resource resource = ctx.getParentResourceProvider().getResource(ctx.getParentResolveContext(), path, resourceContext, parent);
            if (resource == null) {
                return null;
            }
            return new RootCategoryResource(resource, this.rootCategoryId);
        }
        if (path.contains("jcr:content") || path.endsWith(".jpg") || path.contains("assets") || path.contains("thumbnail") || path.contains("rep:policy")) {
            return null;
        }
        ResourceResolver resolver = ctx.getResourceResolver();
        CategoryResource category = this.resourceMapper.resolveCategory(resolver, path);
        if (category != null) {
            return category;
        }
        Object resource = path.endsWith("/image") ? this.resourceMapper.resolveProductImage(resolver, path) : this.resourceMapper.resolveProduct(resolver, path);
        return resource;
    }

    public Iterator<Resource> listChildren(ResolveContext<Object> ctx, Resource parent) {
        ValueMap valueMap = parent.getValueMap();
        String commerceType = (String)valueMap.get("cq:commerceType", String.class);
        ResourceResolver resolver = ctx.getResourceResolver();
        if (this.root.equals(parent.getPath()) || "category".equals(commerceType)) {
            return this.resourceMapper.listCategoryChildren(resolver, parent);
        }
        if ("product".equals(commerceType)) {
            return this.resourceMapper.listProductChildren(resolver, parent);
        }
        return null;
    }

    public GraphqlQueryLanguageProvider getQueryLanguageProvider() {
        return this.queryLanguageProvider;
    }
}

