/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.graphql.resource;

import com.adobe.cq.commerce.graphql.magento.GraphqlDataService;
import com.adobe.cq.commerce.graphql.resource.CategoryResource;
import com.adobe.cq.commerce.graphql.resource.ProductResource;
import com.adobe.cq.commerce.graphql.resource.ResourceMapper;
import com.adobe.cq.commerce.magento.graphql.CategoryInterface;
import com.adobe.cq.commerce.magento.graphql.CategoryTree;
import com.adobe.cq.commerce.magento.graphql.ProductInterface;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.spi.resource.provider.QueryLanguageProvider;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphqlQueryLanguageProvider
implements QueryLanguageProvider<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphqlQueryLanguageProvider.class);
    public static final String CATEGORY_ID_PARAMETER = "categoryId";
    public static final String CATEGORY_PATH_PARAMETER = "categoryPath";
    static final String VIRTUAL_PRODUCT_QUERY_LANGUAGE = "virtualProductOmnisearchQuery";
    private static final String[] SUPPORTED_LANGUAGES = new String[]{"virtualProductOmnisearchQuery"};
    static final String FULLTEXT_PARAMETER = "fulltext";
    static final String OFFSET_PARAMETER = "_commerce_offset";
    static final String LIMIT_PARAMETER = "_commerce_limit";
    static final String COMMERCE_TYPE_PARAMETER = "_commerce_commerce_type";
    private ResourceMapper resourceMapper;
    private GraphqlDataService graphqlDataService;
    private ObjectMapper jsonMapper;
    private String storeView;

    GraphqlQueryLanguageProvider(ResourceMapper resourceMapper, GraphqlDataService graphqlDataService, Map<String, String> properties) {
        this.resourceMapper = resourceMapper;
        this.graphqlDataService = graphqlDataService;
        this.jsonMapper = new ObjectMapper();
        if (properties != null) {
            this.storeView = properties.get("magentoStore");
        }
    }

    public String[] getSupportedLanguages(ResolveContext<Object> paramResolveContext) {
        return SUPPORTED_LANGUAGES;
    }

    public Iterator<Resource> findResources(ResolveContext<Object> ctx, String query, String language) {
        if (!VIRTUAL_PRODUCT_QUERY_LANGUAGE.equals(language)) {
            return null;
        }
        Map<String, Object> queryParameters = this.stringToMap(query);
        String fulltext = this.extractParameter(FULLTEXT_PARAMETER, queryParameters);
        Integer offset = queryParameters.containsKey(OFFSET_PARAMETER) ? Integer.valueOf(queryParameters.get(OFFSET_PARAMETER).toString()) : Integer.valueOf(0);
        Integer limit = queryParameters.containsKey(LIMIT_PARAMETER) ? Integer.valueOf(queryParameters.get(LIMIT_PARAMETER).toString()) : Integer.valueOf(20);
        String commerceType = this.extractParameter(COMMERCE_TYPE_PARAMETER, queryParameters);
        if (StringUtils.isBlank((CharSequence)commerceType)) {
            commerceType = "product";
        }
        LOGGER.debug("Performing product search with '{}' (offset: {}, limit: {})", new Object[]{fulltext, offset, limit});
        Pair<Integer, Integer> pagination = GraphqlQueryLanguageProvider.toMagentoPageNumberAndSize(offset, limit);
        String categoryIdParam = this.extractParameter(CATEGORY_ID_PARAMETER, queryParameters);
        String categoryPathParam = this.extractParameter(CATEGORY_PATH_PARAMETER, queryParameters);
        if (StringUtils.isNotBlank((CharSequence)categoryPathParam) && !categoryPathParam.startsWith(this.resourceMapper.getRoot())) {
            return Collections.emptyIterator();
        }
        Integer categoryId = null;
        if (StringUtils.isNotBlank((CharSequence)categoryIdParam)) {
            try {
                categoryId = Integer.parseInt(categoryIdParam);
            }
            catch (NumberFormatException x) {
                LOGGER.warn("Invalid root category id {}", (Object)categoryIdParam);
            }
        }
        ResourceResolver resolver = ctx.getResourceResolver();
        if ("product".equals(commerceType)) {
            List<ProductInterface> products = this.graphqlDataService.searchProducts(fulltext, categoryId, (Integer)pagination.getLeft(), (Integer)pagination.getRight(), this.storeView);
            int start = offset - ((Integer)pagination.getLeft() - 1) * (Integer)pagination.getRight();
            int end = start + limit;
            if (start >= 0 && end <= products.size()) {
                products = products.subList(start, end);
            }
            LOGGER.debug("Returning {} products", (Object)products.size());
            ArrayList<ProductResource> resources = new ArrayList<ProductResource>();
            String root = this.resourceMapper.getRoot() + "/";
            for (ProductInterface product : products) {
                CategoryInterface category;
                List categories = product.getCategories();
                String path = root + product.getSku();
                if (categories != null && !categories.isEmpty() && (category = (CategoryInterface)categories.stream().filter(c -> c.getUrlPath() != null && this.resourceMapper.resolveCategory(resolver, root + c.getUrlPath()) != null).findFirst().orElse(null)) != null) {
                    path = root + category.getUrlPath() + "/" + product.getSku();
                }
                resources.add(new ProductResource(resolver, path, product));
            }
            return resources.iterator();
        }
        if ("category".equals(commerceType)) {
            ArrayList<CategoryResource> resources = new ArrayList<CategoryResource>();
            String root = this.resourceMapper.getRoot() + "/";
            List<CategoryTree> categories = this.graphqlDataService.searchCategories(fulltext, categoryId, (Integer)pagination.getLeft(), (Integer)pagination.getRight(), this.storeView);
            int start = offset;
            int end = Math.min(categories.size(), offset + limit);
            if (start >= 0 && end <= categories.size()) {
                categories = categories.subList(start, end);
            }
            for (CategoryTree category : categories) {
                String path = root + category.getUrlPath();
                resources.add(new CategoryResource(resolver, path, category));
            }
            return resources.iterator();
        }
        LOGGER.warn("Unknown commerce type: {}", (Object)commerceType);
        return Collections.emptyIterator();
    }

    protected static Pair<Integer, Integer> toMagentoPageNumberAndSize(int offset, int limit) {
        if (offset % limit == 0) {
            return Pair.of((Object)(offset / limit + 1), (Object)limit);
        }
        int total = offset + limit;
        for (int size = limit; size < total; ++size) {
            int min = offset - offset % size;
            int max = min + size;
            if (min > offset || max < total) continue;
            return Pair.of((Object)(min / size + 1), (Object)size);
        }
        return Pair.of((Object)1, (Object)total);
    }

    private String extractParameter(String parameterName, Map<String, Object> queryParams) {
        Set<Map.Entry<String, Object>> entries = queryParams.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            if (!entry.getKey().contains(parameterName)) continue;
            Object value = entry.getValue();
            if (value instanceof String) {
                return value.toString();
            }
            if (!(value instanceof List)) continue;
            return StringUtils.join((Iterable)((List)value), (char)' ');
        }
        return null;
    }

    public Iterator<ValueMap> queryResources(ResolveContext<Object> paramResolveContext, String query, String language) {
        return null;
    }

    private Map<String, Object> stringToMap(String s) {
        try {
            return (Map)this.jsonMapper.readValue(s, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        }
        catch (Exception e) {
            LOGGER.error("Cannot deserialize query string: " + s, (Throwable)e);
            return Collections.emptyMap();
        }
    }
}

