/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.graphql.resource;

import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.common.ValueMapDecorator;
import com.adobe.cq.commerce.magento.graphql.CategoryTree;
import java.util.HashMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.DeepReadValueMapDecorator;

class CategoryResource
extends SyntheticResource {
    private ValueMap values;

    CategoryResource(ResourceResolver resourceResolver, String path, CategoryTree category) {
        super(resourceResolver, path, "sling:Folder");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jcr:primaryType", "sling:Folder");
        map.put("sling:resourceType", "sling:Folder");
        map.put("cq:commerceType", "category");
        map.put("cq:commerceProvider", "magento-graphql");
        if (category != null) {
            map.put("jcr:title", category.getName());
            map.put("cifId", category.getId());
            map.put("urlPath", category.getUrlPath());
            String str = category.getChildrenCount();
            int childCount = 0;
            try {
                childCount = Integer.parseInt(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean hasChildren = childCount > 0;
            map.put("isLeaf", !(hasChildren |= category.getChildren() != null && !category.getChildren().isEmpty()));
            map.put("hasChildren", hasChildren |= category.getProductCount() != null && category.getProductCount() > 0);
        } else {
            map.put("jcr:title", "magento-graphql");
        }
        this.values = new DeepReadValueMapDecorator((Resource)this, (ValueMap)new ValueMapDecorator(map));
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (type == ValueMap.class) {
            return (AdapterType)this.values;
        }
        if (type == Product.class) {
            return null;
        }
        return (AdapterType)super.adaptTo(type);
    }
}

