/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.graphql.resource;

import com.adobe.cq.commerce.graphql.magento.GraphqlDataService;
import com.adobe.cq.commerce.graphql.resource.ProductResource;
import com.adobe.cq.commerce.magento.graphql.CategoryProducts;
import com.adobe.cq.commerce.magento.graphql.ProductInterface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.sling.api.resource.Resource;

public class CategoryProductsIterator
implements Iterator<Resource> {
    private Resource category;
    private String storeView;
    private Integer categoryId;
    private Integer totalCount;
    private int pageSize;
    private int nextIndex = 0;
    private List<Resource> items = new ArrayList<Resource>();
    private GraphqlDataService graphqlDataService;

    public CategoryProductsIterator(Resource category, GraphqlDataService graphqlDataService, Integer pageSize, String storeView) {
        this.category = category;
        this.categoryId = (Integer)category.getValueMap().get("cifId", Integer.class);
        this.graphqlDataService = graphqlDataService;
        this.pageSize = pageSize != null ? pageSize : 20;
        this.storeView = storeView;
    }

    @Override
    public boolean hasNext() {
        if (this.dataIsAvailable()) {
            return true;
        }
        if (!this.canLoadMoreProducts()) {
            return false;
        }
        Integer nextPage = this.items.size() / this.pageSize + 1;
        CategoryProducts categoryProducts = this.graphqlDataService.getCategoryProducts(this.categoryId, nextPage, this.pageSize, this.storeView);
        this.totalCount = categoryProducts.getTotalCount();
        List products = categoryProducts.getItems();
        if (products.size() == 0) {
            return false;
        }
        for (ProductInterface product : products) {
            String path = this.category.getPath() + "/" + product.getSku();
            this.items.add((Resource)new ProductResource(this.category.getResourceResolver(), path, product));
        }
        return true;
    }

    private boolean canLoadMoreProducts() {
        return this.totalCount == null || this.totalCount > this.items.size();
    }

    private boolean dataIsAvailable() {
        return this.nextIndex < this.items.size();
    }

    @Override
    public Resource next() {
        return this.items.get(this.nextIndex++);
    }
}

