/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.graphql.magento;

import com.adobe.cq.commerce.graphql.client.GraphqlClient;
import com.adobe.cq.commerce.graphql.client.GraphqlRequest;
import com.adobe.cq.commerce.graphql.client.GraphqlResponse;
import com.adobe.cq.commerce.graphql.client.RequestOptions;
import com.adobe.cq.commerce.graphql.magento.GraphqlDataService;
import com.adobe.cq.commerce.graphql.magento.GraphqlDataServiceConfiguration;
import com.adobe.cq.commerce.graphql.magento.GraphqlQueries;
import com.adobe.cq.commerce.magento.graphql.CategoryFilterInput;
import com.adobe.cq.commerce.magento.graphql.CategoryProducts;
import com.adobe.cq.commerce.magento.graphql.CategoryTree;
import com.adobe.cq.commerce.magento.graphql.CategoryTreeQueryDefinition;
import com.adobe.cq.commerce.magento.graphql.FilterEqualTypeInput;
import com.adobe.cq.commerce.magento.graphql.FilterMatchTypeInput;
import com.adobe.cq.commerce.magento.graphql.FilterRangeTypeInput;
import com.adobe.cq.commerce.magento.graphql.Operations;
import com.adobe.cq.commerce.magento.graphql.ProductAttributeFilterInput;
import com.adobe.cq.commerce.magento.graphql.ProductAttributeSortInput;
import com.adobe.cq.commerce.magento.graphql.ProductInterface;
import com.adobe.cq.commerce.magento.graphql.Products;
import com.adobe.cq.commerce.magento.graphql.ProductsQueryDefinition;
import com.adobe.cq.commerce.magento.graphql.Query;
import com.adobe.cq.commerce.magento.graphql.QueryQuery;
import com.adobe.cq.commerce.magento.graphql.SortEnum;
import com.adobe.cq.commerce.magento.graphql.gson.Error;
import com.adobe.cq.commerce.magento.graphql.gson.QueryDeserializer;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.message.BasicHeader;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={GraphqlDataService.class})
@Designate(ocd=GraphqlDataServiceConfiguration.class, factory=true)
public class GraphqlDataServiceImpl
implements GraphqlDataService {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphqlDataServiceImpl.class);
    private static final String MAGENTO_DEFAULT_STORE = "default";
    protected GraphqlClient baseClient;
    protected RequestOptions requestOptions;
    private volatile GraphqlDataServiceConfiguration configuration;
    private Cache<ArrayKey, Optional<ProductInterface>> productCache;
    private Cache<ArrayKey, Optional<CategoryProducts>> categoryProductsCache;
    private Cache<ArrayKey, Optional<List<CategoryTree>>> categoryDataCache;
    private Map<String, GraphqlClient> clients = new ConcurrentHashMap<String, GraphqlClient>();

    @Reference(service=GraphqlClient.class, bind="bindGraphqlClient", unbind="unbindGraphqlClient", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindGraphqlClient(GraphqlClient graphqlClient, Map<?, ?> properties) {
        String identifier = graphqlClient.getIdentifier();
        LOGGER.info("Registering GraphqlClient '{}'", (Object)identifier);
        this.clients.put(identifier, graphqlClient);
        if (this.configuration != null && identifier.equals(this.configuration.identifier())) {
            LOGGER.info("GraphqlClient with identifier '{}' has been registered, the service is ready to handle requests.", (Object)identifier);
            this.baseClient = graphqlClient;
        }
    }

    protected void unbindGraphqlClient(GraphqlClient graphqlClient, Map<?, ?> properties) {
        String identifier = graphqlClient.getIdentifier();
        LOGGER.info("De-registering GraphqlClient '{}'", (Object)identifier);
        this.clients.remove(identifier);
        if (this.configuration != null && identifier.equals(this.configuration.identifier())) {
            LOGGER.info("GraphqlClient '{}' unregistered: requests cannot be handled until that dependency is satisfied", (Object)identifier);
            this.baseClient = null;
        }
    }

    @Activate
    public void activate(GraphqlDataServiceConfiguration conf) throws Exception {
        this.configuration = conf;
        this.baseClient = this.clients.get(conf.identifier());
        if (this.baseClient == null) {
            LOGGER.warn("GraphqlClient '{}' not found: requests cannot be handled until that dependency is satisfied", (Object)conf.identifier());
        }
        this.productCache = CacheBuilder.newBuilder().maximumSize(this.configuration.productCachingEnabled() ? (long)this.configuration.productCachingSize() : 0L).expireAfterWrite((long)this.configuration.productCachingTimeMinutes(), TimeUnit.MINUTES).build();
        this.categoryProductsCache = CacheBuilder.newBuilder().maximumSize(this.configuration.productCachingEnabled() ? (long)this.configuration.categoryCachingSize() : 0L).expireAfterWrite((long)this.configuration.productCachingTimeMinutes(), TimeUnit.MINUTES).build();
        this.categoryDataCache = CacheBuilder.newBuilder().maximumSize(this.configuration.categoryCachingEnabled() ? (long)this.configuration.categoryCachingSize() : 0L).expireAfterWrite((long)this.configuration.categoryCachingTimeMinutes(), TimeUnit.MINUTES).build();
        this.requestOptions = new RequestOptions().withGson(QueryDeserializer.getGson());
    }

    protected GraphqlResponse<Query, Error> execute(String query, String storeView) {
        RequestOptions options = this.requestOptions;
        if (storeView != null) {
            BasicHeader storeHeader = new BasicHeader("Store", storeView);
            options = new RequestOptions().withGson(this.requestOptions.getGson()).withHeaders(Collections.singletonList(storeHeader));
        }
        return this.baseClient.execute(new GraphqlRequest(query), Query.class, Error.class, options);
    }

    @Override
    public ProductInterface getProductBySku(String sku, String storeView) {
        if (sku == null) {
            return null;
        }
        try {
            ArrayKey key = this.toProductCacheKey(sku, storeView);
            return ((Optional)this.productCache.get((Object)key, () -> this.getProductBySkuImpl(sku, storeView))).orElse(null);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CategoryTree getCategoryById(Integer id, String storeView) {
        if (id == null) {
            return null;
        }
        try {
            ArrayKey key = this.toCategoryDataCacheKey(id, storeView);
            List categoryTrees = ((Optional)this.categoryDataCache.get((Object)key, () -> this.getCategoryByIdImpl(id, storeView))).orElse(null);
            return categoryTrees == null ? null : (CategoryTree)categoryTrees.get(0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CategoryTree getCategoryByPath(String urlPath, String storeView) {
        if (StringUtils.isBlank((CharSequence)urlPath)) {
            return null;
        }
        String mainPart = null;
        String[] parts = urlPath.split("/");
        int i = parts.length;
        while (i > 0) {
            String part;
            if (!StringUtils.isNotBlank((CharSequence)(part = parts[--i]))) continue;
            mainPart = part;
            break;
        }
        if (mainPart == null) {
            return null;
        }
        try {
            String urlKey = mainPart;
            ArrayKey key = this.toCategoryDataCacheKey(urlKey, storeView);
            List categories = ((Optional)this.categoryDataCache.get((Object)key, () -> this.getCategoryByKeyImpl(urlKey, storeView))).orElse(null);
            if (categories == null) {
                return null;
            }
            for (CategoryTree category : categories) {
                if (!urlPath.equals(category.getUrlPath())) continue;
                return category;
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    Optional<ProductInterface> getProductBySkuImpl(String sku, String storeView) {
        LOGGER.debug("Trying to fetch product " + sku);
        FilterEqualTypeInput input = new FilterEqualTypeInput().setEq(sku);
        ProductAttributeFilterInput filter = new ProductAttributeFilterInput().setSku(input);
        QueryQuery.ProductsArgumentsDefinition searchArgs = s -> s.filter(filter);
        ProductsQueryDefinition queryArgs = q -> q.items(GraphqlQueries.CONFIGURABLE_PRODUCT_QUERY);
        String queryString = Operations.query(query -> query.products(searchArgs, queryArgs)).toString();
        GraphqlResponse<Query, Error> response = this.execute(queryString, storeView);
        Query query2 = (Query)response.getData();
        Products productsQuery = query2.getProducts();
        List products = productsQuery.getItems();
        ProductInterface product = products.size() > 0 ? (ProductInterface)products.get(0) : null;
        LOGGER.debug("Fetched product " + (product != null ? product.getName() : null));
        return Optional.ofNullable(product);
    }

    Optional<List<CategoryTree>> getCategoryByIdImpl(Integer id, String storeView) {
        LOGGER.debug("Trying to fetch category " + id);
        FilterEqualTypeInput input = new FilterEqualTypeInput().setEq(id.toString());
        CategoryFilterInput filter = new CategoryFilterInput().setIds(input);
        return this.getCategoryTree(storeView, filter);
    }

    Optional<List<CategoryTree>> getCategoryByKeyImpl(String urlKey, String storeView) {
        LOGGER.debug("Trying to fetch category " + urlKey);
        FilterEqualTypeInput name = new FilterEqualTypeInput().setEq(urlKey);
        CategoryFilterInput filter = new CategoryFilterInput().setUrlKey(name);
        return this.getCategoryTree(storeView, filter);
    }

    private Optional<List<CategoryTree>> getCategoryTree(String storeView, CategoryFilterInput filter) {
        CategoryTreeQueryDefinition queryArgs = q -> GraphqlQueries.CATEGORY_LAMBDA.apply(q).children(GraphqlQueries.CATEGORY_LAMBDA::apply);
        String queryString = Operations.query(query -> query.categoryList(q -> q.filters(filter), queryArgs)).toString();
        GraphqlResponse<Query, Error> response = this.execute(queryString, storeView);
        if (response.getData() == null && response.getErrors() != null) {
            throw new RuntimeException();
        }
        Query query2 = (Query)response.getData();
        List categoryList = query2.getCategoryList();
        return categoryList == null ? Optional.empty() : (categoryList.isEmpty() ? Optional.empty() : Optional.of(categoryList));
    }

    @Override
    public List<ProductInterface> searchProducts(String text, Integer categoryId, Integer currentPage, Integer pageSize, String storeView) {
        return this.searchProductsImpl(text, categoryId, currentPage, pageSize, storeView);
    }

    @Override
    public List<CategoryTree> searchCategories(String text, Integer categoryId, Integer currentPage, Integer pageSize, String storeView) {
        if (categoryId == null) {
            LOGGER.debug("Performing category search with '{}' (page: {}, size: {})", new Object[]{text, currentPage, pageSize});
        } else {
            LOGGER.debug("Performing category search with '{}' in category {} (page: {}, size: {})", new Object[]{text, categoryId, currentPage, pageSize});
        }
        FilterMatchTypeInput name = new FilterMatchTypeInput().setMatch(text);
        CategoryFilterInput filters = new CategoryFilterInput().setName(name);
        QueryQuery.CategoryListArgumentsDefinition searchArgs = q -> q.filters(filters);
        CategoryTreeQueryDefinition queryArgs = q -> GraphqlQueries.CATEGORY_SEARCH_QUERY.apply(q);
        String queryString = Operations.query(query -> query.categoryList(searchArgs, queryArgs)).toString();
        GraphqlResponse<Query, Error> response = this.execute(queryString, storeView);
        Query query2 = (Query)response.getData();
        List categoryList = query2.getCategoryList();
        return categoryList;
    }

    private List<ProductInterface> searchProductsImpl(String text, Integer categoryId, Integer currentPage, Integer pageSize, String storeView) {
        QueryQuery.ProductsArgumentsDefinition searchArgs;
        if (categoryId == null) {
            LOGGER.debug("Performing product search with '{}' (page: {}, size: {})", new Object[]{text, currentPage, pageSize});
        } else {
            LOGGER.debug("Performing product search with '{}' in category {} (page: {}, size: {})", new Object[]{text, categoryId, currentPage, pageSize});
        }
        ProductAttributeSortInput sortInput = new ProductAttributeSortInput().setRelevance(SortEnum.DESC);
        if (StringUtils.isNotEmpty((CharSequence)text)) {
            if (categoryId == null) {
                searchArgs = s -> s.search(text).sort(sortInput).currentPage(currentPage).pageSize(pageSize);
            } else {
                ProductAttributeFilterInput filter = new ProductAttributeFilterInput();
                filter.setCategoryId(new FilterEqualTypeInput().setEq(String.valueOf(categoryId)));
                searchArgs = s -> s.search(text).filter(filter).sort(sortInput).currentPage(currentPage).pageSize(pageSize);
            }
        } else {
            FilterRangeTypeInput input = new FilterRangeTypeInput().setFrom("");
            ProductAttributeFilterInput filter = new ProductAttributeFilterInput().setPrice(input);
            if (categoryId != null) {
                filter.setCategoryId(new FilterEqualTypeInput().setEq(String.valueOf(categoryId)));
            }
            searchArgs = s -> s.filter(filter).sort(sortInput).currentPage(currentPage).pageSize(pageSize);
        }
        ProductsQueryDefinition queryArgs = q -> q.items(GraphqlQueries.CHILD_PRODUCT_QUERY);
        String queryString = Operations.query(query -> query.products(searchArgs, queryArgs)).toString();
        GraphqlResponse<Query, Error> response = this.execute(queryString, storeView);
        Query query2 = (Query)response.getData();
        List products = query2.getProducts().getItems();
        LOGGER.debug("Fetched " + (products != null ? Integer.valueOf(products.size()) : null) + " products");
        return products;
    }

    @Override
    public CategoryProducts getCategoryProducts(Integer categoryId, Integer currentPage, Integer pageSize, String storeView) {
        try {
            ArrayKey key = this.toCategoryCacheKey(categoryId, currentPage, pageSize, storeView);
            Callable<Optional> loader = () -> this.getCategoryProductsImpl(categoryId, currentPage, pageSize, storeView);
            return ((Optional)this.categoryProductsCache.get((Object)key, loader)).orElse(null);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    Optional<CategoryProducts> getCategoryProductsImpl(Integer categoryId, Integer currentPage, Integer pageSize, String storeView) {
        LOGGER.debug("Trying to fetch products for category " + categoryId);
        QueryQuery.CategoryArgumentsDefinition argsDef = q -> q.id(categoryId);
        ProductAttributeSortInput sortInput = new ProductAttributeSortInput().setName(SortEnum.ASC);
        CategoryTreeQueryDefinition queryDef = q -> q.products(o -> o.sort(sortInput).currentPage(currentPage).pageSize(pageSize), p -> p.totalCount().items(GraphqlQueries.CHILD_PRODUCT_QUERY));
        String queryString = Operations.query(query -> query.category(argsDef, queryDef)).toString();
        GraphqlResponse<Query, Error> response = this.execute(queryString, storeView);
        Query query2 = (Query)response.getData();
        CategoryTree category = query2.getCategory();
        List products = category.getProducts().getItems();
        LOGGER.debug("Fetched " + products.size() + " products for category " + categoryId);
        return Optional.ofNullable(category.getProducts());
    }

    @Override
    public String getIdentifier() {
        return this.configuration.identifier();
    }

    private ArrayKey toProductCacheKey(String sku, String storeView) {
        return this.toCacheKey(sku, StringUtils.defaultString((String)storeView, (String)MAGENTO_DEFAULT_STORE));
    }

    private ArrayKey toCategoryCacheKey(Integer categoryId, Integer currentPage, Integer pageSize, String storeView) {
        return this.toCacheKey(categoryId, currentPage, pageSize, StringUtils.defaultString((String)storeView, (String)MAGENTO_DEFAULT_STORE));
    }

    private ArrayKey toCategoryDataCacheKey(String key, String storeView) {
        return this.toCacheKey(key, StringUtils.defaultString((String)storeView, (String)MAGENTO_DEFAULT_STORE));
    }

    private ArrayKey toCategoryDataCacheKey(Integer id, String storeView) {
        return this.toCacheKey(id, StringUtils.defaultString((String)storeView, (String)MAGENTO_DEFAULT_STORE));
    }

    private ArrayKey toCacheKey(Object ... parts) {
        return new ArrayKey(parts);
    }

    static class ArrayKey {
        Object[] parts;

        public ArrayKey(Object ... parts) {
            this.parts = parts;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArrayKey that = (ArrayKey)o;
            return Arrays.equals(this.parts, that.parts);
        }

        public int hashCode() {
            return Arrays.hashCode(this.parts);
        }
    }
}

