/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.graphql.magento;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.AttributeType;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@ObjectClassDefinition(name="CIF Catalog Magento GraphQL Configuration Factory")
public @interface GraphqlDataServiceConfiguration {
    public static final String CQ_CATALOG_IDENTIFIER = "cq:catalogIdentifier";
    public static final String CONNECTOR_ID_DEFAULT = "default";
    public static final int MAX_HTTP_CONNECTIONS_DEFAULT = 20;
    public static final boolean ACCEPT_SELF_SIGNED_CERTIFICATES = false;
    public static final int PRODUCT_CACHING_TIME_DEFAULT = 5;
    public static final int PRODUCT_CACHE_SIZE = 1000;
    public static final int CATEGORY_CACHE_SIZE = 100;
    public static final boolean PRODUCT_CACHING_ENABLED_DEFAULT = true;
    public static final boolean CATEGORY_CACHING_ENABLED_DEFAULT = true;
    public static final int CATEGORY_CACHING_TIME_DEFAULT = 60;
    public static final int CATALOG_PAGING_LIMIT = 50;

    @AttributeDefinition(name="Magento GraphQL Service Identifier", description="A unique identifier for this configuration, used in the JCR resource property cq:catalogIdentifier to identify the service. This MUST match the identifier of an already configured GraphQL client.", type=AttributeType.STRING, required=true)
    public String identifier() default "default";

    @AttributeDefinition(name="Enable/disable product data caching", description="Enables/disables the caching of products data in the connector", type=AttributeType.BOOLEAN)
    public boolean productCachingEnabled() default true;

    @AttributeDefinition(name="Product caching time in minutes", description="The caching time (in minutes) of products data in the connector", type=AttributeType.INTEGER)
    public int productCachingTimeMinutes() default 5;

    @AttributeDefinition(name="Product cache size (= number of products in the cache).", description="The size of the products cache, used when a single product is fetched", type=AttributeType.INTEGER)
    public int productCachingSize() default 1000;

    @AttributeDefinition(name="Category cache size (= number of categories in the cache)", description="The size of the categories cache, used when the category data as well as the products of a category are fetched", type=AttributeType.INTEGER)
    public int categoryCachingSize() default 100;

    @AttributeDefinition(name="Enable/disable category data caching", description="Enables/disables the caching of the category data in the connector", type=AttributeType.BOOLEAN)
    public boolean categoryCachingEnabled() default true;

    @AttributeDefinition(name="Category caching time in minutes", description="The caching time (in minutes) of category data in the connector", type=AttributeType.INTEGER)
    public int categoryCachingTimeMinutes() default 60;
}

