/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.graphql.core;

import com.adobe.cq.commerce.api.CommerceException;
import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.api.VariantFilter;
import com.adobe.cq.commerce.graphql.resource.SyntheticImageResource;
import com.adobe.cq.commerce.magento.graphql.ComplexTextValue;
import com.adobe.cq.commerce.magento.graphql.ConfigurableProduct;
import com.adobe.cq.commerce.magento.graphql.ConfigurableVariant;
import com.adobe.cq.commerce.magento.graphql.ProductInterface;
import com.adobe.cq.commerce.magento.graphql.SimpleProduct;
import com.day.cq.commons.ImageResource;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;

public class MagentoProduct
implements Product {
    private String path;
    private ProductInterface product;
    private SimpleProduct masterVariant;
    private String activeVariantSku;
    private ResourceResolver resourceResolver;

    public MagentoProduct(ResourceResolver resourceResolver, String path, ProductInterface product) {
        this(resourceResolver, path, product, null);
    }

    public MagentoProduct(ResourceResolver resourceResolver, String path, ProductInterface product, String activeVariantSku) {
        ConfigurableProduct cp;
        this.resourceResolver = resourceResolver;
        this.path = path;
        this.product = product;
        this.activeVariantSku = activeVariantSku;
        if (product instanceof ConfigurableProduct && (cp = (ConfigurableProduct)product).getVariants() != null && cp.getVariants().size() > 0) {
            if (activeVariantSku != null) {
                this.masterVariant = cp.getVariants().stream().map(cv -> cv.getProduct()).filter(sp -> activeVariantSku.equals(sp.getSku())).findFirst().orElse(null);
            }
            if (this.masterVariant == null) {
                this.masterVariant = ((ConfigurableVariant)cp.getVariants().get(0)).getProduct();
            }
        }
    }

    private String getVariantOrBaseProperty(Supplier<String> productProvider, Supplier<String> masterVariantProvider) {
        String masterVariantValue;
        String productValue = productProvider != null ? productProvider.get() : null;
        String string = masterVariantValue = masterVariantProvider != null ? masterVariantProvider.get() : null;
        if (this.activeVariantSku != null) {
            return StringUtils.isNotEmpty((String)masterVariantValue) ? masterVariantValue : productValue;
        }
        return StringUtils.isNotEmpty((String)productValue) ? productValue : masterVariantValue;
    }

    public String getPath() {
        return this.path;
    }

    public String getPagePath() {
        return null;
    }

    public String getSKU() {
        return this.getVariantOrBaseProperty(() -> ((ProductInterface)this.product).getSku(), this.masterVariant != null ? () -> ((SimpleProduct)this.masterVariant).getSku() : null);
    }

    public String getTitle() {
        return this.getTitle(null);
    }

    public String getTitle(String selectorString) {
        return this.getVariantOrBaseProperty(() -> ((ProductInterface)this.product).getName(), this.masterVariant != null ? () -> ((SimpleProduct)this.masterVariant).getName() : null);
    }

    public String getDescription() {
        return this.getDescription(null);
    }

    public String getDescription(String selectorString) {
        return this.getVariantOrBaseProperty(() -> {
            ComplexTextValue description = this.product.getDescription();
            return description == null ? null : description.getHtml();
        }, this.masterVariant != null ? () -> {
            ComplexTextValue description = this.masterVariant.getDescription();
            return description == null ? null : description.getHtml();
        } : null);
    }

    public String getThumbnailUrl() {
        return this.getVariantOrBaseProperty(() -> this.product.getThumbnail().getUrl(), this.masterVariant != null ? () -> this.masterVariant.getThumbnail().getUrl() : null);
    }

    public String getThumbnailUrl(int width) {
        return this.getThumbnailUrl();
    }

    public String getThumbnailUrl(String selectorString) {
        return this.getThumbnailUrl();
    }

    @Deprecated
    public ImageResource getThumbnail() {
        return null;
    }

    public Resource getAsset() {
        String url = this.getImageUrl();
        return new SyntheticResource(this.resourceResolver, url, "commerce/components/product/image");
    }

    public List<Resource> getAssets() {
        return Collections.singletonList(this.getAsset());
    }

    @Deprecated
    public String getImageUrl() {
        return this.getVariantOrBaseProperty(() -> this.product.getImage().getUrl(), this.masterVariant != null ? () -> this.masterVariant.getImage().getUrl() : null);
    }

    public ImageResource getImage() {
        String url = this.getImageUrl();
        return new SyntheticImageResource(this.resourceResolver, this.path + "/image", "commerce/components/product/image", url);
    }

    public List<ImageResource> getImages() {
        return Collections.singletonList(this.getImage());
    }

    public <T> T getProperty(String name, Class<T> type) {
        return this.getProperty(name, null, type);
    }

    private <T> T getProperty(String name, ProductInterface p) {
        Method[] methods;
        for (Method method : methods = p.getClass().getDeclaredMethods()) {
            String methodName = method.getName().toLowerCase();
            String getName = "get" + name.toLowerCase();
            String isName = "is" + name.toLowerCase();
            if (!methodName.equals(getName) && !methodName.equals(isName)) continue;
            try {
                return (T)method.invoke((Object)p, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public <T> T getProperty(String name, String selectorString, Class<T> type) {
        T masterVariantValue;
        T productValue = this.getProperty(name, this.product);
        T t = masterVariantValue = this.masterVariant != null ? (T)this.getProperty(name, (ProductInterface)this.masterVariant) : null;
        if (this.activeVariantSku != null) {
            return masterVariantValue != null ? masterVariantValue : (T)productValue;
        }
        return productValue != null ? productValue : masterVariantValue;
    }

    public Iterator<String> getVariantAxes() {
        return Collections.emptyIterator();
    }

    public boolean axisIsVariant(String s) {
        return false;
    }

    public Iterator<Product> getVariants() throws CommerceException {
        return this.getVariants(null);
    }

    public Iterator<Product> getVariants(VariantFilter variantFilter) throws CommerceException {
        ConfigurableProduct cp;
        if (this.product instanceof ConfigurableProduct && (cp = (ConfigurableProduct)this.product).getVariants() != null && cp.getVariants().size() > 0) {
            ArrayList<MagentoProduct> variants = new ArrayList<MagentoProduct>();
            for (ConfigurableVariant cv : cp.getVariants()) {
                String variantSku = cv.getProduct().getSku();
                String variantPath = this.path + "/" + variantSku;
                MagentoProduct variant = new MagentoProduct(this.resourceResolver, variantPath, this.product, variantSku);
                if (variantFilter != null && !variantFilter.includes((Product)variant)) continue;
                variants.add(variant);
            }
            return variants.iterator();
        }
        return Collections.emptyIterator();
    }

    public Product getBaseProduct() throws CommerceException {
        return this;
    }

    public Product getPIMProduct() throws CommerceException {
        return this;
    }

    @Deprecated
    public String getImagePath() {
        return null;
    }

    public static boolean isAProductOrVariant(Resource resource) {
        String commerceType = (String)resource.getValueMap().get("cq:commerceType", (Object)"");
        return commerceType.equals("product") || commerceType.equals("variant");
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> aClass) {
        return null;
    }
}

