/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.graphql.core;

import com.adobe.cq.commerce.api.Product;
import com.adobe.cq.commerce.api.conf.CommerceBasePathsService;
import com.adobe.cq.commerce.graphql.search.CatalogSearchSupport;
import com.adobe.granite.omnisearch.spi.core.OmniSearchHandler;
import com.adobe.granite.xss.XSSAPI;
import com.day.cq.commons.feed.StringResponseWrapper;
import com.day.cq.search.Predicate;
import com.day.cq.search.PredicateConverter;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.result.SearchResult;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import com.day.cq.wcm.core.contentfinder.Hit;
import com.day.cq.wcm.core.contentfinder.ViewHandler;
import com.day.cq.wcm.core.contentfinder.ViewQuery;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, name="GraphqlProductViewHandler", immediate=true, property={"sling.servlet.paths=/bin/wcm/contentfinder/cifproduct/view"})
public class GraphqlProductViewHandler
extends ViewHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphqlProductViewHandler.class);
    private static final String PROPERTY_STEP = "*/";
    private static final String PRODUCT_COMMERCE_TYPE = "product";
    private static final String TAGS_PROP = "tags";
    private static final String CQ_TAGS_PROP = "cq:tags";
    private static final String PAGE_EDITOR_PATH = "editor.html";
    private static final String REFERER_HEADER = "Referer";
    @Reference(target="(component.name=com.adobe.cq.commerce.impl.omnisearch.ProductsOmniSearchHandler)")
    OmniSearchHandler omniSearchHandler;
    @Reference
    private XSSAPI xssAPI;
    private TagManager tagManager;

    protected String generateHtmlOutput(Collection<Hit> hits, SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (request.getParameter("itemResourceType") == null) {
            return hits.toString();
        }
        StringResponseWrapper hitResponse = new StringResponseWrapper(response);
        RequestDispatcherOptions requestDispatcherOptions = new RequestDispatcherOptions(null);
        requestDispatcherOptions.setForceResourceType(request.getParameter("itemResourceType"));
        for (Hit hit : hits) {
            Resource resource = (Resource)hit.get("resource");
            if (resource == null) continue;
            request.setAttribute(Resource.class.getCanonicalName(), (Object)resource);
            RequestDispatcher dispatcher = request.getRequestDispatcher(resource, requestDispatcherOptions);
            dispatcher.include((ServletRequest)request, (ServletResponse)hitResponse);
            request.removeAttribute(Resource.class.getCanonicalName());
        }
        return hitResponse.getString();
    }

    private static Hit createHit(Product product, Resource resource, XSSAPI xssAPI) {
        Hit hit = new Hit();
        String path = product.getPath();
        String name = path.substring(path.lastIndexOf("/") + 1);
        String title = product.getTitle();
        if (title == null || title.length() == 0) {
            title = name;
        }
        hit.set("name", (Object)xssAPI.encodeForHTML(name));
        hit.set("path", (Object)path);
        hit.set("thumbnail", (Object)xssAPI.getValidHref(product.getThumbnailUrl(48)));
        hit.set("title", (Object)xssAPI.encodeForHTML(title));
        hit.set("sku", (Object)xssAPI.encodeForHTML(product.getSKU()));
        hit.set("excerpt", (Object)xssAPI.filterHTML(""));
        hit.set("resource", (Object)resource);
        return hit;
    }

    protected static String preserveWildcards(String queryString) {
        if (queryString != null) {
            queryString = queryString.replace("*", "%");
        }
        return queryString;
    }

    protected static String revertWildcards(String queryString) {
        if (queryString != null) {
            queryString = queryString.replace("%", "*");
        }
        return queryString;
    }

    private static void addProductConstraint(PredicateGroup gqlPredicateGroup) {
        Predicate predicate = new Predicate("property");
        predicate.set("property", "cq:commerceType");
        predicate.set("value", PRODUCT_COMMERCE_TYPE);
        predicate.set("operation", "equals");
        gqlPredicateGroup.add(predicate);
    }

    protected ViewQuery createQuery(SlingHttpServletRequest request, Session session, String queryString) throws RepositoryException {
        String refererHeader;
        String startPath;
        queryString = GraphqlProductViewHandler.preserveWildcards(queryString);
        PredicateGroup gqlPredicateGroup = PredicateConverter.createPredicatesFromGQL((String)queryString);
        ResourceResolver resolver = request.getResourceResolver();
        this.tagManager = (TagManager)resolver.adaptTo(TagManager.class);
        Set<String> predicateSet = this.customizePredicateGroup(gqlPredicateGroup);
        RequestPathInfo pathInfo = request.getRequestPathInfo();
        CommerceBasePathsService cbps = (CommerceBasePathsService)resolver.adaptTo(CommerceBasePathsService.class);
        String defaultStartPath = cbps.getProductsBasePath();
        String string = startPath = pathInfo.getSuffix() != null && pathInfo.getSuffix().startsWith(defaultStartPath) ? pathInfo.getSuffix() : defaultStartPath;
        if (!predicateSet.contains("path")) {
            gqlPredicateGroup.add(new Predicate("path").set("path", startPath));
        }
        if (StringUtils.isNotBlank((CharSequence)(refererHeader = request.getHeader(REFERER_HEADER))) && refererHeader.contains("editor.html/")) {
            String catalogPath;
            CatalogSearchSupport catalogSearch;
            String rootCategoryId;
            int p = refererHeader.lastIndexOf(PAGE_EDITOR_PATH);
            String pagePath = refererHeader.substring(p + PAGE_EDITOR_PATH.length());
            if (pagePath.endsWith(".html")) {
                pagePath = pagePath.substring(0, pagePath.length() - ".html".length());
            }
            if ((rootCategoryId = (catalogSearch = new CatalogSearchSupport(resolver)).findCategoryId(catalogPath = catalogSearch.findCatalogPath(pagePath))) != null) {
                gqlPredicateGroup.add(new Predicate("categoryId").set("categoryId", rootCategoryId));
                gqlPredicateGroup.add(new Predicate("categoryPath").set("categoryPath", catalogPath));
            }
        } else {
            LOGGER.warn("The path of the edited page cannot be determined");
        }
        gqlPredicateGroup.add(new Predicate("type").set("type", "nt:unstructured"));
        if (gqlPredicateGroup.get("limit") == null) {
            String limit = request.getParameter("limit");
            if (limit != null && !limit.equals("")) {
                int offset = Integer.parseInt(StringUtils.substringBefore((String)limit, (String)".."));
                int total = Integer.parseInt(StringUtils.substringAfter((String)limit, (String)".."));
                gqlPredicateGroup.set("limit", Long.toString(total - offset));
                gqlPredicateGroup.set("offset", Long.toString(offset));
            } else {
                gqlPredicateGroup.set("limit", Long.toString(20L));
            }
        }
        GraphqlProductViewHandler.addProductConstraint(gqlPredicateGroup);
        if (!predicateSet.contains("orderby")) {
            gqlPredicateGroup.add(new Predicate("orderby").set("orderby", "@jcr:lastModified").set("sort", "desc"));
        }
        return new GQLViewQuery(resolver, this.omniSearchHandler, this.xssAPI, gqlPredicateGroup);
    }

    private Set<String> customizePredicateGroup(PredicateGroup predicateGroup) {
        if (predicateGroup == null) {
            return new HashSet<String>();
        }
        HashSet<String> predicateSet = new HashSet<String>();
        for (int i = 0; i < predicateGroup.size(); ++i) {
            if (predicateGroup.get(i) instanceof PredicateGroup) {
                PredicateGroup optionalGrp = (PredicateGroup)predicateGroup.get(i);
                predicateSet.addAll(this.customizePredicateGroup(optionalGrp));
                predicateGroup.set(i, (Predicate)optionalGrp);
                continue;
            }
            if (!(predicateGroup.get(i) instanceof Predicate)) continue;
            Predicate predicate = predicateGroup.get(i);
            predicateSet.add(predicate.getType());
            this.modifyPredicate(predicateGroup, predicate, i);
        }
        return predicateSet;
    }

    private void modifyPredicate(PredicateGroup parentGroup, Predicate predicate, int index) {
        String fulltext;
        String property = predicate.get("property");
        if ("property".equals(predicate.getType())) {
            String value = predicate.get("value");
            if (property.equals(TAGS_PROP) || property.equals("tag")) {
                Tag tag;
                predicate.set("property", CQ_TAGS_PROP);
                parentGroup.set(index, predicate);
                if (this.tagManager != null && (tag = this.tagManager.resolve(value)) == null) {
                    Predicate tagSearchPredicate = new Predicate("tagsearch");
                    tagSearchPredicate.set("property", CQ_TAGS_PROP);
                    tagSearchPredicate.set("tagsearch", value);
                    parentGroup.set(index, tagSearchPredicate);
                }
            } else {
                int depth = StringUtils.countMatches((CharSequence)(property = GraphqlProductViewHandler.revertWildcards(property)), (CharSequence)PROPERTY_STEP);
                if (depth > 0) {
                    predicate.set("property", property.replace(PROPERTY_STEP, ""));
                    predicate.set("depth", String.valueOf(depth));
                    parentGroup.set(index, predicate);
                }
            }
        } else if ("fulltext".equals(predicate.getType()) && (fulltext = predicate.get("fulltext", "")) != null) {
            fulltext = GraphqlProductViewHandler.revertWildcards(fulltext);
            predicate.set("fulltext", fulltext);
            Predicate tagSearchPredicate = new Predicate("tagsearch");
            tagSearchPredicate.set("property", CQ_TAGS_PROP);
            tagSearchPredicate.set("tagsearch", fulltext);
            PredicateGroup optionalGrp = new PredicateGroup();
            optionalGrp.setAllRequired(false);
            optionalGrp.add(predicate);
            optionalGrp.add(tagSearchPredicate);
            parentGroup.set(index, (Predicate)optionalGrp);
        }
    }

    protected static class GQLViewQuery
    implements ViewQuery {
        protected final PredicateGroup predicateGroup;
        private final XSSAPI xssAPI;
        private final OmniSearchHandler omniSearchHandler;
        ResourceResolver resolver;

        public GQLViewQuery(ResourceResolver resolver, OmniSearchHandler omniSearchHandler, XSSAPI xssAPI, PredicateGroup predicateGroup) {
            this.omniSearchHandler = omniSearchHandler;
            this.resolver = resolver;
            this.xssAPI = xssAPI;
            this.predicateGroup = predicateGroup;
        }

        public Collection<Hit> execute() {
            ArrayList<Hit> hits = new ArrayList<Hit>();
            HashMap parameters = new HashMap(PredicateConverter.createMap((PredicateGroup)this.predicateGroup));
            SearchResult results = this.omniSearchHandler.getResults(this.resolver, parameters, (long)NumberUtils.toInt((String)this.predicateGroup.get("limit"), (int)0), (long)NumberUtils.toInt((String)this.predicateGroup.get("offset"), (int)20));
            Iterator resources = results.getResources();
            while (resources.hasNext()) {
                Product product;
                Resource resource = (Resource)resources.next();
                if (resource == null || (product = (Product)resource.adaptTo(Product.class)) == null) continue;
                hits.add(GraphqlProductViewHandler.createHit(product, resource, this.xssAPI));
            }
            return hits;
        }
    }
}

