/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.synthetic.impl.granite;

import com.adobe.acs.commons.workflow.synthetic.impl.SyntheticWorkflowData;
import com.adobe.acs.commons.workflow.synthetic.impl.SyntheticWorkflowRunnerImpl;
import com.adobe.acs.commons.workflow.synthetic.impl.granite.SyntheticRoute;
import com.adobe.acs.commons.workflow.synthetic.impl.granite.SyntheticWorkItem;
import com.adobe.acs.commons.workflow.synthetic.impl.granite.SyntheticWorkflow;
import com.adobe.acs.commons.workflow.synthetic.impl.granite.exceptions.SyntheticCompleteWorkflowException;
import com.adobe.acs.commons.workflow.synthetic.impl.granite.exceptions.SyntheticRestartWorkflowException;
import com.adobe.acs.commons.workflow.synthetic.impl.granite.exceptions.SyntheticTerminateWorkflowException;
import com.adobe.granite.workflow.WorkflowException;
import com.adobe.granite.workflow.WorkflowSession;
import com.adobe.granite.workflow.exec.Route;
import com.adobe.granite.workflow.exec.WorkItem;
import com.adobe.granite.workflow.exec.Workflow;
import com.adobe.granite.workflow.exec.WorkflowData;
import com.adobe.granite.workflow.model.WorkflowModel;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.jcr.Session;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyntheticWorkflowSession
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(SyntheticWorkflowSession.class);
    private static final String UNSUPPORTED_OPERATION_MESSAGE = "SYNTHETICWORKFLOW SESSION >> NO IMPLEMENTATION FOR ";
    private final Session session;
    private final SyntheticWorkflowRunnerImpl workflowService;
    private final List<Route> routes;
    private final List<Route> backRoutes;

    private SyntheticWorkflowSession(SyntheticWorkflowRunnerImpl workflowService, Session session) {
        this.workflowService = workflowService;
        this.session = session;
        this.routes = new ArrayList<Route>();
        this.routes.add(new SyntheticRoute(false));
        this.backRoutes = new ArrayList<Route>();
        this.backRoutes.add(new SyntheticRoute(true));
    }

    public static SyntheticWorkflowSession createSyntheticWorkflowSession(SyntheticWorkflowRunnerImpl workflowService, Session session) {
        return new SyntheticWorkflowSession(workflowService, session);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName;
        switch (methodName = method.getName()) {
            case "getModel": {
                return this.getModel(args);
            }
            case "terminateWorkflow": {
                this.terminateWorkflow((Workflow)args[0]);
                return new Object();
            }
            case "complete": {
                this.complete((WorkItem)args[0], (Route)args[1]);
                return new Object();
            }
            case "getRoutes": {
                return this.getRoutes();
            }
            case "getBackRoutes": {
                return this.getBackRoutes();
            }
            case "newWorkflowData": {
                return this.newWorkflowData((String)args[0], args[1]);
            }
            case "updateWorkflowData": {
                this.updateWorkflowData((Workflow)args[0], (WorkflowData)args[1]);
                return new Object();
            }
            case "isSuperuser": {
                return this.isSuperuser();
            }
            case "restartWorkflow": {
                this.restartWorkflow((Workflow)args[0]);
                return new Object();
            }
        }
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE + methodName);
    }

    public final void terminateWorkflow(Workflow workflow) throws WorkflowException {
        if (workflow instanceof SyntheticWorkflow) {
            throw new SyntheticTerminateWorkflowException("Synthetic workflow [ " + workflow.getId() + " ] terminated");
        }
        throw new UnsupportedOperationException("SYNTHETICWORKFLOW SESSION >> NO IMPLEMENTATION FOR terminateWorkflow that is not a SyntheticWorkflow");
    }

    public final void complete(WorkItem workItem, Route route) throws WorkflowException {
        if (workItem instanceof SyntheticWorkItem) {
            throw new SyntheticCompleteWorkflowException("Synthetic workflow [ " + workItem.getWorkflow().getId() + " : " + workItem.getId() + " ] completed");
        }
        throw new UnsupportedOperationException("SYNTHETICWORKFLOW SESSION >> NO IMPLEMENTATION FOR complete that does not contain a SyntheticWorkItem");
    }

    public final void restartWorkflow(Workflow workflow) throws WorkflowException {
        if (workflow instanceof SyntheticWorkflow) {
            throw new SyntheticRestartWorkflowException("Synthetic workflow [ " + workflow.getId() + " ] restarted");
        }
        throw new UnsupportedOperationException("SYNTHETICWORKFLOW SESSION >> NO IMPLEMENTATION FOR restartWorkflow that does not contain a SyntheticWorkflow");
    }

    public final boolean isSuperuser() {
        return true;
    }

    public final Object getModel(Object[] args) throws WorkflowException {
        if (args.length > 1) {
            throw new UnsupportedOperationException("SYNTHETICWORKFLOW SESSION >> NO IMPLEMENTATION FOR getModel with multiple arguments");
        }
        return this.getModel((String)args[0]);
    }

    private WorkflowModel getModel(String modelId) throws WorkflowException {
        try {
            WorkflowSession workflowSession = (WorkflowSession)this.workflowService.getResourceResolver(this.session).adaptTo(WorkflowSession.class);
            return workflowSession.getModel(modelId);
        }
        catch (LoginException e) {
            throw new WorkflowException("Could not obtain a Granite Workflow Session");
        }
    }

    public final List<Route> getRoutes() throws WorkflowException {
        log.debug("Synthetic Workflow does not support routes; Defaults to a single Synthetic Route");
        return Collections.unmodifiableList(this.routes);
    }

    public final List<Route> getBackRoutes() throws WorkflowException {
        log.debug("Synthetic Workflow does not back support routes; Defaults to a single Synthetic Route");
        return Collections.unmodifiableList(this.backRoutes);
    }

    public final WorkflowData newWorkflowData(String payloadType, Object payload) {
        return new SyntheticWorkflowData(payloadType, payload);
    }

    public final void updateWorkflowData(Workflow workflow, WorkflowData workflowData) {
        if (!(workflow instanceof SyntheticWorkflow)) {
            throw new UnsupportedOperationException("SYNTHETICWORKFLOW SESSION >> NO IMPLEMENTATION FOR updateWorkflowData that does not contain a granite SyntheticWorkflow");
        }
        SyntheticWorkflow syntheticWorkflow = (SyntheticWorkflow)workflow;
        syntheticWorkflow.setWorkflowData(workflowData);
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (ResourceResolver.class.equals(type)) {
            if (this.session != null) {
                try {
                    return (AdapterType)this.workflowService.getResourceResolver(this.session);
                }
                catch (LoginException e) {
                    log.error("Failed to adapt Synthetic Granite WorkflowSession to ResourceResolver", (Throwable)e);
                }
            }
        } else if (Session.class.equals(type)) {
            return (AdapterType)this.session;
        }
        return null;
    }
}

