/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.properties.shared.impl;

import com.adobe.acs.commons.wcm.properties.shared.SharedComponentProperties;
import com.adobe.acs.commons.wcm.properties.shared.impl.SharedPropertiesRequestCache;
import javax.script.Bindings;
import javax.servlet.ServletRequest;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.scripting.api.BindingsValuesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
public class SharedComponentPropertiesBindingsValuesProvider
implements BindingsValuesProvider {
    private static final Logger log = LoggerFactory.getLogger(SharedComponentPropertiesBindingsValuesProvider.class);
    @Reference(policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL_UNARY)
    SharedComponentProperties sharedComponentProperties;

    public void addBindings(Bindings bindings) {
        SlingHttpServletRequest request = (SlingHttpServletRequest)bindings.get("request");
        Resource resource = (Resource)bindings.get("resource");
        if (request != null && resource != null) {
            SharedPropertiesRequestCache cache = SharedPropertiesRequestCache.fromRequest((ServletRequest)request);
            if (this.sharedComponentProperties != null) {
                this.setSharedProperties(bindings, resource, cache);
            } else {
                log.debug("Shared Component Properties must be configured to enable this provider");
            }
        }
        this.setDefaultBindings(bindings, resource);
    }

    private void setSharedProperties(Bindings bindings, Resource resource, SharedPropertiesRequestCache cache) {
        String rootPagePath = this.sharedComponentProperties.getSharedPropertiesPagePath(resource);
        if (rootPagePath != null) {
            String sharedPropsPath;
            bindings.put("sharedPropertiesPagePath", (Object)rootPagePath);
            String globalPropsPath = this.sharedComponentProperties.getGlobalPropertiesPath(resource);
            if (globalPropsPath != null) {
                bindings.putAll(cache.getBindings(globalPropsPath, newBindings -> {
                    Resource globalPropsResource = resource.getResourceResolver().getResource(globalPropsPath);
                    if (globalPropsResource != null) {
                        newBindings.put("globalProperties", (Object)globalPropsResource.getValueMap());
                        newBindings.put("globalPropertiesResource", (Object)globalPropsResource);
                    }
                }));
            }
            if ((sharedPropsPath = this.sharedComponentProperties.getSharedPropertiesPath(resource)) != null) {
                bindings.putAll(cache.getBindings(sharedPropsPath, newBindings -> {
                    Resource sharedPropsResource = resource.getResourceResolver().getResource(sharedPropsPath);
                    if (sharedPropsResource != null) {
                        newBindings.put("sharedProperties", (Object)sharedPropsResource.getValueMap());
                        newBindings.put("sharedPropertiesResource", (Object)sharedPropsResource);
                    }
                }));
                bindings.put("sharedPropertiesPath", (Object)sharedPropsPath);
            }
            String mergedPropertiesPath = resource.getPath();
            bindings.putAll(cache.getBindings(mergedPropertiesPath, newBindings -> {
                ValueMap globalPropertyMap = (ValueMap)bindings.get("globalProperties");
                ValueMap sharedPropertyMap = (ValueMap)bindings.get("sharedProperties");
                newBindings.put("mergedProperties", (Object)this.sharedComponentProperties.mergeProperties(globalPropertyMap, sharedPropertyMap, resource));
            }));
            bindings.put("mergedPropertiesPath", (Object)resource.getPath());
        }
    }

    private void setDefaultBindings(Bindings bindings, Resource resource) {
        if (!bindings.containsKey("globalProperties")) {
            bindings.put("globalProperties", (Object)ValueMap.EMPTY);
        }
        if (!bindings.containsKey("sharedProperties")) {
            bindings.put("sharedProperties", (Object)ValueMap.EMPTY);
        }
        if (!bindings.containsKey("mergedProperties")) {
            bindings.put("mergedProperties", (Object)(resource == null ? ValueMap.EMPTY : resource.getValueMap()));
        }
    }

    protected void bindSharedComponentProperties(SharedComponentProperties sharedComponentProperties) {
        this.sharedComponentProperties = sharedComponentProperties;
    }

    protected void unbindSharedComponentProperties(SharedComponentProperties sharedComponentProperties) {
        if (this.sharedComponentProperties == sharedComponentProperties) {
            this.sharedComponentProperties = null;
        }
    }
}

