/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.version.impl;

import com.adobe.acs.commons.version.EvolutionEntry;
import com.adobe.acs.commons.version.impl.EvolutionConfig;
import com.adobe.acs.commons.version.impl.EvolutionPathUtil;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EvolutionEntryImpl
implements EvolutionEntry {
    private static final Logger log = LoggerFactory.getLogger(EvolutionEntryImpl.class);
    private static int MAX_CHARS = 200;
    static String V_ADDED = "added";
    static String V_CHANGED = "changed";
    static String V_REMOVED = "removed";
    static String V_ADDED_REMOVED = "added-removed";
    static String V_CHANGED_REMOVED = "changed-removed";
    private EvolutionEntry.EvolutionEntryType type;
    private String name;
    private Object value;
    private int depth;
    private String path;
    private Version version;
    private String relativePath;
    private Property property;
    private EvolutionConfig config;

    public EvolutionEntryImpl(Resource resource, Version version, EvolutionConfig config) {
        this.config = config;
        this.type = EvolutionEntry.EvolutionEntryType.RESOURCE;
        this.name = resource.getName();
        this.depth = EvolutionPathUtil.getDepthForPath(resource.getPath());
        this.path = resource.getParent().getName();
        this.version = version;
        this.value = null;
        this.relativePath = EvolutionPathUtil.getRelativeResourceName(resource.getPath());
    }

    public EvolutionEntryImpl(Property property, Version version, EvolutionConfig config) {
        try {
            this.config = config;
            this.property = property;
            this.type = EvolutionEntry.EvolutionEntryType.PROPERTY;
            this.name = property.getName();
            this.depth = EvolutionPathUtil.getDepthForPath(property.getPath());
            this.version = version;
            this.path = property.getParent().getName();
            this.value = EvolutionConfig.printProperty(property);
            this.relativePath = EvolutionPathUtil.getRelativePropertyName(property.getPath());
        }
        catch (Exception e) {
            log.error("Could not inititalize VersionEntry", (Throwable)e);
        }
    }

    @Override
    public boolean isResource() {
        return EvolutionEntry.EvolutionEntryType.RESOURCE == this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUniqueName() {
        return (this.name + this.path).replace(":", "_").replace("/", "_").replace("@", "_").replace("frozenNode", "node");
    }

    @Override
    public EvolutionEntry.EvolutionEntryType getType() {
        return this.type;
    }

    @Override
    public String getValueString() {
        return EvolutionConfig.printObject(this.value);
    }

    @Override
    public String getValueStringShort() {
        String tempValue = this.getValueString();
        if (tempValue.length() > MAX_CHARS) {
            return tempValue.substring(0, MAX_CHARS) + "...";
        }
        return tempValue;
    }

    @Override
    public int getDepth() {
        return this.depth - 1;
    }

    @Override
    public boolean isCurrent() {
        try {
            Version[] successors = this.version.getSuccessors();
            if (successors == null || successors.length == 0) {
                return true;
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String getStatus() {
        if (this.isChanged() && this.isWillBeRemoved()) {
            return V_CHANGED_REMOVED;
        }
        if (this.isAdded() && this.isWillBeRemoved()) {
            return V_ADDED_REMOVED;
        }
        if (this.isAdded()) {
            return V_ADDED;
        }
        if (this.isWillBeRemoved()) {
            return V_REMOVED;
        }
        if (this.isChanged()) {
            return V_CHANGED;
        }
        return "";
    }

    @Override
    public boolean isAdded() {
        try {
            if (this.isResource()) {
                Node node = this.version.getLinearPredecessor().getFrozenNode().getNode(this.relativePath);
                return node == null;
            }
            Property prop = this.version.getLinearPredecessor().getFrozenNode().getProperty(this.relativePath);
            return prop == null;
        }
        catch (Exception exception) {
            return true;
        }
    }

    @Override
    public boolean isWillBeRemoved() {
        try {
            if (this.isCurrent()) {
                return false;
            }
            if (this.isResource()) {
                Node node = this.version.getLinearSuccessor().getFrozenNode().getNode(this.relativePath);
                return node == null;
            }
            Property prop = this.version.getLinearSuccessor().getFrozenNode().getProperty(this.relativePath);
            return prop == null;
        }
        catch (Exception exception) {
            return true;
        }
    }

    @Override
    public boolean isChanged() {
        try {
            if (this.isResource()) {
                return false;
            }
            Property prop = this.version.getLinearPredecessor().getFrozenNode().getProperty(this.relativePath);
            String currentValue = EvolutionConfig.printProperty(prop);
            String oldValue = EvolutionConfig.printProperty(this.property);
            return !currentValue.equals(oldValue);
        }
        catch (Exception e) {
            log.error("Unable to check changed status", (Throwable)e);
            return false;
        }
    }
}

