/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.version.impl;

import com.adobe.acs.commons.version.EvolutionAnalyser;
import com.adobe.acs.commons.version.EvolutionContext;
import com.adobe.acs.commons.version.impl.EvolutionConfig;
import com.adobe.acs.commons.version.impl.EvolutionContextImpl;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Resource Evolution Analyser", description="Have a look at the evolution of a resource on a property/resource level.", metatype=true)
@Service
@Properties(value={@Property(label="Ignored property names", description="Property names (regex possible) listed here will be excluded from the version compare feature.", name="properties.ignore", value={"(.*/)?jcr:uuid", "(.*/)?(cq|jcr):lastModified", "(.*/)?(cq|jcr):lastModifiedBy", "(.*/)?jcr:frozenUuid", "(.*/)?jcr:primaryType", "(.*/)?jcr:frozenPrimaryType"}, cardinality=0x7FFFFFFF), @Property(label="Ignored resource names", description="Resource names (regex possible) listed here will be excluded from the version compare feature.", name="resources.ignore", value={""}, cardinality=0x7FFFFFFF)})
public class EvolutionAnalyserImpl
implements EvolutionAnalyser {
    private static final Logger log = LoggerFactory.getLogger(EvolutionAnalyserImpl.class);
    protected static final String PROPERTY_IGNORES = "properties.ignore";
    protected static final String RESOURCE_IGNORES = "resources.ignore";
    private String[] propertyIgnores;
    private String[] resourceIgnores;
    private EvolutionConfig evolutionConfig;

    @Override
    public EvolutionContext getEvolutionContext(Resource resource) {
        return new EvolutionContextImpl(resource, this.evolutionConfig);
    }

    @Activate
    protected void activate(Map<String, String> config) {
        this.propertyIgnores = PropertiesUtil.toStringArray((Object)config.get(PROPERTY_IGNORES), (String[])new String[]{""});
        this.resourceIgnores = PropertiesUtil.toStringArray((Object)config.get(RESOURCE_IGNORES), (String[])new String[]{""});
        this.evolutionConfig = new EvolutionConfig(this.propertyIgnores, this.resourceIgnores);
        log.debug("Ignored properties: {}", (Object[])this.propertyIgnores);
        log.debug("Ignored resources: {}", (Object[])this.resourceIgnores);
    }
}

