/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util.visitors;

import com.adobe.acs.commons.util.visitors.ResourceRunnable;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sling.api.resource.AbstractResourceVisitor;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentVisitor<T extends ResourceRunnable>
extends AbstractResourceVisitor {
    private static final Logger log = LoggerFactory.getLogger(ContentVisitor.class);
    private static final String[] DEFAULT_CONTAINER_TYPES = new String[]{"sling:Folder", "sling:OrderedFolder", "nt:folder"};
    private static final String[] DEFAULT_CONTENT_TYPES = new String[]{"cq:Page", "dam:Asset", "cq:Tag"};
    private final T runnable;
    private final String[] contentTypes;
    private final String[] containerTypes;

    public ContentVisitor(T runnable) {
        this.runnable = runnable;
        this.containerTypes = DEFAULT_CONTAINER_TYPES;
        this.contentTypes = DEFAULT_CONTENT_TYPES;
    }

    public ContentVisitor(T runnable, String[] containerTypes, String[] contentTypes) {
        this.runnable = runnable;
        this.containerTypes = Arrays.copyOf(containerTypes, containerTypes.length);
        this.contentTypes = Arrays.copyOf(contentTypes, contentTypes.length);
    }

    public void accept(Resource resource) {
        String primaryType;
        if (resource != null && (ArrayUtils.contains((Object[])this.containerTypes, (Object)(primaryType = (String)resource.getValueMap().get("jcr:primaryType", String.class))) || ArrayUtils.contains((Object[])this.contentTypes, (Object)primaryType))) {
            super.accept(resource);
        }
    }

    protected void visit(Resource resource) {
        try {
            String primaryType = (String)resource.getValueMap().get("jcr:primaryType", String.class);
            if (ArrayUtils.contains((Object[])this.contentTypes, (Object)primaryType)) {
                this.runnable.run(resource);
            }
        }
        catch (Exception e) {
            log.error("An error occurred while visiting resource [ {} ]", (Object)resource.getPath(), (Object)e);
        }
    }
}

