/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.sorter;

import com.adobe.acs.commons.sorter.NodeSorter;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.servlets.post.PostOperation;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"sling.post.operation=acs-commons:sortNodes"})
public class SortNodesOperation
implements PostOperation {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String OPERATION_SORT = "acs-commons:sortNodes";
    public static final String RP_SORTER_NAME = ":sorterName";
    public static final String DEFAULT_SORTER_NAME = "byName";
    private final Map<String, NodeSorter> nodeSorters = Collections.synchronizedMap(new LinkedHashMap());

    @Reference(service=NodeSorter.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void bindNodeSorter(NodeSorter sorter, Map<String, Object> properties) {
        if (sorter != null) {
            String sorterName = sorter.getName();
            log.debug("registering node sorter: {} -> {}", (Object)sorterName, (Object)sorter.getClass().getName());
            this.nodeSorters.put(sorterName, sorter);
        }
    }

    protected void unbindNodeSorter(NodeSorter sorter, Map<String, Object> properties) {
        String sorterName = sorter.getName();
        log.debug("un-registering node sorter: {} -> {}", (Object)sorterName, (Object)sorter.getClass().getName());
        this.nodeSorters.remove(sorterName);
    }

    public void run(SlingHttpServletRequest slingRequest, PostResponse response, SlingPostProcessor[] processors) {
        try {
            Node targetNode = (Node)slingRequest.getResource().adaptTo(Node.class);
            if (targetNode == null) {
                response.setStatus(404, "Missing target node to sort: " + slingRequest.getResource().getPath());
                return;
            }
            response.setPath(targetNode.getPath());
            response.setLocation(targetNode.getPath());
            if (targetNode.getParent() != null) {
                response.setParentLocation(targetNode.getParent().getPath());
            }
            long t0 = System.currentTimeMillis();
            Comparator<Node> comparator = this.getNodeSorter(slingRequest);
            List<Node> children = this.getSortedNodes(targetNode, comparator);
            Node prev = null;
            for (int i = 0; i < children.size(); ++i) {
                Node n = children.get(children.size() - 1 - i);
                if (prev != null) {
                    log.trace("orderBefore: {}, {}", (Object)n.getName(), (Object)prev.getName());
                    targetNode.orderBefore(n.getName(), prev.getName());
                }
                response.onChange("ordered", new String[]{n.getPath(), prev == null ? "" : prev.getName()});
                prev = n;
            }
            targetNode.getSession().save();
            response.setTitle("Content sorted " + response.getPath());
            log.info("{} nodes sorted in {} ms", (Object)children.size(), (Object)(System.currentTimeMillis() - t0));
        }
        catch (IllegalArgumentException | RepositoryException e) {
            response.setError(e);
        }
    }

    List<Node> getSortedNodes(Node node, Comparator<Node> comparator) throws RepositoryException {
        ArrayList<Node> children = new ArrayList<Node>();
        NodeIterator it = node.getNodes();
        while (it.hasNext()) {
            Node child = it.nextNode();
            children.add(child);
        }
        children.sort(comparator);
        return children;
    }

    Comparator<Node> getNodeSorter(SlingHttpServletRequest slingRequest) {
        NodeSorter sorter;
        String sorterId = slingRequest.getParameter(RP_SORTER_NAME);
        if (sorterId == null) {
            sorterId = DEFAULT_SORTER_NAME;
        }
        if ((sorter = this.nodeSorters.get(sorterId)) == null) {
            String msg = "NodeSorter was not found: " + sorterId + ". Available sorters are: " + this.nodeSorters.keySet().toString();
            throw new IllegalArgumentException(msg);
        }
        return sorter.createComparator((HttpServletRequest)slingRequest);
    }
}

