/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.rewriter.impl;

import com.adobe.acs.commons.ccvar.PropertyAggregatorService;
import com.adobe.acs.commons.ccvar.PropertyConfigService;
import com.adobe.acs.commons.ccvar.util.ContentVariableReplacementUtil;
import com.adobe.acs.commons.rewriter.ContentHandlerBasedTransformer;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.rewriter.ProcessingComponentConfiguration;
import org.apache.sling.rewriter.ProcessingContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ContentVariableTransformer
extends ContentHandlerBasedTransformer {
    private Map<String, Object> contentVariableReplacements;
    private PropertyAggregatorService aggregatorService;
    private PropertyConfigService propertyConfigService;

    public ContentVariableTransformer() {
    }

    public ContentVariableTransformer(PropertyAggregatorService propertyAggregatorService, PropertyConfigService propertyConfigService) {
        this.aggregatorService = propertyAggregatorService;
        this.propertyConfigService = propertyConfigService;
    }

    @Override
    public void init(ProcessingContext processingContext, ProcessingComponentConfiguration processingComponentConfiguration) throws IOException {
        SlingHttpServletRequest request = processingContext.getRequest();
        this.contentVariableReplacements = this.aggregatorService.getProperties(request);
    }

    @Override
    public void startElement(String uri, String localName, String quaName, Attributes atts) throws SAXException {
        if (this.shouldRun()) {
            AttributesImpl newAttrs = new AttributesImpl(atts);
            for (int i = 0; i < newAttrs.getLength(); ++i) {
                String currentAttribute = newAttrs.getValue(i);
                if (StringUtils.isBlank((CharSequence)currentAttribute)) continue;
                List<String> keys = ContentVariableReplacementUtil.getKeys(currentAttribute);
                for (String key : keys) {
                    if (!ContentVariableReplacementUtil.hasKey(this.contentVariableReplacements, key)) continue;
                    String replaceValue = (String)ContentVariableReplacementUtil.getValue(this.contentVariableReplacements, key);
                    String newAttrValue = ContentVariableReplacementUtil.doReplacement(currentAttribute, key, replaceValue, this.propertyConfigService.getAction(key));
                    newAttrs.setValue(i, newAttrValue);
                }
            }
            this.getContentHandler().startElement(uri, localName, quaName, newAttrs);
        } else {
            this.getContentHandler().startElement(uri, localName, quaName, atts);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String currentString = new String(ch, start, length);
        if (this.shouldRun()) {
            List<String> keys = ContentVariableReplacementUtil.getKeys(currentString);
            for (String key : keys) {
                if (!ContentVariableReplacementUtil.hasKey(this.contentVariableReplacements, key)) continue;
                String placeholderReplacement = String.valueOf(ContentVariableReplacementUtil.getValue(this.contentVariableReplacements, key));
                currentString = ContentVariableReplacementUtil.doReplacement(currentString, key, placeholderReplacement, this.propertyConfigService.getAction(key));
            }
        }
        this.getContentHandler().characters(currentString.toCharArray(), 0, currentString.length());
    }

    private boolean shouldRun() {
        return this.aggregatorService != null && this.contentVariableReplacements != null && this.contentVariableReplacements.size() > 0;
    }
}

