/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.reports.models;

import com.adobe.acs.commons.reports.api.ReportCellCSVExporter;
import com.adobe.acs.commons.reports.internal.ExporterUtil;
import com.adobe.acs.commons.reports.internal.PredictedTagsUtil;
import com.adobe.acs.commons.reports.models.PredictedTag;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;

@Model(adaptables={Resource.class})
public class PredictedTagReportCellCSVExporter
implements ReportCellCSVExporter {
    public static final String CONFIDENCE_FORMAT_STRING = "%.4f";
    public static final String EMPTY_STRING = "";
    public static final String CONFIDENCE_BRACKET_OPEN = "[";
    public static final String CONFIDENCE_BRACKET_CLOSE = "]";
    public static final String VALUE_SEPARATOR = ";";
    public static final String SPACE_SEPARATOR = " ";
    @Inject
    private String property;
    @Inject
    @Optional
    private Double lowerConfidenceThreshold;
    @Inject
    @Optional
    private boolean confidenceShown;
    private PredictedTagsUtil predictedTagsUtil = new PredictedTagsUtil();

    @Override
    public String getValue(Object result) {
        Resource resource = (Resource)result;
        String relativePropertyPath = ExporterUtil.relativizePath(this.property);
        List<PredictedTag> predictedTags = this.predictedTagsUtil.getPredictedTags(resource, relativePropertyPath, this.lowerConfidenceThreshold);
        if (CollectionUtils.isEmpty(predictedTags)) {
            return EMPTY_STRING;
        }
        ArrayList<String> predictedTagRenderedValue = new ArrayList<String>();
        for (PredictedTag predictedTag : predictedTags) {
            predictedTagRenderedValue.add(this.asCellCSVValue(predictedTag));
        }
        return StringUtils.join(predictedTagRenderedValue, (String)VALUE_SEPARATOR);
    }

    public String asCellCSVValue(PredictedTag predictedTag) {
        if (predictedTag == null) {
            return EMPTY_STRING;
        }
        StringBuilder result = new StringBuilder(predictedTag.getName());
        if (this.confidenceShown) {
            result.append(SPACE_SEPARATOR);
            result.append(CONFIDENCE_BRACKET_OPEN);
            result.append(String.format(CONFIDENCE_FORMAT_STRING, predictedTag.getConfidence()));
            result.append(CONFIDENCE_BRACKET_CLOSE);
        }
        return result.toString();
    }
}

