/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.redirects.models;

import com.adobe.acs.commons.redirects.filter.RedirectFilterMBean;
import com.adobe.acs.commons.redirects.models.RedirectConfiguration;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.InjectionStrategy;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
public class Configurations {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @SlingObject
    private SlingHttpServletRequest request;
    @OSGiService(injectionStrategy=InjectionStrategy.OPTIONAL)
    private RedirectFilterMBean redirectFilter;
    private static final String REDIRECTS_RESOURCE_TYPE = "acs-commons/components/utilities/manage-redirects/redirects";

    public Collection<RedirectConfiguration> getConfigurations() {
        String configName;
        String sql = "SELECT * FROM [nt:unstructured] AS s WHERE ISDESCENDANTNODE([/conf]) AND s.[sling:resourceType]='acs-commons/components/utilities/manage-redirects/redirects'";
        log.debug(sql);
        Iterator it = this.request.getResourceResolver().findResources(sql, "JCR-SQL2");
        ArrayList<RedirectConfiguration> lst = new ArrayList<RedirectConfiguration>();
        String bucketName = this.redirectFilter == null ? "settings" : this.redirectFilter.getBucket();
        String string = configName = this.redirectFilter == null ? "redirects" : this.redirectFilter.getConfigName();
        while (it.hasNext()) {
            Resource resource = (Resource)it.next();
            String storageSuffix = bucketName + "/" + configName;
            RedirectConfiguration cfg = new RedirectConfiguration(resource, storageSuffix);
            lst.add(cfg);
        }
        lst.sort(Comparator.comparing(RedirectConfiguration::getName));
        return lst;
    }
}

