/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.oak.sql2scorer.impl.servlets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;

@Component(property={"sling.servlet.resourceTypes=acs-commons/components/utilities/sql2scorer", "sling.servlet.methods=POST", "sling.servlet.selectors=sql2scorer", "sling.servlet.extensions=json"}, service={Servlet.class})
public class ExplainScoreServlet
extends SlingAllMethodsServlet {
    static final String RT_SQL2SCORER = "acs-commons/components/utilities/sql2scorer";
    static final String P_STATEMENT = "statement";
    static final String P_LIMIT = "limit";
    static final String P_OFFSET = "offset";
    static final String KEY_STMT = "stmt";
    static final String KEY_PLAN = "plan";
    static final String KEY_COLS = "cols";
    static final String KEY_ROWS = "rows";
    static final String KEY_ERROR = "error";

    protected void doPost(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json;charset=utf-8");
        long limit = Optional.ofNullable(request.getParameter(P_LIMIT)).map(Long::valueOf).orElse(10L);
        long offset = Optional.ofNullable(request.getParameter(P_OFFSET)).map(Long::valueOf).orElse(0L);
        String rawStatement = request.getParameter(P_STATEMENT);
        if (rawStatement == null) {
            JsonObject obj = new JsonObject();
            obj.addProperty(KEY_ERROR, "please submit a valid JCR-SQL2 query in the `statement` parameter.");
            response.getWriter().write(obj.toString());
            return;
        }
        try {
            Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
            if (session == null || !session.isLive()) {
                throw new RepositoryException("failed to get a live JCR session from the request");
            }
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query rawQuery = qm.createQuery(rawStatement, "JCR-SQL2");
            rawQuery.setLimit(1L);
            rawQuery.execute();
            String statement = rawStatement.replaceFirst("(?i)SELECT", "SELECT [oak:scoreExplanation],");
            Query query = qm.createQuery(statement, "JCR-SQL2");
            query.setLimit(limit);
            query.setOffset(offset);
            Gson json = new GsonBuilder().registerTypeHierarchyAdapter(Query.class, (Object)new QueryExecutingTypeAdapter(qm)).create();
            response.getWriter().write(json.toJson((Object)query));
        }
        catch (InvalidQueryException e) {
            JsonObject obj = new JsonObject();
            obj.addProperty(KEY_ERROR, "please submit a valid JCR-SQL2 query in the `statement` parameter: " + e.getMessage());
            response.getWriter().write(obj.toString());
        }
        catch (RepositoryException e) {
            JsonObject obj = new JsonObject();
            obj.addProperty(KEY_ERROR, e.getMessage());
            response.getWriter().write(obj.toString());
        }
    }

    class QueryExecutingTypeAdapter
    extends TypeAdapter<Query> {
        final QueryManager qm;

        QueryExecutingTypeAdapter(QueryManager qm) {
            this.qm = qm;
        }

        public void write(JsonWriter jsonWriter, Query query) throws IOException {
            try {
                QueryResult queryResult = query.execute();
                Query explainQuery = this.qm.createQuery("explain " + query.getStatement(), "JCR-SQL2");
                QueryResult explainResult = explainQuery.execute();
                Optional<Row> planRow = Optional.ofNullable(explainResult.getRows()).filter(Iterator::hasNext).map(RowIterator::nextRow);
                jsonWriter.beginObject();
                jsonWriter.name(ExplainScoreServlet.KEY_STMT).value(query.getStatement());
                if (planRow.isPresent()) {
                    jsonWriter.name(ExplainScoreServlet.KEY_PLAN).value(planRow.get().getValue(ExplainScoreServlet.KEY_PLAN).getString());
                }
                jsonWriter.name(ExplainScoreServlet.KEY_COLS);
                jsonWriter.beginArray();
                for (String column : queryResult.getColumnNames()) {
                    jsonWriter.value(column);
                }
                jsonWriter.endArray();
                jsonWriter.name(ExplainScoreServlet.KEY_ROWS);
                jsonWriter.beginArray();
                RowIterator rowIt = queryResult.getRows();
                while (rowIt.hasNext()) {
                    Row row = rowIt.nextRow();
                    jsonWriter.beginArray();
                    for (Value value : row.getValues()) {
                        this.writeValue(jsonWriter, value);
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endArray();
                jsonWriter.endObject();
            }
            catch (RepositoryException e) {
                throw new IOException(e);
            }
        }

        public Query read(JsonReader jsonReader) {
            throw new UnsupportedOperationException("not implemented");
        }

        void writeValue(JsonWriter writer, Value v) throws IOException, RepositoryException {
            if (v == null) {
                writer.nullValue();
            } else {
                switch (v.getType()) {
                    case 2: {
                        writer.value("(binary value)");
                        break;
                    }
                    case 6: {
                        writer.value(v.getBoolean());
                        break;
                    }
                    case 5: {
                        writer.value(ISO8601.format((Calendar)v.getDate()));
                        break;
                    }
                    case 3: {
                        writer.value(v.getLong());
                        break;
                    }
                    case 4: 
                    case 12: {
                        writer.value(v.getDecimal().toPlainString());
                        break;
                    }
                    default: {
                        writer.value(v.getString());
                    }
                }
            }
        }
    }
}

