/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.mcp.model;

import com.adobe.acs.commons.mcp.model.FieldFormat;
import java.lang.reflect.Field;
import java.util.function.Function;

public enum ValueFormat {
    plain,
    storageSize("_short", ValueFormat::getHumanSize);

    int columnCount = 1;
    String suffix = "";
    Function<Object, Object> altFunction;

    private ValueFormat() {
    }

    private ValueFormat(String alternate, Function<Object, Object> altFunc) {
        this.columnCount = 2;
        this.suffix = alternate;
        this.altFunction = altFunc;
    }

    public static ValueFormat forField(Enum anEnum) {
        try {
            Field field = anEnum.getDeclaringClass().getField(anEnum.name());
            if (!field.isAnnotationPresent(FieldFormat.class)) {
                return plain;
            }
            FieldFormat rf = field.getAnnotation(FieldFormat.class);
            return rf.value();
        }
        catch (IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            return plain;
        }
    }

    public Object getAlternateValue(Object val) {
        return this.altFunction.apply(val);
    }

    public static String getHumanSize(Object val) {
        if (val == null) {
            return null;
        }
        Long bytes = val instanceof Long ? (Long)val : Long.parseLong(String.valueOf(val));
        return ValueFormat.humanReadableByteCount(bytes, false);
    }

    private static strictfp String humanReadableByteCount(long bytes, boolean si) {
        long absBytes;
        int unit = si ? 1000 : 1024;
        long l = absBytes = bytes == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(bytes);
        if (absBytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(absBytes) / Math.log(unit));
        long th = (long)(Math.pow(unit, exp) * ((double)unit - 0.05));
        if (exp < 6 && absBytes >= th - (long)((th & 0xFFFL) == 3328L ? 52 : 0)) {
            ++exp;
        }
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        if (exp > 4) {
            bytes /= (long)unit;
            --exp;
        }
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }
}

