/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.marketo.impl;

import com.adobe.acs.commons.marketo.FormValue;
import com.adobe.acs.commons.marketo.MarketoForm;
import com.day.cq.commons.Externalizer;
import com.day.cq.wcm.api.WCMMode;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.DefaultInjectionStrategy;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Via;
import org.apache.sling.models.annotations.injectorspecific.ChildResource;
import org.apache.sling.models.annotations.injectorspecific.ValueMapValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class}, defaultInjectionStrategy=DefaultInjectionStrategy.OPTIONAL, adapters={MarketoForm.class})
public class MarketoFormImpl
implements MarketoForm {
    private static final Logger log = LoggerFactory.getLogger(MarketoFormImpl.class);
    @ValueMapValue
    @Via(value="resource")
    private String formId;
    @ChildResource
    @Via(value="resource")
    private List<FormValue> hidden;
    private SlingHttpServletRequest request;
    @ValueMapValue
    @Via(value="resource")
    private String script;
    @ValueMapValue
    @Via(value="resource")
    private String successUrl;
    @ChildResource
    @Via(value="resource")
    private List<FormValue> values;

    public MarketoFormImpl(SlingHttpServletRequest request) {
        this.request = request;
    }

    @Override
    public String getFormId() {
        return this.formId;
    }

    @Override
    public String getHidden() {
        if (this.hidden == null || this.hidden.isEmpty()) {
            return null;
        }
        String assignments = this.hidden.stream().map(v -> this.toJavaScript((FormValue)v, "hidden")).collect(Collectors.joining());
        return "var hidden = {};\n" + assignments + "form.addHiddenFields(hidden);\n";
    }

    private String toJavaScript(FormValue value, String variable) {
        String key = StringEscapeUtils.escapeJavaScript((String)value.getName());
        String val = StringEscapeUtils.escapeJavaScript((String)value.getValue());
        if ("static".equals(value.getSource())) {
            return String.format("%s[\"%s\"]=\"%s\";%n", variable, key, val);
        }
        if ("contextHub".equals(value.getSource())) {
            return String.format("%s[\"%s\"]=ContextHub.getItem(\"%s\");%n", variable, key, val);
        }
        if ("jsVariable".equals(value.getSource())) {
            return String.format("%s[\"%s\"]=%s;%n", variable, key, value.getValue());
        }
        return String.format("%s[\"%s\"]=\"%s\";%n", variable, key, StringEscapeUtils.escapeJavaScript((String)this.request.getParameter(value.getValue())));
    }

    @Override
    public String getScript() {
        return this.script;
    }

    @Override
    public String getSuccessUrl() {
        if (StringUtils.isBlank((CharSequence)this.successUrl)) {
            return null;
        }
        String fullUrl = this.successUrl;
        Externalizer externalizer = (Externalizer)this.request.getResourceResolver().adaptTo(Externalizer.class);
        if (this.successUrl.startsWith("/") && externalizer != null) {
            fullUrl = externalizer.relativeLink(this.request, this.successUrl);
            log.debug("Externalized {} to {}", (Object)this.successUrl, (Object)fullUrl);
        }
        if (!this.successUrl.contains(".")) {
            fullUrl = fullUrl + ".html";
        }
        log.debug("Final URL: {}", (Object)fullUrl);
        return "form.onSuccess(function(values, followUpUrl) {\nlocation.href = \"" + StringEscapeUtils.escapeJavaScript((String)fullUrl) + "\";\nreturn false;\n});";
    }

    @Override
    public String getValues() {
        if (this.values == null || this.values.isEmpty()) {
            return null;
        }
        String assignments = this.values.stream().map(v -> this.toJavaScript((FormValue)v, "values")).collect(Collectors.joining());
        return "var values = {};\n" + assignments + "form.vals(values);\n";
    }

    @Override
    public boolean isEdit() {
        return WCMMode.fromRequest((ServletRequest)this.request) == WCMMode.EDIT;
    }
}

