/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.logging.impl;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.net.SyslogAppenderBase;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@Component(metatype=true, configurationFactory=true, policy=ConfigurationPolicy.REQUIRE, label="ACS AEM Commons - Syslog Appender", description="Logback appender to send messages using Syslog")
@Properties(value={@Property(name="webconsole.configurationFactory.nameHint", value={"Host: {host}, for loggers [{loggers}]"})})
public final class SyslogAppender {
    private static final String ROOT = "ROOT";
    private static final int DEFAULT_PORT = -1;
    private static final String DEFAULT_SUFFIX_PATTERN = "[%thread] %-5level %logger{36} - %msg%n";
    private static final String DEFAULT_FACILITY = "USER";
    private static final boolean DEFAULT_THROWABLE_EXCLUDED = false;
    @Property(label="Host", description="Host of Syslog server")
    static final String PROP_HOST = "host";
    @Property(label="Logger Names", description="List of logger categories (ROOT for all)", unbounded=PropertyUnbounded.ARRAY, value={"ROOT"})
    static final String PROP_LOGGERS = "loggers";
    @Property(label="Port", description="Port of Syslog server", intValue={-1})
    static final String PROP_PORT = "port";
    @Property(label="Suffix Pattern", description="Logback Pattern defining the message format.", value={"[%thread] %-5level %logger{36} - %msg%n"})
    static final String PROP_SUFFIX_PATTERN = "suffix.pattern";
    @Property(label="Syslog Facility", value={"USER"}, propertyPrivate=true, description="The Syslog Facility is meant to identify the source of a message, separately from any context included in the Suffix Pattern. The facility option must be set to one of the strings KERN, USER, MAIL, DAEMON, AUTH, SYSLOG, LPR, NEWS, UUCP, CRON, AUTHPRIV, FTP, NTP, AUDIT, ALERT, CLOCK, LOCAL0, LOCAL1, LOCAL2, LOCAL3, LOCAL4, LOCAL5, LOCAL6, LOCAL7. Case is not important.")
    static final String PROP_FACILITY = "facility";
    @Property(label="Stack Trace Pattern", description="Logback Pattern for customizing the string appearing just before each stack trace line. The default value for this property is a single tab character.")
    static final String PROP_STACK_TRACE_PATTERN = "stack.trace.pattern";
    @Property(label="Exclude Throwables", description="Set to true to cause stack trace data associated with a Throwable to be omitted. By default, this is set to false so that stack trace data is sent to the syslog server.", boolValue={false})
    static final String PROP_THROWABLE_EXCLUDED = "throwable.excluded";
    private ch.qos.logback.classic.net.SyslogAppender appender;
    private ServiceRegistration appenderRegistration;

    @Activate
    protected void activate(BundleContext ctx, Map<String, Object> properties) {
        this.appender = SyslogAppender.constructAppender(properties);
        String[] loggers = PropertiesUtil.toStringArray((Object)properties.get(PROP_LOGGERS), (String[])new String[]{ROOT});
        Hashtable<String, String[]> props = new Hashtable<String, String[]>();
        ((Dictionary)props).put(PROP_LOGGERS, loggers);
        this.appenderRegistration = ctx.registerService(Appender.class.getName(), (Object)this.appender, props);
    }

    static ch.qos.logback.classic.net.SyslogAppender constructAppender(Map<String, Object> properties) {
        String suffixPattern = PropertiesUtil.toString((Object)properties.get(PROP_SUFFIX_PATTERN), (String)DEFAULT_SUFFIX_PATTERN);
        int port = PropertiesUtil.toInteger((Object)properties.get(PROP_PORT), (int)-1);
        String host = PropertiesUtil.toString((Object)properties.get(PROP_HOST), null);
        String facility = PropertiesUtil.toString((Object)properties.get(PROP_FACILITY), (String)DEFAULT_FACILITY);
        String stackTracePattern = PropertiesUtil.toString((Object)properties.get(PROP_STACK_TRACE_PATTERN), null);
        boolean throwableExcluded = PropertiesUtil.toBoolean((Object)properties.get(PROP_THROWABLE_EXCLUDED), (boolean)false);
        if (StringUtils.isEmpty((String)host) || port == -1) {
            throw new IllegalArgumentException("Syslog Appender not configured correctly. Both host and port need to be provided.");
        }
        SyslogAppenderBase.facilityStringToint((String)facility);
        ch.qos.logback.classic.net.SyslogAppender appender = new ch.qos.logback.classic.net.SyslogAppender();
        appender.setSyslogHost(host);
        appender.setPort(port);
        appender.setFacility(facility);
        appender.setSuffixPattern(suffixPattern);
        if (StringUtils.isNotEmpty((String)stackTracePattern)) {
            appender.setStackTracePattern(stackTracePattern);
        }
        appender.setThrowableExcluded(throwableExcluded);
        return appender;
    }

    @Deactivate
    protected void deactivate() {
        if (this.appender != null) {
            if (this.appender.isStarted()) {
                this.appender.stop();
            }
            this.appender = null;
        }
        if (this.appenderRegistration != null) {
            this.appenderRegistration.unregister();
            this.appenderRegistration = null;
        }
    }
}

