/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.indesign.dynamicdeckdynamo.servlets.impl;

import com.adobe.acs.commons.indesign.dynamicdeckdynamo.exception.DynamicDeckDynamoException;
import com.adobe.acs.commons.indesign.dynamicdeckdynamo.models.DynamicDeckInitiatorPageModel;
import com.adobe.acs.commons.indesign.dynamicdeckdynamo.services.DynamicDeckService;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.resourceTypes=sling/servlet/default", "sling.servlet.methods=POST", "sling.servlet.extensions=json", "sling.servlet.selectors=triggerDeckDynamo"})
public class TriggerDeckDynamoServlet
extends SlingAllMethodsServlet {
    public static final String SELECTOR_TRIGGER_DECK_DYNAMO = "triggerDeckDynamo";
    private static final Logger LOGGER = LoggerFactory.getLogger(TriggerDeckDynamoServlet.class);
    private static final long serialVersionUID = 2151877091112583303L;
    private static final String MESSAGE = "message";
    @Reference
    private transient DynamicDeckService dynamicDeckService;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = response.getWriter();
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        JsonObject jsonResponse = new JsonObject();
        ResourceResolver resourceResolver = request.getResourceResolver();
        if (Arrays.asList(request.getRequestPathInfo().getSelectors()).contains(SELECTOR_TRIGGER_DECK_DYNAMO)) {
            String deckName = request.getParameter("deckTitle");
            Resource collectionResource = resourceResolver.getResource(request.getParameter("collectionPath"));
            Resource templateResource = resourceResolver.getResource(request.getParameter("templatePath"));
            Resource masterAssetResource = resourceResolver.getResource(request.getParameter("masterAssetPath"));
            Resource destinationResource = resourceResolver.getResource(request.getParameter("destinationPath"));
            String operationMode = request.getParameter("operationMode");
            String queryString = request.getParameter("queryString");
            String tagValues = request.getParameter("tagValues");
            try {
                if (StringUtils.isEmpty((CharSequence)deckName) || StringUtils.isEmpty((CharSequence)operationMode) || null == templateResource || null == destinationResource) {
                    throw new DynamicDeckDynamoException("Supplied deck name OR operation mode OR template path OR destination path OR operation mode is null/empty. Hence exiting the deck generation process.");
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)DynamicDeckInitiatorPageModel.Mode.COLLECTION.toString(), (CharSequence)operationMode) && null == collectionResource) {
                    throw new DynamicDeckDynamoException("Collection path is expected when COLLECTION is operation mode. Hence exiting the deck generation process.");
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)DynamicDeckInitiatorPageModel.Mode.QUERY.toString(), (CharSequence)operationMode) && StringUtils.isEmpty((CharSequence)queryString)) {
                    throw new DynamicDeckDynamoException("Query string is expected when QUERY is operation mode. Hence exiting the deck generation process.");
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)DynamicDeckInitiatorPageModel.Mode.TAGS.toString(), (CharSequence)operationMode) && StringUtils.isEmpty((CharSequence)tagValues)) {
                    throw new DynamicDeckDynamoException("Tags string is expected when TAGS is operation mode. Hence exiting the deck generation process.");
                }
                String generatedDeckPath = null;
                List<Resource> assetResourceList = null;
                if (StringUtils.equalsIgnoreCase((CharSequence)DynamicDeckInitiatorPageModel.Mode.COLLECTION.toString(), (CharSequence)operationMode)) {
                    assetResourceList = this.dynamicDeckService.fetchAssetListFromCollection(collectionResource, resourceResolver);
                } else if (StringUtils.equalsIgnoreCase((CharSequence)DynamicDeckInitiatorPageModel.Mode.QUERY.toString(), (CharSequence)operationMode)) {
                    assetResourceList = this.dynamicDeckService.fetchAssetListFromQuery(queryString, resourceResolver);
                } else if (StringUtils.equalsIgnoreCase((CharSequence)DynamicDeckInitiatorPageModel.Mode.TAGS.toString(), (CharSequence)operationMode)) {
                    assetResourceList = this.dynamicDeckService.fetchAssetListFromTags(tagValues, resourceResolver);
                } else {
                    throw new DynamicDeckDynamoException("Invalid operation mode supplied. Hence exiting the deck generation process.");
                }
                if (null == assetResourceList || assetResourceList.isEmpty()) {
                    throw new DynamicDeckDynamoException("Asset resource list cannot be null or empty. Hence exiting the deck generation process.");
                }
                generatedDeckPath = this.dynamicDeckService.createDeck(deckName, masterAssetResource, assetResourceList, templateResource, destinationResource, resourceResolver);
                jsonResponse.addProperty(MESSAGE, "Deck generation triggered successfully! Generated deck path = " + generatedDeckPath);
            }
            catch (DynamicDeckDynamoException e) {
                response.setStatus(500);
                jsonResponse.addProperty(MESSAGE, "Deck generation failed! Please check logs for more details.");
                LOGGER.error("Exception occurred while initiating the deck generation", (Throwable)e);
            }
        }
        out.print(new Gson().toJson((JsonElement)jsonResponse));
    }

    public void setDynamicDeckService(DynamicDeckService dynamicDeckService) {
        this.dynamicDeckService = dynamicDeckService;
    }
}

