/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.store.jcr.impl.visitor;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.util.TraversingItemVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNodeVisitor
extends TraversingItemVisitor.Default {
    private static final Logger log = LoggerFactory.getLogger(AbstractNodeVisitor.class);
    private static final long WARN_THRESHOLD = 2000L;
    private final long deltaSaveThreshold;
    private final long startTimeInMs = System.currentTimeMillis();
    private long delta = 0L;
    private long evictionCount = 0L;
    private long loopCounter = 0L;
    private Session session;

    public AbstractNodeVisitor(int maxLevel, long deltaSaveThreshold) {
        super(false, maxLevel);
        this.deltaSaveThreshold = deltaSaveThreshold;
    }

    public void visit(Node node) throws RepositoryException {
        this.session = node.getSession();
        super.visit(node);
    }

    public void close() throws RepositoryException {
        if (this.delta > 0L) {
            this.session.save();
            this.delta = 0L;
        }
    }

    protected void entering(Node node, int level) throws RepositoryException {
        ++this.loopCounter;
        this.logPossibleOverload();
    }

    protected void leaving(Node node, int level) throws RepositoryException {
        this.logPossibleOverload();
    }

    private void logPossibleOverload() {
        long current = System.currentTimeMillis();
        if (this.loopCounter % 10L == 0L && this.startTimeInMs + 2000L < current) {
            log.warn("Visiting the JCR cache with the {} is taking too long! taking {} seconds", (Object)((Object)((Object)this)).getClass().getSimpleName(), (Object)(current - this.startTimeInMs / 1000L));
        }
    }

    public static boolean isCacheEntryNode(Node node) throws RepositoryException {
        return node.hasProperty("isCacheEntryNode");
    }

    public static boolean isEmptyBucketNode(Node node) throws RepositoryException {
        return AbstractNodeVisitor.isBucketNode(node) && !node.hasNodes();
    }

    public static boolean isBucketNode(Node node) throws RepositoryException {
        return node.hasProperty("isBucketNode");
    }

    protected void persistSession() throws RepositoryException {
        if (this.delta > this.deltaSaveThreshold) {
            this.session.save();
            this.delta = 0L;
        }
        ++this.delta;
        ++this.evictionCount;
    }

    public long getEvictionCount() {
        return this.evictionCount;
    }
}

