/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.engine.impl.delegate;

import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.config.impl.HttpCacheConfigComparator;
import com.adobe.acs.commons.httpcache.engine.impl.HttpCacheEngineImpl;
import com.adobe.acs.commons.httpcache.rule.HttpCacheHandlingRule;
import com.adobe.acs.commons.httpcache.store.HttpCacheStore;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCacheEngineBindingsDelegate {
    private static final Logger log = LoggerFactory.getLogger(HttpCacheEngineImpl.class);
    private CopyOnWriteArrayList<HttpCacheConfig> cacheConfigs = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<String, HttpCacheStore> cacheStoresMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, HttpCacheHandlingRule> cacheHandlingRules = new ConcurrentHashMap();
    private final ConcurrentHashMap<HttpCacheConfig, Map<String, Object>> cacheConfigConfigs = new ConcurrentHashMap();

    public void bindHttpCacheConfig(HttpCacheConfig cacheConfig, Map<String, Object> configs) {
        if (!cacheConfig.isValid()) {
            log.info("Http cache config rejected as the request uri is absent.");
            return;
        }
        if (this.cacheConfigs.contains(cacheConfig)) {
            log.trace("Http cache config object already exists in the cacheConfigs map and hence ignored.");
            return;
        }
        CopyOnWriteArrayList<HttpCacheConfig> tmp = new CopyOnWriteArrayList<HttpCacheConfig>(this.cacheConfigs);
        tmp.add(cacheConfig);
        Collections.sort(tmp, new HttpCacheConfigComparator());
        this.cacheConfigs = tmp;
        this.cacheConfigConfigs.put(cacheConfig, configs);
        log.debug("Total number of cache configs added: {}", (Object)this.cacheConfigs.size());
    }

    public void unbindHttpCacheConfig(HttpCacheConfig cacheConfig) {
        if (this.cacheConfigs.contains(cacheConfig)) {
            if (this.cacheStoresMap.containsKey(cacheConfig.getCacheStoreName())) {
                this.cacheStoresMap.get(cacheConfig.getCacheStoreName()).invalidate(cacheConfig);
            } else {
                log.debug("Configured cache store is unavailable and hence nothing to invalidate.");
            }
            this.cacheConfigs.remove(cacheConfig);
            this.cacheConfigConfigs.remove(cacheConfig);
            log.debug("Total number of cache configs after removal: {}", (Object)this.cacheConfigs.size());
            return;
        }
        log.debug("This cache config entry was not bound and hence nothing to unbind.");
    }

    public void bindHttpCacheStore(HttpCacheStore cacheStore) {
        String cacheStoreType = cacheStore.getStoreType();
        if (cacheStoreType != null && this.cacheStoresMap.putIfAbsent(cacheStoreType, cacheStore) == null) {
            log.debug("HTTP Cache Store [ {} -> ADDED ] for a total of [ {} ]", (Object)cacheStore.getStoreType(), (Object)this.cacheStoresMap.size());
        }
    }

    public void unbindHttpCacheStore(HttpCacheStore cacheStore) {
        String cacheStoreType = cacheStore.getStoreType();
        if (cacheStoreType != null && this.cacheStoresMap.remove(cacheStoreType) != null) {
            log.debug("HTTP Cache Store [ {} -> REMOVED ] for a total of [ {} ]", (Object)cacheStore.getStoreType(), (Object)this.cacheStoresMap.size());
        }
    }

    public void bindHttpCacheHandlingRule(HttpCacheHandlingRule cacheHandlingRule, Map<String, Object> properties) {
        if (this.cacheHandlingRules.putIfAbsent(this.getServicePid(properties), cacheHandlingRule) == null) {
            log.debug("Cache handling rule implementation {} has been added", (Object)cacheHandlingRule.getClass().getName());
            log.debug("Total number of cache handling rule available after addition: {}", (Object)this.cacheHandlingRules.size());
        }
    }

    public void unbindHttpCacheHandlingRule(HttpCacheHandlingRule cacheHandlingRule, Map<String, Object> configs) {
        if (this.cacheHandlingRules.remove(this.getServicePid(configs)) != null) {
            log.debug("Cache handling rule removed - {}.", (Object)cacheHandlingRule.getClass().getName());
            log.debug("Total number of cache handling rules available after removal: {}", (Object)this.cacheHandlingRules.size());
        }
    }

    public List<HttpCacheConfig> getCacheConfigs() {
        return Collections.unmodifiableList(this.cacheConfigs);
    }

    public Map<String, HttpCacheStore> getCacheStoresMap() {
        return this.cacheStoresMap;
    }

    public Map<String, HttpCacheHandlingRule> getCacheHandlingRules() {
        return this.cacheHandlingRules;
    }

    public Map<HttpCacheConfig, Map<String, Object>> getCacheConfigConfigs() {
        return this.cacheConfigConfigs;
    }

    private String getServicePid(Map<String, Object> configs) {
        String servicePid = PropertiesUtil.toString((Object)configs.get("service.pid"), (String)"");
        if (StringUtils.isBlank((String)servicePid)) {
            servicePid = PropertiesUtil.toString((Object)configs.get("component.name"), (String)"");
        }
        return servicePid;
    }
}

