/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.httpcache.config.impl;

import com.adobe.acs.commons.httpcache.config.HttpCacheConfig;
import com.adobe.acs.commons.httpcache.config.HttpCacheConfigExtension;
import com.adobe.acs.commons.httpcache.config.impl.AbstractKeyValueExtension;
import com.adobe.acs.commons.httpcache.keys.CacheKeyFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(configurationPolicy=ConfigurationPolicy.REQUIRE, service={HttpCacheConfigExtension.class, CacheKeyFactory.class}, property={"service.ranking:Integer=10"})
@Designate(ocd=Config.class, factory=true)
public class RequestParameterHttpCacheConfigExtension
extends AbstractKeyValueExtension
implements CacheKeyFactory,
HttpCacheConfigExtension {
    private Map<String, String[]> allowedParameters;
    private String cacheKeyId;

    @Override
    public Map<String, String[]> getAllowedKeyValues() {
        return this.allowedParameters;
    }

    @Override
    public boolean accepts(SlingHttpServletRequest request, HttpCacheConfig cacheConfig, Map<String, String[]> allowedKeyValues) {
        for (Map.Entry<String, String[]> entry : allowedKeyValues.entrySet()) {
            if (!request.getParameterMap().keySet().contains(entry.getKey())) continue;
            String[] parameterValues = (String[])request.getParameterMap().get(entry.getKey());
            if (!ArrayUtils.isEmpty((Object[])entry.getValue()) && !CollectionUtils.containsAny(Arrays.asList(entry.getValue()), Arrays.asList(parameterValues))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getActualValue(String key, SlingHttpServletRequest request) {
        return request.getParameter(key);
    }

    @Override
    public String getCacheKeyId() {
        return "[Request Parameter: " + this.cacheKeyId + "]";
    }

    @Activate
    public void activate(Config config) {
        this.allowedParameters = new HashMap<String, String[]>();
        this.allowedParameters.put(config.httpcache_config_extension_requestparameter(), config.httpcache_config_extension_requestparameter_values());
        this.cacheKeyId = UUID.randomUUID().toString();
    }

    @ObjectClassDefinition(name="ACS AEM Commons - HTTP Cache - Extension - Request Parameter", description="Defined Request Parameters / Request Parameter values that will be allowed for this extension (HttpCacheConfig and CacheKeyFactory).")
    public static @interface Config {
        @AttributeDefinition(name="Allow request headers", description="The HTTP Request Parameter to check.")
        public String httpcache_config_extension_requestparameter() default "";

        @AttributeDefinition(name="Allowed request header values", description="This request is only accepted for caching when its named request parameter (above) contains one of these values. Leave blank for any value.")
        public String[] httpcache_config_extension_requestparameter_values() default {};

        @AttributeDefinition(name="Config Name")
        public String config_name() default "";

        @AttributeDefinition
        public String webconsole_configurationFactory_nameHint() default "Request Parameters: [ {httpcache.config.extension.requestparameter} ] Request Parameter values: [ {httpcache.config.extension.requestparameter.values} ] Config name: [ {config.name} ]";
    }
}

